/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.baseobjects.coll.NamedObjectSet;
import de.memtext.db.DBServletException;
import de.memtext.db.MemtextPool;
import de.memtext.tree.KeyParentEqualException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.dbcp.PoolingDriver;

public class MemtextPools
extends NamedObjectSet {
    private NamedObjectSet pools = new NamedObjectSet();

    public synchronized Connection getConnection(String poolname) throws SQLException {
        if (this.pools.size() == 0) {
            throw new IllegalStateException("Kein ConnectionPool gefunden.");
        }
        if (!this.pools.containsItemWithName(poolname)) {
            throw new SQLException("Kein ConnectionPool f\u00fcr Mandant:" + poolname + " gefunden");
        }
        String pooldrv = "jdbc:apache:commons:dbcp:" + poolname;
        if (DriverManager.getDriver(pooldrv) == null) {
            String msg = "Kein ConnectionPool gefunden ";
            if (!poolname.equals("default")) {
                msg = msg + " f\u00fcr Mandant " + poolname;
            }
            throw new SQLException(msg);
        }
        return DriverManager.getConnection(pooldrv);
    }

    public MemtextPool get(String poolname) {
        if (!this.pools.containsItemWithName(poolname)) {
            throw new IllegalStateException("Kein ConnectionPool (" + poolname + ") vorhanden");
        }
        return (MemtextPool)this.pools.getByName(poolname);
    }

    public void init(String subpath, Class poolclass, String nameAppendix) throws SQLException, IOException, DBServletException {
        if (nameAppendix == null) {
            nameAppendix = "";
        }
        Class[] params = new Class[]{String.class, String.class};
        try {
            File f;
            Constructor constructor = poolclass.getConstructor(params);
            String db_extfile = "mandanten.cfg";
            if (db_extfile.indexOf(File.separator) == -1) {
                URL url = MemtextPools.class.getProtectionDomain().getCodeSource().getLocation();
                File myJar = new File(url.getFile());
                File myPath = new File(myJar.getParent());
                String pfad = myPath.getParent();
                if (subpath != null) {
                    pfad = pfad + File.separator + subpath;
                }
                db_extfile = pfad + File.separator + db_extfile;
            }
            if (!(f = new File(db_extfile)).exists()) {
                System.out.print("Aufbau Datenbank-ConnectionPool");
                Object[] args = new Object[]{"default", subpath};
                MemtextPool connectionPool = (MemtextPool)constructor.newInstance(args);
                System.out.println(" OK");
                System.out.println("           public/private key " + (connectionPool.hasDSAHandler() ? " aktiv " : " nicht aktiv"));
                this.pools.add(connectionPool);
            } else {
                String line;
                FileReader fr = new FileReader(f);
                BufferedReader bfr = new BufferedReader(fr);
                while ((line = bfr.readLine()) != null) {
                    System.out.print("Aufbau Datenbank-ConnectionPool f\u00fcr " + line);
                    Object[] args = new Object[]{line, subpath};
                    MemtextPool connectionPool = (MemtextPool)constructor.newInstance(args);
                    System.out.println("OK");
                    System.out.println("           public/private key" + (connectionPool.hasDSAHandler() ? " aktiv " : " nicht aktiv"));
                    this.pools.add(connectionPool);
                }
                bfr.close();
                fr.close();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new DBServletException(e.toString());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new DBServletException(e.toString());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new DBServletException(e.toString());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new DBServletException(e.toString());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new DBServletException(e.toString());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new DBServletException(e.toString());
        }
    }

    public void closeAll() throws Exception {
        for (MemtextPool pool : this.pools) {
            pool.close();
        }
    }

    public void main(String[] args) {
        try {
            this.init("xx", MemtextPool.class, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean i = true;
    }

    public void invalidate(String poolname, Connection con) throws DBServletException {
        if (!this.pools.containsItemWithName(poolname)) {
            throw new DBServletException("Kann Connection nicht invalidieren - kein ConnectionPool " + poolname + " gefunden.");
        }
        try {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
            driver.getConnectionPool(poolname).invalidateObject((Object)con);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DBServletException("Invalidating connection failed -" + e);
        }
    }

    public void resetAllPools() throws TransformerConfigurationException, KeyParentEqualException, SQLException, DBServletException {
        for (MemtextPool aPool : this.pools) {
            aPool.init();
        }
    }

    public void clearLogFiles() throws IOException {
        for (MemtextPool aPool : this.pools) {
            aPool.clearLogFiles();
        }
    }
}

