/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.datasource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.service.datasource.IDatasourceManager;
import org.saiku.service.util.exception.SaikuServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathResourceDatasourceManager
implements IDatasourceManager {
    private URL repoURL;
    private Map<String, SaikuDatasource> datasources = Collections.synchronizedMap(new HashMap());

    public ClassPathResourceDatasourceManager() {
    }

    public ClassPathResourceDatasourceManager(String path) {
        try {
            this.setPath(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPath(String path) {
        try {
            FileSystemManager fileSystemManager = VFS.getManager();
            FileObject fileObject = fileSystemManager.resolveFile(path);
            if (fileObject == null) {
                throw new IOException("File cannot be resolved: " + path);
            }
            if (!fileObject.exists()) {
                throw new IOException("File does not exist: " + path);
            }
            this.repoURL = fileObject.getURL();
            if (this.repoURL == null) {
                throw new Exception("Cannot load connection repository from path: " + path);
            }
            this.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load() {
        block4: {
            this.datasources.clear();
            try {
                if (this.repoURL != null) {
                    File[] files;
                    for (File file : files = new File(this.repoURL.getFile()).listFiles()) {
                        if (file.isHidden()) continue;
                        Properties props = new Properties();
                        props.load(new FileInputStream(file));
                        String name = props.getProperty("name");
                        String type = props.getProperty("type");
                        if (name == null || type == null) continue;
                        SaikuDatasource.Type t = SaikuDatasource.Type.valueOf(type.toUpperCase());
                        SaikuDatasource ds = new SaikuDatasource(name, t, props);
                        this.datasources.put(name, ds);
                    }
                    break block4;
                }
                throw new Exception("repo URL is null");
            }
            catch (Exception e) {
                throw new SaikuServiceException(e.getMessage(), e);
            }
        }
    }

    @Override
    public SaikuDatasource addDatasource(SaikuDatasource datasource) {
        try {
            String uri = this.repoURL.toURI().toString();
            if (uri != null && datasource != null) {
                File dsFile = new File(new URI(uri = uri + datasource.getName().replace(" ", "_")));
                if (dsFile.exists()) {
                    dsFile.delete();
                } else {
                    dsFile.createNewFile();
                }
                FileWriter fw = new FileWriter(dsFile);
                Properties props = datasource.getProperties();
                props.store(fw, null);
                fw.close();
                this.datasources.put(datasource.getName(), datasource);
                return datasource;
            }
            throw new SaikuServiceException("Cannot save datasource because uri or datasource is null uri(" + (uri == null) + ")");
        }
        catch (Exception e) {
            throw new SaikuServiceException("Error saving datasource", e);
        }
    }

    @Override
    public SaikuDatasource setDatasource(SaikuDatasource datasource) {
        return this.addDatasource(datasource);
    }

    @Override
    public List<SaikuDatasource> addDatasources(List<SaikuDatasource> datasources) {
        for (SaikuDatasource ds : datasources) {
            this.addDatasource(ds);
        }
        return datasources;
    }

    @Override
    public boolean removeDatasource(String datasourceName) {
        try {
            File dsFile;
            String uri = this.repoURL.toURI().toString();
            if (uri != null && (dsFile = new File(new URI(uri = uri + datasourceName))).delete()) {
                this.datasources.remove(datasourceName);
                return true;
            }
            throw new Exception("Cannot delete datasource file uri:" + uri);
        }
        catch (Exception e) {
            throw new SaikuServiceException("Cannot delete datasource", e);
        }
    }

    @Override
    public Map<String, SaikuDatasource> getDatasources() {
        return this.datasources;
    }

    @Override
    public SaikuDatasource getDatasource(String datasourceName) {
        return this.datasources.get(datasourceName);
    }
}

