/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffConfig;
import de.statspez.pleditor.generator.codegen.diff.DiffStructure;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPLMaterial;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public final class DiffStructureBuilder
extends Traverser {
    public static final String CONTEXT_SEPARATOR = "___PKT___";
    public static final String CONTEXT_THEMENBEREICH = "___THEMENBEREICH___";
    private DiffStructure diffStructure = null;
    private Stack tbHierarchieStack = null;
    private Map visitedTbNameMap;
    private DiffConfig diffConfig;

    public static DiffStructure build(MetaPlausibilisierung plausibilisierung, DiffConfig diffConfig) {
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        DiffStructureBuilder builder = new DiffStructureBuilder(diffConfig);
        return builder.buildIntern(plausibilisierung);
    }

    public static DiffStructure build(Reader edtSource, DiffConfig diffConfig) throws Exception {
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        DiffStructureBuilder builder = new DiffStructureBuilder(diffConfig);
        return builder.buildIntern(edtSource);
    }

    private DiffStructureBuilder(DiffConfig diffConfig) {
        this.diffConfig = diffConfig;
    }

    @Override
    public void visitMerkmal(MetaMerkmal anObject) {
        MetaCustomMerkmal merkmal = (MetaCustomMerkmal)anObject;
        this.tbHierarchieStack.push(anObject);
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), merkmal);
        if (merkmal.getKlasseWertebereich() != null) {
            merkmal.getKlasseWertebereich().accept(this);
        }
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe anObject) {
        this.tbHierarchieStack.push(anObject);
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), anObject);
        Iterator it = anObject.getAuspraegungsComps().getAuspraegungen();
        while (it.hasNext()) {
            ((MetaAuspraegung)it.next()).accept(this);
        }
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitPLAuspraegung(MetaPLAuspraegung anObject) {
        this.tbHierarchieStack.push(anObject);
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), anObject);
        int i = 0;
        while (i < anObject.sizeOfAuspraegungen()) {
            anObject.getFromAuspraegungen(i).accept(this);
            ++i;
        }
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitPLAblauf(MetaPLAblauf anObject) {
        this.tbHierarchieStack.push(anObject);
        MetaCustomAblauf ablauf = (MetaCustomAblauf)anObject;
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), ablauf);
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung anObject) {
        MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)anObject;
        this.diffStructure.setMetaPlausibilisierung(plausi);
        if (plausi.rootThemenbereich() == null) {
            throw new NullPointerException("In der Plausibilisierung ist kein Hauptthemenbereich festgelegt!");
        }
        this.visitThemenbereich(plausi.rootThemenbereich());
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion anObject) {
        this.tbHierarchieStack.push(anObject);
        MetaCustomFunktion funktion = (MetaCustomFunktion)anObject;
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), funktion);
        this.visitElements(funktion.getParameter());
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitPLParameter(MetaPLParameter anObject) {
        this.tbHierarchieStack.push(anObject);
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), anObject);
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert anObject) {
        this.tbHierarchieStack.push(anObject);
        MetaCustomInitwert initWert = (MetaCustomInitwert)anObject;
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), initWert);
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitPLMaterial(MetaPLMaterial anObject) {
        this.tbHierarchieStack.push(anObject);
        MetaCustomPLMaterial plMaterial = (MetaCustomPLMaterial)anObject;
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), plMaterial);
        if (!this.visitedTbNameMap.containsKey(plMaterial.getThemenbereich().getName())) {
            this.visitThemenbereich(plMaterial.getThemenbereich());
        }
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitPLPruefung(MetaPLPruefung anObject) {
        this.tbHierarchieStack.push(anObject);
        MetaCustomPruefung pruefung = (MetaCustomPruefung)anObject;
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), pruefung);
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitPLVariable(MetaPLVariable anObject) {
        this.tbHierarchieStack.push(anObject);
        MetaCustomVariable variable = (MetaCustomVariable)anObject;
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), variable);
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitTBFeld(MetaTBFeld anObject) {
        MetaCustomTBFeld field = (MetaCustomTBFeld)anObject;
        this.tbHierarchieStack.push(field);
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), field);
        if (field.getKlasse() instanceof MetaThemenbereich) {
            this.visitThemenbereich((MetaThemenbereich)field.getKlasse());
        } else if (field.getKlasse() instanceof MetaMerkmal) {
            this.visitMerkmal((MetaMerkmal)field.getKlasse());
        }
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitTBMaterialReferenz(MetaTBMaterialReferenz anObject) {
        this.tbHierarchieStack.push(anObject);
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), anObject);
        if (this.diffConfig.isCheckReferencedPLMaterials()) {
            this.visitPLMaterial(anObject.getMaterialbeschreibung());
        }
        this.tbHierarchieStack.pop();
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich anObject) {
        MetaCustomThemenbereich tb = (MetaCustomThemenbereich)anObject;
        this.tbHierarchieStack.push(CONTEXT_THEMENBEREICH);
        this.diffStructure.addMetaElement(this.getTbHierarchyString(), tb);
        this.visitedTbNameMap.put(tb.getName(), null);
        this.visitElements(tb.getFelder());
        this.visitElements(tb.getVariablen());
        this.visitElements(tb.getFunktionen());
        this.visitElements(tb.getAblaeufe());
        this.visitElements(tb.getPruefungen());
        this.visitElements(tb.getInitialisierungswerte());
        this.visitElements(tb.getMaterialreferenzen());
        this.visitedTbNameMap.remove(tb.getName());
        this.tbHierarchieStack.pop();
    }

    private synchronized DiffStructure buildIntern(MetaPlausibilisierung plausibilisierung) {
        if (plausibilisierung == null) {
            throw new NullPointerException();
        }
        this.tbHierarchieStack = new Stack();
        this.diffStructure = new DiffStructure();
        this.visitedTbNameMap = new HashMap();
        this.visitPlausibilisierung(plausibilisierung);
        return this.diffStructure;
    }

    private synchronized DiffStructure buildIntern(Reader edtSource) throws Exception {
        if (edtSource == null) {
            throw new NullPointerException();
        }
        IntermediateLanguageParser parser = new IntermediateLanguageParser();
        MetaPlausibilisierung plausibilisierung = (MetaPlausibilisierung)parser.parse(edtSource);
        return this.buildIntern(plausibilisierung);
    }

    private String getTbHierarchyString() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.tbHierarchieStack.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            String name = null;
            if (object instanceof MetaStatspezObjekt) {
                name = ((MetaStatspezObjekt)object).getName();
            } else if (object instanceof MetaPLInitwert) {
                name = ((MetaPLInitwert)object).getName();
            } else if (object instanceof MetaPLVariable) {
                name = ((MetaPLVariable)object).getName();
            } else if (object instanceof MetaTBMaterialReferenz) {
                name = ((MetaTBMaterialReferenz)object).getName();
            } else if (object instanceof MetaPLAuspraegung) {
                name = ((MetaPLAuspraegung)object).getName();
            } else if (object instanceof MetaPLParameter) {
                name = ((MetaPLParameter)object).getName();
            } else if (object != null) {
                name = object.toString();
            }
            buffer.append(name);
            if (!iterator.hasNext()) continue;
            buffer.append(CONTEXT_SEPARATOR);
        }
        return buffer.toString();
    }
}

