/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppProgramCodeGenerator;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;

public class CppExternalProgramCodeGenerator
extends CppProgramCodeGenerator {
    @Override
    public void visitProgram(MetaProgram aProgram) {
        if (aProgram.isExternal() && aProgram.getExternalElement() instanceof MetaCustomFunktion) {
            MetaCustomFunktion externeFunktion = (MetaCustomFunktion)aProgram.getExternalElement();
            this.indentNewLine();
            this.out.print("try");
            this.openBlock();
            this.indentNewLine();
            this.out.print("Value* ___ext_erg = context->getExternalFunction(\"");
            this.out.print(externeFunktion.getName());
            this.out.print("\")(context");
            if (aProgram.numberOfParameters() > 0) {
                int i = 0;
                while (i < aProgram.numberOfParameters()) {
                    this.out.print(", ");
                    aProgram.parameterAt(i).accept(this);
                    ++i;
                }
            }
            this.out.print(");");
            this.leaveCurrentSection();
            this.indentNewLine();
            this.out.print("return ___ext_erg;");
            this.closeBlock();
            this.indentNewLine();
            this.out.print("catch (PlausiException& __exeption)");
            this.openBlock();
            this.indentNewLine();
            this.out.print("context->getLogger()->error() << \"Fehler beim Ansprechen der externen Funktion: " + aProgram.name() + " (\" << __exeption.getMessage() << \")\";");
            this.closeBlock();
            this.indentNewLine();
            this.out.print("catch (...)");
            this.openBlock();
            this.indentNewLine();
            this.out.print("context->getLogger()->error() << \"Fehler beim Ansprechen der externen Funktion: " + aProgram.name() + "\";");
            this.closeBlock();
            this.leaveCurrentSection();
            this.indentNewLine();
            this.out.print("return context->createInvalidValue();");
        }
    }

    @Override
    public void visitProgramParameter(MetaProgramParameter aParam) {
        this.out.print(aParam.name().value());
        this.out.print(".get(context)");
    }
}

