/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.Desktop;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.core.HtmlBrowserComponent;
import org.netbeans.core.IDESettings;
import org.netbeans.core.ui.SwingBrowser;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.windows.TopComponent;

public final class NbURLDisplayer
extends HtmlBrowser.URLDisplayer {
    private NbBrowser htmlViewer;

    public void showURL(final URL uRL) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                if (NbURLDisplayer.this.htmlViewer == null) {
                    NbURLDisplayer.this.htmlViewer = new NbBrowser();
                }
                NbURLDisplayer.this.htmlViewer.showUrl(uRL);
            }
        });
    }

    public void showURLExternal(final URL uRL) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                if (NbURLDisplayer.this.htmlViewer == null) {
                    NbURLDisplayer.this.htmlViewer = new NbBrowser();
                }
                NbURLDisplayer.this.htmlViewer.showUrlExternal(uRL);
            }
        });
    }

    private static final class DesktopBrowser
    implements HtmlBrowser.Factory {
        private final Desktop desktop;

        public DesktopBrowser(Desktop desktop) {
            this.desktop = desktop;
        }

        public HtmlBrowser.Impl createHtmlBrowserImpl() {
            return new HtmlBrowser.Impl(){
                private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
                private URL url;

                public void setURL(URL uRL) {
                    this.url = uRL;
                    try {
                        DesktopBrowser.this.desktop.browse(uRL.toURI());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(NbURLDisplayer.class.getName()).log(Level.INFO, "showing: " + uRL, exception);
                    }
                }

                public URL getURL() {
                    return this.url;
                }

                public void reloadDocument() {
                    this.setURL(this.url);
                }

                public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                    this.pcs.addPropertyChangeListener(propertyChangeListener);
                }

                public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                    this.pcs.removePropertyChangeListener(propertyChangeListener);
                }

                public Component getComponent() {
                    return null;
                }

                public void stopLoading() {
                }

                public String getStatusMessage() {
                    return "";
                }

                public String getTitle() {
                    return "";
                }

                public boolean isForward() {
                    return false;
                }

                public void forward() {
                }

                public boolean isBackward() {
                    return false;
                }

                public void backward() {
                }

                public boolean isHistory() {
                    return false;
                }

                public void showHistory() {
                }
            };
        }
    }

    private static class NbBrowser {
        private HtmlBrowserComponent brComp;
        private HtmlBrowserComponent externalBrowser;
        private PreferenceChangeListener idePCL;
        private static Lookup.Result factoryResult = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);

        public NbBrowser() {
            Object object = IDESettings.getWWWBrowser();
            if (object == null) {
                object = new SwingBrowser();
            }
            if (object.createHtmlBrowserImpl().getComponent() != null) {
                this.brComp = this.findOpenedBrowserComponent();
            }
            if (this.brComp == null) {
                this.brComp = new HtmlBrowserComponent((HtmlBrowser.Factory)object, true, true);
                this.brComp.putClientProperty("TabPolicy", "HideWhenAlone");
            }
            if ((object = IDESettings.getExternalWWWBrowser()) == null) {
                Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                object = desktop != null && desktop.isSupported(Desktop.Action.BROWSE) ? new DesktopBrowser(desktop) : new SwingBrowser();
            }
            this.externalBrowser = new HtmlBrowserComponent((HtmlBrowser.Factory)object, true, true);
            this.setListener();
        }

        private HtmlBrowserComponent findOpenedBrowserComponent() {
            for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
                if (!(topComponent instanceof HtmlBrowserComponent)) continue;
                return (HtmlBrowserComponent)topComponent;
            }
            return null;
        }

        private void showUrl(URL uRL) {
            this.brComp.setURLAndOpen(uRL);
        }

        private void showUrlExternal(URL uRL) {
            this.externalBrowser.setURLAndOpen(uRL);
        }

        private void setListener() {
            if (this.idePCL != null) {
                return;
            }
            try {
                this.idePCL = new PreferenceChangeListener(){

                    @Override
                    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                        if ("WWWBrowser".equals(preferenceChangeEvent.getKey())) {
                            ((NbURLDisplayer)HtmlBrowser.URLDisplayer.getDefault()).htmlViewer = null;
                            if (NbBrowser.this.idePCL != null) {
                                IDESettings.getPreferences().removePreferenceChangeListener(NbBrowser.this.idePCL);
                                NbBrowser.this.idePCL = null;
                                NbBrowser.this.brComp = null;
                            }
                        }
                    }
                };
                IDESettings.getPreferences().addPreferenceChangeListener(this.idePCL);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        static {
            factoryResult.allItems();
            factoryResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ((NbURLDisplayer)HtmlBrowser.URLDisplayer.getDefault()).htmlViewer = null;
                }
            });
        }
    }
}

