/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

public final class BulkDataUtility {
    private BulkDataUtility() {
    }

    public static void pushUp(Object[] data, boolean[] selection) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (selection == null) {
            throw new NullPointerException();
        }
        if (selection.length != data.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 1; i < data.length; ++i) {
            Object o = data[i];
            boolean selected = selection[i];
            if (!selected || selection[i - 1]) continue;
            data[i] = data[i - 1];
            selection[i] = selection[i - 1];
            data[i - 1] = o;
            selection[i - 1] = true;
        }
    }

    public static void pushDown(Object[] data, boolean[] selection) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (selection == null) {
            throw new NullPointerException();
        }
        if (selection.length != data.length) {
            throw new IllegalArgumentException();
        }
        for (int i = data.length - 2; i >= 0; --i) {
            Object o = data[i];
            boolean selected = selection[i];
            if (!selected || selection[i + 1]) continue;
            data[i] = data[i + 1];
            selection[i] = selection[i + 1];
            data[i + 1] = o;
            selection[i + 1] = true;
        }
    }

    public static void pushUpSingleValue(Object[] data, Object selection) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (selection == null) {
            throw new NullPointerException();
        }
        for (int i = 1; i < data.length; ++i) {
            boolean selected;
            Object o = data[i];
            boolean bl = selected = selection == o;
            if (!selected) continue;
            data[i] = data[i - 1];
            data[i - 1] = o;
        }
    }

    public static void pushDownSingleValue(Object[] data, Object selection) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (selection == null) {
            throw new NullPointerException();
        }
        for (int i = data.length - 2; i >= 0; --i) {
            boolean selected;
            Object o = data[i];
            boolean bl = selected = selection == o;
            if (!selected) continue;
            data[i] = data[i + 1];
            data[i + 1] = o;
        }
    }
}

