/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.writetolog;

import java.util.Date;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryWriteToLog
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryWriteToLog.class;
    @Deprecated
    public LogLevel entryLogLevel;
    private String logsubject = null;
    private String logmessage = null;

    public JobEntryWriteToLog(String n) {
        super(n, "");
    }

    public JobEntryWriteToLog() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryWriteToLog je = (JobEntryWriteToLog)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"logmessage", (String)this.logmessage));
        retval.append("      ").append(XMLHandler.addTagValue((String)"loglevel", this.entryLogLevel == null ? null : this.entryLogLevel.getCode()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logsubject", (String)this.logsubject));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.logmessage = XMLHandler.getTagValue((Node)entrynode, (String)"logmessage");
            this.entryLogLevel = LogLevel.getLogLevelForCode((String)XMLHandler.getTagValue((Node)entrynode, (String)"loglevel"));
            this.logsubject = XMLHandler.getTagValue((Node)entrynode, (String)"logsubject");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"WriteToLog.Error.UnableToLoadFromXML.Label", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.logmessage = rep.getJobEntryAttributeString(id_jobentry, "logmessage");
            this.entryLogLevel = LogLevel.getLogLevelForCode((String)rep.getJobEntryAttributeString(id_jobentry, "loglevel"));
            this.logsubject = rep.getJobEntryAttributeString(id_jobentry, "logsubject");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"WriteToLog.Error.UnableToLoadFromRepository.Label", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logmessage", this.logmessage);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "loglevel", this.entryLogLevel != null ? this.entryLogLevel.getCode() : "");
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logsubject", this.logsubject);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"WriteToLog.Error.UnableToSaveToRepository.Label", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    public boolean evaluate(Result result) {
        LogWriterObject logWriterObject = new LogWriterObject(this.getRealLogSubject(), this, this.parentJob.getLogLevel());
        LogChannelInterface logChannel = logWriterObject.getLogChannel();
        String message = this.getRealLogMessage();
        if (Const.isEmpty((String)message)) {
            return true;
        }
        try {
            switch (logWriterObject.getLogLevel()) {
                case ERROR: {
                    logChannel.logError(message + Const.CR);
                    break;
                }
                case MINIMAL: {
                    logChannel.logMinimal(message + Const.CR);
                    break;
                }
                case BASIC: {
                    logChannel.logBasic(message + Const.CR);
                    break;
                }
                case DETAILED: {
                    logChannel.logDetailed(message + Const.CR);
                    break;
                }
                case DEBUG: {
                    logChannel.logDebug(message + Const.CR);
                    break;
                }
                case ROWLEVEL: {
                    logChannel.logRowlevel(message + Const.CR);
                    break;
                }
            }
            return true;
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.log.logError(BaseMessages.getString(PKG, (String)"WriteToLog.Error.Label", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"WriteToLog.Error.Description", (String[])new String[0]) + " : " + e.toString()});
            return false;
        }
    }

    @Override
    public Result execute(Result prev_result, int nr) {
        prev_result.setResult(this.evaluate(prev_result));
        return prev_result;
    }

    @Override
    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    public String getRealLogMessage() {
        return Const.NVL((String)this.environmentSubstitute(this.getLogMessage()), (String)"");
    }

    public String getRealLogSubject() {
        return Const.NVL((String)this.environmentSubstitute(this.getLogSubject()), (String)"");
    }

    public String getLogMessage() {
        if (this.logmessage == null) {
            this.logmessage = "";
        }
        return this.logmessage;
    }

    public String getLogSubject() {
        if (this.logsubject == null) {
            this.logsubject = "";
        }
        return this.logsubject;
    }

    public void setLogMessage(String s) {
        this.logmessage = s;
    }

    public void setLogSubject(String logsubjectin) {
        this.logsubject = logsubjectin;
    }

    public LogLevel getEntryLogLevel() {
        return this.entryLogLevel;
    }

    public void setEntryLogLevel(LogLevel in) {
        this.entryLogLevel = in;
    }

    private class LogWriterObject
    implements LoggingObjectInterface {
        private LogChannelInterface writerLog;
        private LogLevel logLevel;
        private LoggingObjectInterface parent;
        private String subject;
        private String containerObjectId;

        public LogWriterObject(String subject, LoggingObjectInterface parent, LogLevel logLevel) {
            this.subject = subject;
            this.parent = parent;
            this.logLevel = logLevel;
            this.writerLog = new LogChannel((Object)this, parent);
            this.containerObjectId = this.writerLog.getContainerObjectId();
        }

        public String getFilename() {
            return null;
        }

        public String getLogChannelId() {
            return this.writerLog.getLogChannelId();
        }

        public String getObjectCopy() {
            return null;
        }

        public ObjectId getObjectId() {
            return null;
        }

        public String getObjectName() {
            return this.subject;
        }

        public ObjectRevision getObjectRevision() {
            return null;
        }

        public LoggingObjectType getObjectType() {
            return LoggingObjectType.STEP;
        }

        public LoggingObjectInterface getParent() {
            return this.parent;
        }

        public RepositoryDirectory getRepositoryDirectory() {
            return null;
        }

        public LogChannelInterface getLogChannel() {
            return this.writerLog;
        }

        public LogLevel getLogLevel() {
            return this.logLevel;
        }

        public String getContainerObjectId() {
            return this.containerObjectId;
        }

        public Date getRegistrationDate() {
            return null;
        }

        public boolean isGatheringMetrics() {
            return JobEntryWriteToLog.this.log.isGatheringMetrics();
        }

        public void setGatheringMetrics(boolean gatheringMetrics) {
            JobEntryWriteToLog.this.log.setGatheringMetrics(gatheringMetrics);
        }

        public boolean isForcingSeparateLogging() {
            return JobEntryWriteToLog.this.log.isForcingSeparateLogging();
        }

        public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
            JobEntryWriteToLog.this.log.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }
}

