/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.laf;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import org.pentaho.di.core.Const;
import org.pentaho.di.laf.OverlayProperties;
import org.pentaho.di.laf.PropertyHandler;

public class OverlayPropertyHandler
implements PropertyHandler {
    protected static final String propFile = "ui/laf.properties";
    private static PropertyHandler instance = null;
    private LinkedList<OverlayProperties> propList = new LinkedList();

    public OverlayPropertyHandler() {
        this.initProps();
    }

    public static PropertyHandler getInstance() {
        if (instance == null) {
            instance = new OverlayPropertyHandler();
        }
        return instance;
    }

    protected boolean loadAltProps() {
        String altFile = Const.getEnvironmentVariable("org.pentaho.di.laf.alt", null);
        if (altFile != null) {
            return this.loadProps(altFile);
        }
        return false;
    }

    private boolean initProps() {
        boolean flag = this.loadProps(propFile);
        return this.loadAltProps() || flag;
    }

    @Override
    public String getProperty(String key) {
        String s = null;
        Iterator i = this.propList.iterator();
        while (i.hasNext()) {
            s = ((OverlayProperties)i.next()).getProperty(key);
            if (s == null) continue;
            return s;
        }
        return s;
    }

    public static String getLAFProp(String key) {
        return OverlayPropertyHandler.getInstance().getProperty(key);
    }

    @Override
    public boolean loadProps(String filename) {
        try {
            OverlayProperties ph = new OverlayProperties(filename);
            this.propList.addFirst(ph);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getProperty(String key, String defValue) {
        String s = this.getProperty(key);
        if (s != null) {
            return s;
        }
        return defValue;
    }

    private URL getURL(String filename) throws MalformedURLException {
        URL url;
        File file = new File(filename);
        if (file.exists()) {
            url = file.toURI().toURL();
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            url = classLoader.getResource(filename);
        }
        return url;
    }

    @Override
    public boolean exists(String filename) {
        try {
            return this.getURL(filename) != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

