/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.vfs.configuration;

import java.io.IOException;
import java.lang.reflect.Method;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.vfs.configuration.IKettleFileSystemConfigBuilder;
import org.pentaho.di.core.vfs.configuration.KettleGenericFileSystemConfigBuilder;
import org.pentaho.di.core.vfs.configuration.KettleSftpFileSystemConfigBuilder;
import org.pentaho.di.i18n.BaseMessages;

public class KettleFileSystemConfigBuilderFactory {
    private static Class<?> PKG = KettleVFS.class;

    public static IKettleFileSystemConfigBuilder getConfigBuilder(VariableSpace varSpace, String scheme) throws IOException {
        IKettleFileSystemConfigBuilder result = null;
        String parserClass = varSpace.getVariable("vfs." + scheme + ".config.parser");
        if (parserClass != null) {
            try {
                Class<?> configBuilderClass = KettleFileSystemConfigBuilderFactory.class.getClassLoader().loadClass(parserClass);
                Method mGetInstance = configBuilderClass.getMethod("getInstance", new Class[0]);
                if (mGetInstance != null && IKettleFileSystemConfigBuilder.class.isAssignableFrom(mGetInstance.getReturnType())) {
                    result = (IKettleFileSystemConfigBuilder)mGetInstance.invoke(null, new Object[0]);
                }
                result = (IKettleFileSystemConfigBuilder)configBuilderClass.newInstance();
            }
            catch (Exception e) {
                throw new IOException(BaseMessages.getString(PKG, "CustomVfsSettingsParser.Log.FailedToLoad", new String[0]));
            }
        } else {
            result = scheme.equalsIgnoreCase("sftp") ? KettleSftpFileSystemConfigBuilder.getInstance() : KettleGenericFileSystemConfigBuilder.getInstance();
        }
        return result;
    }
}

