/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import com.ccg.net.ethernet.EthernetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.safehaus.uuid.UUID;
import org.safehaus.uuid.UUIDGenerator;

public class UUIDUtil {
    private static Class<?> PKG;
    private static Log log;
    static boolean nativeInitialized;
    static UUIDGenerator ug;
    static org.safehaus.uuid.EthernetAddress eAddr;

    public static String getUUIDAsString() {
        return UUIDUtil.getUUID().toString();
    }

    public static UUID getUUID() {
        return ug.generateTimeBasedUUID(eAddr);
    }

    static {
        UUID olduuId;
        String macAddr;
        PKG = UUIDUtil.class;
        log = LogFactory.getLog(UUIDUtil.class);
        nativeInitialized = false;
        ug = UUIDGenerator.getInstance();
        if (nativeInitialized) {
            try {
                EthernetAddress ea = EthernetAddress.getPrimaryAdapter();
                eAddr = new org.safehaus.uuid.EthernetAddress(ea.getBytes());
            }
            catch (Exception ex) {
                log.error((Object)BaseMessages.getString(PKG, "UUIDUtil.ERROR_0002_GET_MAC_ADDR", new String[0]), (Throwable)ex);
            }
            catch (UnsatisfiedLinkError ule) {
                log.error((Object)BaseMessages.getString(PKG, "UUIDUtil.ERROR_0002_GET_MAC_ADDR", new String[0]), (Throwable)ule);
                nativeInitialized = false;
            }
        }
        if (eAddr == null && (macAddr = System.getProperty("MAC_ADDRESS")) != null) {
            macAddr = macAddr.replace('-', ':');
            eAddr = new org.safehaus.uuid.EthernetAddress(macAddr);
        }
        if (eAddr == null) {
            eAddr = ug.getDummyAddress();
        }
        if ((olduuId = ug.generateTimeBasedUUID(eAddr)) == null) {
            log.error((Object)BaseMessages.getString(PKG, "UUIDUtil.ERROR_0003_GENERATEFAILED", new String[0]));
        }
    }
}

