/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.sql;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleSQLException;
import org.pentaho.di.core.jdbc.ThinUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.sql.SQLCondition;

public class IifFunction {
    private String tableAlias;
    private String conditionClause;
    private SQLCondition sqlCondition;
    private RowMetaInterface serviceFields;
    private String trueValueString;
    private ValueMetaAndData trueValue;
    private boolean trueField;
    private String falseValueString;
    private ValueMetaAndData falseValue;
    private boolean falseField;

    public IifFunction(String tableAlias, String conditionClause, String trueValueString, String falseValueString, RowMetaInterface serviceFields) throws KettleSQLException {
        this.tableAlias = tableAlias;
        this.conditionClause = conditionClause;
        this.trueValueString = trueValueString;
        this.falseValueString = falseValueString;
        this.serviceFields = serviceFields;
        this.sqlCondition = new SQLCondition(tableAlias, conditionClause, serviceFields);
        this.trueValue = this.extractValue(trueValueString, true);
        this.falseValue = this.extractValue(falseValueString, false);
    }

    private ValueMetaAndData extractValue(String string, boolean trueIndicator) throws KettleSQLException {
        if (Const.isEmpty(string)) {
            return null;
        }
        ValueMetaAndData value = ThinUtil.attemptDateValueExtraction(string);
        if (value != null) {
            return value;
        }
        value = ThinUtil.attemptStringValueExtraction(string);
        if (value != null) {
            return value;
        }
        int index = this.serviceFields.indexOfValue(string);
        if (index >= 0) {
            if (trueIndicator) {
                this.trueField = true;
            } else {
                this.falseField = true;
            }
            return new ValueMetaAndData(this.serviceFields.getValueMeta(index), null);
        }
        value = ThinUtil.attemptBooleanValueExtraction(string);
        if (value != null) {
            return value;
        }
        value = ThinUtil.attemptIntegerValueExtraction(string);
        if (value != null) {
            return value;
        }
        value = ThinUtil.attemptNumberValueExtraction(string);
        if (value != null) {
            return value;
        }
        value = ThinUtil.attemptBigNumberValueExtraction(string);
        if (value != null) {
            return value;
        }
        throw new KettleSQLException("Unable to determine value data type for string: [" + string + "]");
    }

    public String getConditionClause() {
        return this.conditionClause;
    }

    public SQLCondition getSqlCondition() {
        return this.sqlCondition;
    }

    public RowMetaInterface getServiceFields() {
        return this.serviceFields;
    }

    public String getTrueValueString() {
        return this.trueValueString;
    }

    public ValueMetaAndData getTrueValue() {
        return this.trueValue;
    }

    public String getFalseValueString() {
        return this.falseValueString;
    }

    public ValueMetaAndData getFalseValue() {
        return this.falseValue;
    }

    public boolean isFalseField() {
        return this.falseField;
    }

    public boolean isTrueField() {
        return this.trueField;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }
}

