/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.compatibility.ValueUsedListener;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.w3c.dom.Node;

public class Row
implements XMLInterface,
Comparable<Row>,
Serializable {
    private static Class<?> PKG = Row.class;
    public static final String XML_TAG = "row";
    private final List<Value> list = new ArrayList<Value>();
    public static final long serialVersionUID = -8246477781266195408L;
    private boolean ignore;
    private List<ValueUsedListener> usedValueListeners = new ArrayList<ValueUsedListener>();

    public Row() {
        this.ignore = false;
    }

    public Row(Row r) {
        this();
        for (int i = 0; i < r.size(); ++i) {
            this.addValue(new Value(r.getValue(i)));
        }
        this.setIgnore(r.isIgnored());
    }

    public Value getValue(int index) {
        Value value = this.list.get(index);
        for (ValueUsedListener listener : this.usedValueListeners) {
            listener.valueIsUsed(index, value);
        }
        return value;
    }

    public void addValue(Value v) {
        this.list.add(v);
    }

    public void setValue(int idx, Value v) {
        this.list.set(idx, v);
    }

    public void addValue(int idx, Value v) {
        this.list.add(idx, v);
    }

    @Deprecated
    public void add(Object obj) {
        this.list.add((Value)obj);
    }

    @Deprecated
    public Object get(int idx) {
        return this.list.get(idx);
    }

    @Deprecated
    public void remove(int idx) {
        this.list.remove(idx);
    }

    public boolean removeValue(String valname) {
        int idx = this.searchValueIndex(valname);
        if (idx < 0) {
            return false;
        }
        this.list.remove(idx);
        return true;
    }

    public void removeValue(int idx) {
        this.list.remove(idx);
    }

    public void clear() {
        this.list.clear();
    }

    public void addRow(Row r) {
        if (r == null) {
            return;
        }
        for (int i = 0; i < r.size(); ++i) {
            Value v1 = r.getValue(i);
            this.addValue(v1);
        }
    }

    public void mergeRow(Row r) {
        if (r == null) {
            return;
        }
        for (int x = 0; x < r.size(); ++x) {
            Value field = r.getValue(x);
            if (this.searchValue(field.getName()) != null) continue;
            this.addValue(field);
        }
    }

    public void mergeData(Row r) {
        if (r == null) {
            return;
        }
        for (int x = 0; x < r.size(); ++x) {
            Value other = r.getValue(x);
            Value value = this.searchValue(other.getName());
            if (value == null) continue;
            value.merge(other);
        }
    }

    public int searchValueIndex(String name) {
        if (name == null) {
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            Value v = this.getValue(i);
            if (!v.getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public Value searchValue(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            Value v = this.getValue(i);
            String nm = v.getName();
            if (nm == null || !nm.equalsIgnoreCase(name)) continue;
            return v;
        }
        return null;
    }

    public int size() {
        return this.list.size();
    }

    public void print() {
        for (int i = 0; i < this.size(); ++i) {
            System.out.println("Element[" + i + "] = [" + this.getValue(i).getName() + "] = " + this.getValue(i).toString());
        }
    }

    public String toString() {
        StringBuffer retval = new StringBuffer(128);
        retval.append('[');
        for (int i = 0; i < this.size(); ++i) {
            Value value = this.getValue(i);
            if (i != 0) {
                retval.append(", ");
            }
            if (value != null) {
                retval.append(value.getName()).append('=').append(value.toString(false));
                continue;
            }
            retval.append("NULL");
        }
        retval.append(']');
        return retval.toString();
    }

    public String toStringMeta() {
        StringBuffer retval = new StringBuffer(128);
        retval.append('[');
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                retval.append(", ");
            }
            if (this.getValue(i) != null) {
                Value v = this.getValue(i);
                retval.append(v.getName()).append('(');
                retval.append(v.getTypeDesc());
                if (v.getLength() > 0) {
                    retval.append('(');
                    retval.append(v.getLength());
                    if (v.getPrecision() > 0) {
                        retval.append(',').append(v.getPrecision());
                    }
                    retval.append(')');
                }
                retval.append(')');
                continue;
            }
            retval.append("NULL");
        }
        retval.append(']');
        return retval.toString();
    }

    public void setIgnore() {
        this.ignore = true;
    }

    public void setIgnore(boolean i) {
        this.ignore = i;
    }

    public boolean isIgnored() {
        return this.ignore;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeObj(new DataOutputStream(out));
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.readObj(new DataInputStream(in));
    }

    private void writeObj(DataOutputStream dos) throws IOException {
        dos.writeInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            this.getValue(i).writeObj(dos);
        }
    }

    public void write(DataOutputStream dos) throws KettleFileException {
        try {
            this.writeObj(dos);
        }
        catch (Exception e) {
            throw new KettleFileException(BaseMessages.getString(PKG, "Row.ErrorWritingRow", new String[0]), e);
        }
    }

    private void readObj(DataInputStream dis) throws IOException {
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            Value v = new Value();
            v.readObj(dis);
            this.addValue(v);
        }
    }

    public Row(DataInputStream dis) throws KettleFileException {
        try {
            this.readObj(dis);
        }
        catch (EOFException e) {
            throw new KettleEOFException(BaseMessages.getString(PKG, "Row.EndOfFileReached", new String[0]), e);
        }
        catch (Exception e) {
            throw new KettleFileException(BaseMessages.getString(PKG, "Row.ErrorReadingRowData", new String[0]), e);
        }
    }

    public Row(DataInputStream dis, Row meta) throws KettleFileException {
        this(dis, meta.size(), meta);
    }

    public Row(DataInputStream dis, int size, Row meta) throws KettleFileException {
        try {
            for (int i = 0; i < size; ++i) {
                this.addValue(new Value(meta.getValue(i), dis));
            }
        }
        catch (KettleEOFException e) {
            throw new KettleEOFException(BaseMessages.getString(PKG, "Row.EndOfFileReadingRow", new String[0]), e);
        }
        catch (Exception e) {
            throw new KettleFileException(BaseMessages.getString(PKG, "Row.RowError", new String[0]), e);
        }
    }

    public boolean writeData(DataOutputStream dos) throws KettleFileException {
        for (int i = 0; i < this.size(); ++i) {
            Value v = this.getValue(i);
            v.writeData(dos);
        }
        return true;
    }

    public int compare(Row r, int[] fieldnrs, boolean[] ascending) {
        return this.compare(r, fieldnrs, ascending, null);
    }

    public int compare(Row r, int[] fieldnrs, boolean[] ascending, boolean[] caseInsensitive) {
        return this.compare(r, fieldnrs, fieldnrs, ascending, caseInsensitive);
    }

    public int compare(Row r, int[] fieldnrs1, int[] fieldnrs2, boolean[] ascending, boolean[] caseInsensitive) {
        int retval = 0;
        int len = fieldnrs1.length < fieldnrs2.length ? fieldnrs1.length : fieldnrs2.length;
        for (int i = 0; i < len; ++i) {
            Value v1 = this.getValue(fieldnrs1[i]);
            Value v2 = r.getValue(fieldnrs2[i]);
            retval = caseInsensitive != null ? v1.compare(v2, caseInsensitive[i]) : v1.compare(v2);
            if (ascending != null && !ascending[i]) {
                retval = -retval;
            }
            if (retval == 0) continue;
            return retval;
        }
        return retval;
    }

    public int compare(Row r, int fieldnr, boolean sort_desc) {
        int retval = 0;
        Value v1 = this.getValue(fieldnr);
        Value v2 = r.getValue(fieldnr);
        retval = v1.compare(v2);
        if (sort_desc) {
            retval = -retval;
        }
        return retval;
    }

    public int compare(Row r) {
        return this.compare(r, true);
    }

    public int compare(Row r, boolean caseInsensitive) {
        int retval = 0;
        int len = r.size();
        for (int i = 0; i < len; ++i) {
            Value v2;
            Value v1 = this.getValue(i);
            retval = v1.compare(v2 = r.getValue(i), caseInsensitive);
            if (retval == 0) continue;
            return retval;
        }
        return 0;
    }

    @Override
    public int compareTo(Row obj) {
        return this.compare(obj);
    }

    public boolean equals(Object r) {
        Row row = (Row)r;
        return this.compare(row) == 0;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.size(); ++i) {
            hash ^= this.getValue(i).hashCode();
        }
        return hash;
    }

    public synchronized Row Clone() {
        return new Row(this);
    }

    public boolean isEmpty() {
        boolean empty = true;
        for (int i = 0; i < this.size(); ++i) {
            Value v = this.getValue(i);
            if (v == null || v.isNull()) continue;
            empty = false;
            break;
        }
        return empty;
    }

    public String[] getFieldNames() {
        String[] retval = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            retval[i] = this.getValue(i).getName();
        }
        return retval;
    }

    public String[] getFieldNamesAndTypes(int maxlen) {
        String[] retval = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            Value v = this.getValue(i);
            retval[i] = Const.rightPad(v.getName(), maxlen) + "   (" + v.getTypeDesc() + ")";
        }
        return retval;
    }

    public boolean getBoolean(String valuename, boolean def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return v.getBoolean();
    }

    public String getString(String valuename, String def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return v.getString();
    }

    public Date getDate(String valuename, Date def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return v.getDate();
    }

    public double getNumber(String valuename, double def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return v.getNumber();
    }

    public long getInteger(String valuename, long def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return v.getInteger();
    }

    public long getShort(String valuename, int def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return (int)v.getInteger();
    }

    @Override
    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("<").append(XML_TAG).append(">");
        for (int i = 0; i < this.size(); ++i) {
            xml.append(this.getValue(i).getXML());
        }
        xml.append("</").append(XML_TAG).append(">");
        return xml.toString();
    }

    public Row(Node rowNode) {
        int nrValues = XMLHandler.countNodes(rowNode, "value");
        for (int i = 0; i < nrValues; ++i) {
            Node valueNode = XMLHandler.getSubNodeByNr(rowNode, "value", i);
            this.addValue(new Value(valueNode));
        }
    }

    public static final void sortRows(List<Row> rows, int[] fieldNrs, boolean[] ascDesc) {
        final int[] fieldNumbers = fieldNrs;
        final boolean[] ascending = ascDesc;
        Comparator<Row> comparator = new Comparator<Row>(){

            @Override
            public int compare(Row one, Row two) {
                return one.compare(two, fieldNumbers, ascending);
            }
        };
        Collections.sort(rows, comparator);
    }

    public static final byte[] extractData(Row row) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            row.writeData(dataOutputStream);
            dataOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(BaseMessages.getString(PKG, "Row.ErrorSerializing", new String[0]) + row, e);
        }
    }

    public static final Row getRow(byte[] data, Row metadata) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return new Row(dataInputStream, metadata.size(), metadata);
        }
        catch (Exception e) {
            throw new RuntimeException(BaseMessages.getString(PKG, "Row.ErrorDeserializing", new String[0]), e);
        }
    }

    public List<ValueUsedListener> getUsedValueListeners() {
        return this.usedValueListeners;
    }

    public void setUsedValueListeners(List<ValueUsedListener> usedValueListeners) {
        this.usedValueListeners = usedValueListeners;
    }
}

