/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import com.bitmechanic.maxq.IScriptAdapter;
import com.bitmechanic.maxq.Utils;
import com.bitmechanic.maxq.generator.AbstractCodeGenerator;
import com.bitmechanic.maxq.generator.GeneratorFactory;
import com.bitmechanic.maxq.generator.IScriptGenerator;
import java.io.File;

public class HttpTestCaseGenerator
extends AbstractCodeGenerator {
    private String baseClasspath;

    public HttpTestCaseGenerator(IScriptAdapter adapter) {
        super(adapter);
        File basePath = new File(GeneratorFactory.generatorProperties.getProperty("generator.java.sourcepath", ""));
        this.baseClasspath = basePath.getAbsolutePath();
        System.out.println(this.baseClasspath);
    }

    public String[] getValidFileExtensions() {
        return new String[]{".java"};
    }

    public void doAddParameterToList(String name, String value) {
        super.getScriptAdapter().append(this.createStatement("list.add(new KeyValuePair(\"" + name + "\", \"" + value + "\")" + ")"));
    }

    public void doAssertResponse(String respCode) {
    }

    public void doCallUrl(String url, String method, String data, String contentLength, String list) {
        super.getScriptAdapter().append(this.createStatement(method + "(\"" + url + "\"" + data + contentLength + list + ")"));
    }

    public void doCreateList() {
        super.getScriptAdapter().append(this.createStatement("list = new ArrayList()"));
    }

    public void doLoad(String script) {
        super.loadScriptAdapter(script);
        String testName = this.parseTestName();
        System.out.println("testName = " + testName);
        this.setTestName(testName);
        this.setDefaultTestName(testName);
        String testPath = this.parseTestPath();
        System.out.println("TestPath = " + testPath);
        this.setTestPath(this.parseTestPath());
    }

    public void doResponseForFile() {
    }

    public void doResponseForStdOut(String url) {
    }

    public void doSave(String path, String fileName) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("file name cannot be null");
        }
        String name = fileName;
        if (fileName.indexOf(".") > -1) {
            name = fileName.substring(0, fileName.indexOf("."));
        }
        this.setTestName(name);
        this.setTestPath(path);
        this.updateTestName();
        this.updateTestPath();
    }

    public void doSetData(String data) {
        super.getScriptAdapter().append(this.createStatement("data = '" + data + "'"));
    }

    public void doStartRecording() {
        if (!this.scriptContainsTestDeclaration()) {
            this.getScriptAdapter().insert(this.getTestDeclarationText(), 0);
        }
    }

    public void doStopRecording() {
        StringBuffer result = new StringBuffer();
        result.append("    }");
        result.append(IScriptGenerator.EOL + IScriptGenerator.EOL);
        result.append("/****************/" + IScriptGenerator.EOL + IScriptGenerator.EOL);
        result.append("}");
        super.getScriptAdapter().append(result.toString());
    }

    public void doTestUrlMessage(String url) {
    }

    public void doTidyCode(String url) {
    }

    public String parseTestName() {
        int startpos;
        String testName = "";
        if (this.getScript() != null && (startpos = this.getScript().indexOf("public class ")) > -1) {
            int end = this.getScript().indexOf(" extends", startpos += 13);
            testName = this.getScript().substring(startpos, end);
        }
        return testName;
    }

    protected String getTestDeclarationText() {
        StringBuffer result = new StringBuffer();
        result.append("// package" + IScriptGenerator.EOL);
        result.append("// This class was generated by MaxQ (maxq.tigris.org)" + IScriptGenerator.EOL);
        result.append(this.getPackageDeclaration());
        result.append("// imports" + IScriptGenerator.EOL);
        result.append("import java.util.List" + END_STATEMENT);
        result.append("import java.util.ArrayList" + END_STATEMENT);
        result.append("import org.dbforms.util.KeyValuePair" + END_STATEMENT);
        result.append("import org.dbforms.util.HttpTestCase" + END_STATEMENT);
        result.append(IScriptGenerator.EOL + "// definition of test class" + IScriptGenerator.EOL);
        result.append("public class " + this.getTestName() + " extends HttpTestCase {" + IScriptGenerator.EOL);
        result.append("    // Test method generated from the MaxQ Java generator" + IScriptGenerator.EOL);
        result.append("    public " + this.getTestName() + "(String name) {" + IScriptGenerator.EOL);
        result.append("        super(name)" + END_STATEMENT);
        result.append("    }" + IScriptGenerator.EOL);
        result.append("    public void test" + this.getTestName() + "() throws Exception {" + IScriptGenerator.EOL);
        result.append("        List list" + END_STATEMENT);
        return result.toString();
    }

    protected String createStatement(String text) {
        return Utils.lpad((int)8, (String)(text + END_STATEMENT));
    }

    private String getPackage() {
        String path = "";
        System.out.println("baseclasspath = " + this.baseClasspath);
        System.out.println("testpath = " + this.getTestPath());
        if (this.getTestPath() != null && this.baseClasspath != null && this.getTestPath().toLowerCase().startsWith(this.baseClasspath.toLowerCase()) && this.getTestPath().length() != this.baseClasspath.length()) {
            path = this.getTestPath().substring(this.baseClasspath.length() + 1);
        }
        return path.replace('\\', '.');
    }

    private String getPackageDeclaration() {
        String pkgDeclaration = "";
        if (!this.getPackage().equals("")) {
            pkgDeclaration = "package " + this.getPackage() + END_STATEMENT;
        }
        return pkgDeclaration;
    }

    private int getPackageNameEndPos() {
        int pos = -1;
        if (this.getScript() != null) {
            pos = this.getScript().indexOf(";", this.getPackageNameStartPos());
        }
        return pos;
    }

    private int getPackageNameStartPos() {
        int pos = -1;
        if (this.getScript() != null && (pos = this.getScript().indexOf("package ")) > -1) {
            pos += 7;
        }
        return pos;
    }

    private String packageToPath(String s) {
        return this.getTestPath() + "\\" + s.replace('.', '\\');
    }

    private String parseTestPath() {
        String testPath = null;
        int pos = this.getPackageNameStartPos();
        if (pos > -1) {
            int end = this.getPackageNameEndPos();
            testPath = this.packageToPath(this.getScript().substring(pos, end).trim());
        }
        return testPath;
    }

    private boolean scriptContainsTestDeclaration() {
        int pos = this.getScript().indexOf("// This class was generated by MaxQ (maxq.tigris.org)");
        return pos > -1;
    }

    private void updateClassDefinition() {
        int startpos = -1;
        if (this.getScript() != null && (startpos = this.getScript().indexOf("public class " + this.getDefaultTestName())) > -1) {
            startpos += 13;
            int end = -1;
            if (this.getScript() != null) {
                end = this.getScript().indexOf(" extends");
            }
            this.getScriptAdapter().replace(this.getTestName(), startpos, end);
        }
    }

    private void updateConstructor() {
        int startpos = -1;
        if (this.getScript() != null && (startpos = this.getScript().indexOf("public " + this.getDefaultTestName() + "(String name) {")) > -1) {
            this.getScriptAdapter().replace(this.getTestName(), startpos += 7, startpos + this.getDefaultTestName().length());
        }
    }

    private void updateTestMethod() {
        int startpos = -1;
        if (this.getScript() != null && (startpos = this.getScript().indexOf("public void test" + this.getDefaultTestName() + "() throws Exception {")) > -1) {
            this.getScriptAdapter().replace(this.getTestName(), startpos += 16, startpos + this.getDefaultTestName().length());
        }
    }

    private void updateTestName() {
        this.updateClassDefinition();
        this.updateConstructor();
        this.updateTestMethod();
    }

    private void updateTestPath() {
        String pkg = this.getPackage();
        System.out.println("package = " + pkg);
        if (this.getScript() != null) {
            int startpos = this.getScript().indexOf("package ");
            if (startpos > -1) {
                int end = this.getScript().indexOf(";", startpos += 8);
                this.getScriptAdapter().replace(this.getPackage(), startpos, end);
            } else if (!pkg.equals("")) {
                this.getScriptAdapter().insert("package " + pkg + ";" + IScriptGenerator.EOL + IScriptGenerator.EOL, 0);
            }
        }
    }
}

