/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource;

import de.destatis.core.connect.Client;
import de.destatis.core.resource.ResourceStorage;
import de.destatis.core.resource.ResourceStorageException;
import de.destatis.core.resource.util.SDFFileSystemResourceStorage;
import de.destatis.core.resource.util.SDFMetaFileSystemResourceStorage;
import java.io.File;

public class ResourceConfig {
    public static final String PROP_SURVEY_AUTO_UPDATE = "resourceconfig.survey.autoupdate";
    public static final String PROP_SURVEY_DIR = "resourceconfig.survey.dir";
    public static final String PROP_SDFMETA_AUTO_UPDATE = "resourceconfig.sdfmeta.autoupdate";
    public static final String PROP_SDFMETA_DIR = "resourceconfig.sdfmeta.dir";
    private static final String DEFAULT_SURVEY_DIR = "res/sdf/";
    private static final String DEFAULT_SDFMETA_DIR = "res/sdfmeta/";
    private boolean surveyAutoUpdate;
    private boolean sdfMetaAutoUpdate;
    private String surveyDir;
    private String sdfMetaDir;
    private ResourceStorage surveyResourceStorage;
    private ResourceStorage sdfMetaResourceStorage;
    private Client client;

    public String getSurveyDir() {
        return this.surveyDir;
    }

    public String getSdfMetaDir() {
        return this.sdfMetaDir;
    }

    public void setSurveyDir(String surveyDir) {
        this.surveyDir = surveyDir;
        this.surveyResourceStorage = null;
    }

    public void setSdfMetaDir(String sdfMetaDir) {
        this.sdfMetaDir = sdfMetaDir;
        this.sdfMetaResourceStorage = null;
    }

    public ResourceStorage getSurveyResourceStorage() throws ResourceStorageException {
        ResourceStorage storage = null;
        if (this.surveyResourceStorage != null) {
            storage = this.surveyResourceStorage;
        }
        if (storage == null) {
            String surveyDir = this.getSurveyDir();
            if (surveyDir == null || surveyDir.trim().length() == 0) {
                surveyDir = DEFAULT_SURVEY_DIR;
            }
            this.surveyResourceStorage = storage = new SDFFileSystemResourceStorage(new File(surveyDir));
        }
        return storage;
    }

    public ResourceStorage getSdfMetaResourceStorage() throws ResourceStorageException {
        ResourceStorage storage = null;
        if (this.sdfMetaResourceStorage != null) {
            storage = this.sdfMetaResourceStorage;
        }
        if (storage == null) {
            String sdfMetaDir = this.getSdfMetaDir();
            if (sdfMetaDir == null || sdfMetaDir.trim().length() == 0) {
                sdfMetaDir = DEFAULT_SDFMETA_DIR;
            }
            this.sdfMetaResourceStorage = storage = new SDFMetaFileSystemResourceStorage(new File(sdfMetaDir));
        }
        return storage;
    }

    public void setSurveyResourceStorage(ResourceStorage storage) {
        this.surveyResourceStorage = storage;
    }

    public void setSdfMetaResourceStorage(ResourceStorage storage) {
        this.sdfMetaResourceStorage = storage;
    }

    public boolean isSurveyAutoUpdate() {
        return this.surveyAutoUpdate;
    }

    public boolean isSdfMetaAutoUpdate() {
        return this.sdfMetaAutoUpdate;
    }

    public void setSurveyAutoUpdate(boolean surveyAutoUpdate) {
        this.surveyAutoUpdate = surveyAutoUpdate;
    }

    public void setSdfMetaAutoUpdate(boolean sdfMetaAutoUpdate) {
        this.sdfMetaAutoUpdate = sdfMetaAutoUpdate;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

