/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.document.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadXmlEncodingParser
extends DefaultHandler {
    private Locator locator;
    private String encoding;

    public String getEncoding(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        this.locator = null;
        this.encoding = null;
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        try {
            saxParser.parse(new InputSource(inputStream), (DefaultHandler)this);
        }
        catch (EncodingReadException encodingReadException) {
            // empty catch block
        }
        return this.encoding;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.locator != null) {
            String charset = null;
            Method getEncoding = null;
            try {
                getEncoding = this.locator.getClass().getMethod("getEncoding", new Class[0]);
                if (getEncoding != null) {
                    this.encoding = charset = (String)getEncoding.invoke((Object)this.locator, null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new EncodingReadException();
    }

    private static class EncodingReadException
    extends SAXException {
        public EncodingReadException() {
            super("Encoding gelesen.");
        }
    }
}

