/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import com.atlassian.clover.util.ByteSized;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizedLRUCacheMap<K, V extends ByteSized>
extends LinkedHashMap<K, V> {
    private long maxLength;
    private long currentLength;

    public SizedLRUCacheMap(long maxLength, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor, true);
        this.maxLength = maxLength;
        this.currentLength = 0L;
    }

    long getCurrentSizeInBytes() {
        return this.currentLength;
    }

    @Override
    public V remove(Object key) {
        ByteSized removed = (ByteSized)super.remove(key);
        if (removed != null) {
            this.currentLength -= removed.sizeInBytes();
        }
        return (V)removed;
    }

    @Override
    public void clear() {
        this.currentLength = 0L;
        super.clear();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        ByteSized replaced = (ByteSized)super.put(key, value);
        if (replaced != null) {
            this.currentLength -= replaced.sizeInBytes();
        }
        this.currentLength += value.sizeInBytes();
        return (V)replaced;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        long eldestSize = ((ByteSized)eldest.getValue()).sizeInBytes();
        if (this.currentLength + eldestSize > this.maxLength) {
            this.currentLength -= eldestSize;
            return true;
        }
        return false;
    }
}

