/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.cfg.instr.java;

import com.atlassian.clover.cfg.instr.InstrumentationConfig;
import com.atlassian.clover.cfg.instr.java.LambdaInstrumentation;
import com.atlassian.clover.util.JavaEnvUtils;

public class JavaInstrumentationConfig
extends InstrumentationConfig {
    public static final String JAVA_LANG_PREFIX = "java.lang.";
    private boolean java14 = false;
    private boolean java15 = false;
    private boolean java16 = false;
    private boolean java17 = false;
    private boolean java18 = false;
    private boolean sourceLevelSet = false;
    private boolean fullyQualifiedJavaNames = true;
    private String instrFileExtension = "java";
    private LambdaInstrumentation instrumentLambda = LambdaInstrumentation.ALL;

    public String getJavaLangPrefix() {
        return this.fullyQualifiedJavaNames ? JAVA_LANG_PREFIX : "";
    }

    public void setFullyQualifyJavaLang(boolean fullyQualifiedJavaNames) {
        this.fullyQualifiedJavaNames = fullyQualifiedJavaNames;
    }

    public String getSourceLevel() {
        this.ensureSourceLevelSet();
        return this.java18 ? "1.8" : (this.java17 ? "1.7" : (this.java16 ? "1.6" : (this.java15 ? "1.5" : (this.java14 ? "1.4" : "1.3"))));
    }

    public void setSourceLevel(String source) {
        if (source != null) {
            this.java18 = source.equals("1.8") || source.equals("8");
            this.java17 = source.equals("1.7") || source.equals("7") || this.java18;
            this.java16 = source.equals("1.6") || source.equals("6") || this.java17;
            this.java15 = source.equals("1.5") || source.equals("5") || this.java16;
            this.java14 = source.equals("1.4") || this.java15;
            this.sourceLevelSet = true;
        }
    }

    public boolean isJava14() {
        this.ensureSourceLevelSet();
        return this.java14;
    }

    public boolean isJava15() {
        this.ensureSourceLevelSet();
        return this.java15;
    }

    public boolean isJava18() {
        this.ensureSourceLevelSet();
        return this.java18;
    }

    public void setInstrFileExtension(String extension) {
        this.instrFileExtension = extension;
    }

    public String getInstrFileExtension() {
        return this.instrFileExtension;
    }

    public void setInstrumentLambda(LambdaInstrumentation instrumentLambda) {
        this.instrumentLambda = instrumentLambda;
    }

    public LambdaInstrumentation getInstrumentLambda() {
        return this.instrumentLambda;
    }

    protected String determineSourceLevel() {
        return JavaEnvUtils.getJavaVersion();
    }

    private void ensureSourceLevelSet() {
        if (!this.sourceLevelSet) {
            this.setSourceLevel(this.determineSourceLevel());
        }
    }
}

