/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import clover.it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import clover.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import clover.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import clover.it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractReference2DoubleMap
implements Reference2DoubleMap,
Serializable {
    protected double defRetValue;

    protected AbstractReference2DoubleMap() {
    }

    public void setDefRetValue(double rv) {
        this.defaultReturnValue(rv);
    }

    public double getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(double rv) {
        this.defRetValue = rv;
    }

    public double defaultReturnValue() {
        return this.defRetValue;
    }

    public double put(Object key, double value) {
        throw new UnsupportedOperationException();
    }

    public double removeDouble(Object key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        Object k = ok;
        return this.containsKey(k) ? new Double(this.getDouble(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        Object k = ok;
        double v = this.put(k, (Double)ov);
        return this.containsKey(k) ? new Double(v) : null;
    }

    public Object remove(Object ok) {
        Object k = ok;
        double v = this.removeDouble(k);
        return this.containsKey(k) ? new Double(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Double)ov);
    }

    public boolean containsValue(double v) {
        return ((DoubleCollection)this.values()).contains(v);
    }

    public boolean containsKey(Object k) {
        return ((ReferenceSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Reference2DoubleMap) {
            while (n-- != 0) {
                Reference2DoubleMap.Entry e = (Reference2DoubleMap.Entry)i.next();
                this.put(e.getKey(), e.getDoubleValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractReferenceSet(){

            public boolean contains(Object k) {
                return AbstractReference2DoubleMap.this.containsKey(k);
            }

            public int size() {
                return AbstractReference2DoubleMap.this.size();
            }

            public ObjectIterator objectIterator() {
                return new AbstractObjectIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractReference2DoubleMap.this.entrySet().iterator();
                    }

                    public Object next() {
                        return ((Reference2DoubleMap.Entry)this.i.next()).getKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractDoubleCollection(){

            public boolean contains(double k) {
                return AbstractReference2DoubleMap.this.containsValue(k);
            }

            public int size() {
                return AbstractReference2DoubleMap.this.size();
            }

            public DoubleIterator doubleIterator() {
                return new AbstractDoubleIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractReference2DoubleMap.this.entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Reference2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Reference2DoubleMap.Entry e = (Reference2DoubleMap.Entry)i.next();
            if (this == e.getKey()) {
                s.append("(this map)");
            } else {
                s.append(String.valueOf(e.getKey()));
            }
            s.append("=>");
            s.append(String.valueOf(e.getDoubleValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Reference2DoubleMap.Entry {
        protected Object key;
        protected double value;

        public BasicEntry(Object key, Object value) {
            this.key = key;
            this.value = (Double)value;
        }

        public BasicEntry(Object key, double value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return new Double(this.value);
        }

        public double getDoubleValue() {
            return this.value;
        }

        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Double(this.setValue((Double)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == e.getKey() && this.value == (Double)e.getValue();
        }

        public int hashCode() {
            return System.identityHashCode(this.key) ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

