/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.List;

public class ATag
extends HTMLTag {
    public ATag() {
        super("a");
    }

    public boolean isReduceTokenStack() {
        return false;
    }

    public String getCloseTag() {
        return "</a>";
    }

    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel model) throws IOException {
        if (!converter.noLinks()) {
            super.renderHTML(converter, buf, model);
        } else {
            List<Object> children = this.getChildren();
            if (children.size() != 0) {
                converter.nodesToText(children, buf, model);
            }
        }
    }

    public boolean addAttribute(String attName, String attValue, boolean checkXSS) {
        String valueLowerCased;
        super.addAttribute(attName, attValue, checkXSS);
        if (attName != null && attValue != null && attName.equalsIgnoreCase("href") && ((valueLowerCased = attValue.trim().toLowerCase()).startsWith("http:") || valueLowerCased.startsWith("https:") || valueLowerCased.startsWith("ftp:") || valueLowerCased.startsWith("ftps:") || valueLowerCased.startsWith("mailto:"))) {
            this.addAttribute("rel", "nofollow", true);
            return true;
        }
        return false;
    }
}

