/*
 * Decompiled with CFR 0.152.
 */
package de.superx.sxrest;

import de.memtext.util.FileUtils;
import de.superx.common.SxUser;
import de.superx.servlet.SuperXManager;
import de.superx.util.PathAndFileUtils;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;

@Path(value="/logs")
public class LogsProvider {
    @Context
    Request request;

    @GET
    @Path(value="/{logtype}")
    @Produces(value={"text/plain"})
    public String printLogs(@PathParam(value="logtype") String logtype, @QueryParam(value="loglines") Integer loglines, @Context HttpServletRequest request) {
        String returntext = "";
        SxUser user = (SxUser)request.getSession().getAttribute("user");
        String mandantenid = (String)request.getSession().getAttribute("MandantenID");
        if (mandantenid == null || mandantenid.equals("")) {
            mandantenid = "default";
        }
        returntext = user == null || !user.isAdmin() ? "Fehlende Rechte" : (logtype.equals("activity") || logtype.equals("fmsql") || logtype.equals("sql") || logtype.equals("xml") ? this.getMaskLogs(mandantenid, logtype) : this.getTomcatLogs(mandantenid, logtype, loglines));
        return returntext;
    }

    private String getMaskLogs(String mandantenid, String logtype) {
        String logString;
        if (mandantenid.equalsIgnoreCase(SuperXManager.getLastMaskenSqlMandantid())) {
            switch (logtype) {
                case "activity": {
                    logString = SuperXManager.activityLog.toString().replace("<br>", "\n");
                    break;
                }
                case "fmsql": {
                    logString = SuperXManager.getLastFMMaskenSql();
                    break;
                }
                case "sql": {
                    logString = SuperXManager.getLastMaskenSql();
                    break;
                }
                case "xml": {
                    logString = SuperXManager.getLastXml();
                    break;
                }
                default: {
                    logString = "Protokoll " + logtype + " kann nicht gelesen werden";
                    break;
                }
            }
        } else {
            logString = "Bitte wiederholen Sie den Aufruf mit dem jew. Mandant";
        }
        return logString;
    }

    private String getTomcatLogs(String mandantenid, String logtype, Integer loglines) {
        String logFilePath = "";
        if (loglines == null) {
            loglines = 100;
        }
        switch (logtype) {
            case "serverlog": {
                logFilePath = System.getProperty("catalina.base") + File.separator + "logs" + File.separator + "catalina.out";
                break;
            }
            case "serverlogsql": {
                logFilePath = PathAndFileUtils.getWebinfDirectory() + File.separator + "logs" + File.separator + "superx_" + mandantenid + ".log";
                break;
            }
            case "serverlogxml": {
                logFilePath = PathAndFileUtils.getWebinfDirectory() + File.separator + "logs" + File.separator + "superx_" + mandantenid + "_xml.log";
                break;
            }
            default: {
                throw new RuntimeException("Logtype " + logtype + " not supported!");
            }
        }
        String logString = "Protokoll " + logFilePath + " kann nicht gelesen werden";
        File logfile = new File(logFilePath);
        if (logfile.exists()) {
            try {
                logString = FileUtils.tail(logfile, loglines);
            }
            catch (Exception e) {
                logString = logString + ": " + e.toString();
            }
        }
        return logString;
    }
}

