/*
 * Decompiled with CFR 0.152.
 */
package de.superx.saiku;

import com.google.common.base.Joiner;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.SchemaReader;
import mondrian.olap4j.SaikuMondrianHelper;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapMember;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.saiku.datasources.connection.AbstractConnectionManager;
import org.saiku.datasources.connection.ISaikuConnection;
import org.saiku.datasources.connection.SaikuConnectionFactory;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.service.ISessionService;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SuperxSaikuConnectionManager
extends AbstractConnectionManager {
    protected static Logger logger = Logger.getLogger(SuperxSaikuConnectionManager.class);
    public static final String SECURITY_TYPE_SUPERX = "superx";
    private static final long serialVersionUID = -5912836681963684201L;
    private Map<String, ISaikuConnection> connections = new HashMap<String, ISaikuConnection>();
    private List<String> errorConnections = new ArrayList<String>();
    private ISessionService sessionService;
    private DataSource dataSource;

    public void setSessionService(ISessionService ss) {
        this.sessionService = ss;
    }

    public void init() {
        logger.debug((Object)"INIT START");
        this.connections = this.getAllConnections();
        logger.debug((Object)"INIT FINISHED");
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    protected ISaikuConnection getInternalConnection(String name, SaikuDatasource datasource) {
        logger.debug((Object)("Get internal connection " + name));
        ISaikuConnection con = null;
        if (this.isDatasourceSecurity(datasource, "passthrough") && this.sessionService != null) {
            datasource = this.handlePassThrough(datasource);
        }
        String newName = name;
        if (this.isDatasourceSecurityEnabled(datasource) && this.sessionService != null) {
            Map session = this.sessionService.getAllSessionObjects();
            String username = (String)session.get("username");
            List roles = (List)session.get("roles");
            String role = StringUtils.join((Collection)roles, (String)",");
            if (username != null && role != null) {
                newName = name + "-" + username + "-" + role;
            } else {
                logger.warn((Object)("Connection not authenticated: " + name));
                return null;
            }
        }
        logger.info((Object)("New name: " + newName));
        if (!this.connections.containsKey(newName)) {
            con = this.connect(datasource);
            if (con != null) {
                if (!this.isDatasourceSecurity(datasource, "passthrough")) {
                    con = this.applySecurity(con, datasource);
                }
                this.connections.put(newName, con);
            } else if (!this.errorConnections.contains(newName)) {
                this.errorConnections.add(newName);
            }
        } else {
            con = this.connections.get(newName);
        }
        return con;
    }

    protected ISaikuConnection refreshInternalConnection(String name, SaikuDatasource datasource) {
        try {
            ISaikuConnection con;
            String newName = name;
            Map session = this.sessionService.getAllSessionObjects();
            String username = (String)session.get("username");
            List roles = (List)session.get("roles");
            String role = StringUtils.join((Collection)roles, (String)",");
            if (username != null) {
                newName = name + "-" + username + "-" + role;
            }
            if ((con = this.connections.remove(newName)) != null) {
                con.clearCache();
            }
            con = null;
            return this.getInternalConnection(name, datasource);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SaikuDatasource handlePassThrough(SaikuDatasource datasource) {
        Map session = this.sessionService.getAllSessionObjects();
        String username = (String)session.get("username");
        if (username != null) {
            String password = (String)session.get("password");
            datasource.getProperties().setProperty("username", username);
            if (password != null) {
                datasource.getProperties().setProperty("password", password);
            }
            return datasource;
        }
        return null;
    }

    private ISaikuConnection applySecurity(ISaikuConnection con, SaikuDatasource datasource) {
        if (con == null) {
            throw new IllegalArgumentException("Cannot apply Security to NULL connection object");
        }
        if (this.isDatasourceSecurity(datasource, "one2one")) {
            List<String> springRoles = SuperxSaikuConnectionManager.getSpringRoles();
            List<String> conRoles = SuperxSaikuConnectionManager.getConnectionRoles(con);
            String roleName = null;
            for (String sprRole : springRoles) {
                if (!conRoles.contains(sprRole)) continue;
                if (roleName == null) {
                    roleName = sprRole;
                    continue;
                }
                roleName = roleName + "," + sprRole;
            }
            if (SuperxSaikuConnectionManager.setRole(con, roleName, datasource)) {
                return con;
            }
        } else if (this.isDatasourceSecurity(datasource, "lookup")) {
            Map<String, List<String>> mapping = SuperxSaikuConnectionManager.getRoleMapping(datasource);
            List<String> springRoles = SuperxSaikuConnectionManager.getSpringRoles();
            String roleName = null;
            for (String sprRole : springRoles) {
                if (!mapping.containsKey(sprRole)) continue;
                List<String> roles = mapping.get(sprRole);
                for (String role : roles) {
                    if (roleName == null) {
                        roleName = role;
                        continue;
                    }
                    roleName = roleName + "," + role;
                }
            }
            if (SuperxSaikuConnectionManager.setRole(con, roleName, datasource)) {
                return con;
            }
        } else if (this.isDatasourceSecurity(datasource, SECURITY_TYPE_SUPERX)) {
            logger.info((Object)"Security type superx");
            if (con.getDatasourceType().equals("OLAP") && con.getConnection() instanceof OlapConnection) {
                this.applySuperxSecurityOn(con);
            }
        }
        return con;
    }

    private static boolean setRole(ISaikuConnection con, String roleName, SaikuDatasource datasource) {
        if (con.getConnection() instanceof OlapConnection) {
            OlapConnection c = (OlapConnection)con.getConnection();
            if (c == null) {
                return false;
            }
            System.out.println("Setting role to datasource:" + datasource.getName() + " role:" + roleName);
            try {
                if (StringUtils.isNotBlank((String)roleName) && SaikuMondrianHelper.isMondrianConnection((OlapConnection)c) && roleName.split(",").length > 1) {
                    SaikuMondrianHelper.setRoles((OlapConnection)c, (String[])roleName.split(","));
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static List<String> getSpringRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            Collection auths = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
            for (GrantedAuthority a : auths) {
                roles.add(a.getAuthority());
            }
        }
        return roles;
    }

    private static List<String> getConnectionRoles(ISaikuConnection con) {
        if (con.getDatasourceType().equals("OLAP") && con.getConnection() instanceof OlapConnection) {
            OlapConnection c = (OlapConnection)con.getConnection();
            try {
                return c.getAvailableRoleNames();
            }
            catch (OlapException e) {
                e.printStackTrace();
            }
        }
        return new ArrayList<String>();
    }

    private static Map<String, List<String>> getRoleMapping(SaikuDatasource datasource) {
        String mappings;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (datasource.getProperties().containsKey("security.mapping") && (mappings = datasource.getProperties().getProperty("security.mapping")) != null) {
            String[] maps;
            for (String map : maps = mappings.split(";")) {
                String[] m = map.split("=");
                if (m.length != 2) continue;
                if (!result.containsKey(m[0])) {
                    result.put(m[0], new ArrayList());
                }
                ((List)result.get(m[0])).add(m[1]);
            }
        }
        return result;
    }

    private ISaikuConnection connect(SaikuDatasource datasource) {
        try {
            ISaikuConnection con = SaikuConnectionFactory.getConnection((SaikuDatasource)datasource);
            if (con.initialized()) {
                return con;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Collection<String> getAllowedFacttables(String userName) {
        if (userName == null) {
            return new ArrayList<String>(0);
        }
        final HashMap facttableTopicarea = new HashMap();
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        eduetlJdbcTemplate.query("select name, sachgebiete_id::int from fact_table", new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                facttableTopicarea.put(rs.getString(1).trim(), rs.getInt(2));
            }
        });
        List userFacttable = eduetlJdbcTemplate.query("select name from fact_table where sachgebiete_id::integer in (select sachgebiete_id from user_sachgeb_bez where userinfo_id = (select  tid from userinfo where benutzer = ?)) or sachgebiete_id::integer in (select GS.sachgebiete_id from group_sachgeb_bez GS, user_group_bez UG where UG.groupinfo_id=GS.groupinfo_id and UG.userinfo_id = (select  tid from userinfo where benutzer = ?))  ", new Object[]{userName, userName}, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1).trim();
            }
        });
        return userFacttable.size() > 0 ? userFacttable : facttableTopicarea.keySet();
    }

    private Map<String, String> getAllowedOrgUnits(String userName) {
        if (userName == null) {
            return new HashMap<String, String>(0);
        }
        logger.info((Object)("***> Get allowed orgunits user: " + userName));
        final ArrayList<String> userInstitutionen = new ArrayList<String>();
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        eduetlJdbcTemplate.query("select distinct I.ch110_institut, O.name, O.drucktext from userinfo U, user_institution I left outer join organigramm O on (O.key_apnr=I.ch110_institut)  where I.userid = U.tid and U.benutzer= ?", new Object[]{userName}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String orgunit = rs.getString(1).trim();
                userInstitutionen.add(orgunit);
                logger.info((Object)("****> " + orgunit));
            }
        });
        Map<String, String> childOrgUnits = new HashMap<String, String>();
        if (!userInstitutionen.isEmpty()) {
            childOrgUnits = this.getAllowedChildOrgUnits(userName, userInstitutionen);
        }
        return childOrgUnits;
    }

    private Map<String, String> getAllowedChildOrgUnits(String userName, List<String> userOrgUnits) {
        String dbms = "";
        try {
            dbms = this.dataSource.getConnection().getMetaData().getDatabaseProductName().toLowerCase();
            logger.info((Object)("***> dbms: " + dbms));
        }
        catch (SQLException e) {
            logger.error((Object)("dbms could not be retrieved: " + e.toString()));
        }
        final HashMap<String, String> childOrgUnits = new HashMap<String, String>();
        if (userName == null) {
            return new HashMap<String, String>(0);
        }
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        logger.info((Object)("***> Get allowed child orgunits user: " + userName));
        Integer userId = eduetlJdbcTemplate.queryForInt("select tid from userinfo where benutzer = ?", new Object[]{userName});
        for (final String orgunit : userOrgUnits) {
            logger.info((Object)("****> orgunit: " + orgunit));
            if (dbms.indexOf("informix") > -1) {
                if (orgunit.equals("0")) {
                    eduetlJdbcTemplate.execute("execute procedure sp_user_orga_child(" + userId + ",today(),0,'null', 0);");
                } else {
                    eduetlJdbcTemplate.execute("execute procedure sp_user_orga_child(" + userId + ",today(),0,'" + orgunit.trim() + "', 0);");
                }
            } else {
                eduetlJdbcTemplate.execute("drop table IF EXISTS tmp_ch110_institut;");
                if (orgunit.equals("0")) {
                    eduetlJdbcTemplate.queryForRowSet("select sp_user_orga_child(?,today(),0,'null', 0)", new Object[]{userId});
                } else {
                    eduetlJdbcTemplate.queryForRowSet("select sp_user_orga_child(?,today(),0,?, 0)", new Object[]{userId, orgunit});
                }
            }
            eduetlJdbcTemplate.query("select nvl(C.uniquename,O.key_apnr) as uniquename,O.drucktext,O.name,O.parent,O.lehre, M.description from  tmp_ch110_institut T,organigramm O left outer join menu_element M on (M.element='orgstruktur' and val(M.element_value)=O.orgstruktur)  left outer join cifx C on C.key=110 and C.apnr=O.key_apnr  where T.ch110_institut=O.key_apnr order by name;", new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    String childOrgunit = rs.getString(2);
                    String key_apnr = rs.getString(1);
                    if (childOrgunit == null || key_apnr == null) {
                        throw new RuntimeException("Drucktext or key_apnr null in table organigramm for child of orgunit " + orgunit);
                    }
                    childOrgunit = childOrgunit.trim();
                    if (!childOrgUnits.containsKey(key_apnr = key_apnr.trim())) {
                        logger.info((Object)("*****> " + childOrgunit + " key_apnr:" + key_apnr + " parent: " + orgunit));
                        childOrgUnits.put(key_apnr, childOrgunit);
                    } else {
                        logger.warn((Object)("*****> !! child orgunit already exists: " + childOrgunit + " key_apnr: " + key_apnr));
                    }
                }
            });
            if (dbms.indexOf("informix") > -1) {
                eduetlJdbcTemplate.execute("drop table tmp_ch110_institut;");
                continue;
            }
            eduetlJdbcTemplate.execute("drop table IF EXISTS tmp_ch110_institut;");
        }
        return childOrgUnits;
    }

    private Collection<String> getAllowedSubjectOfStudies(Set<String> orgunits) {
        final HashSet<String> allowedSubjectsOfStudy = new HashSet<String>();
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        for (String orgunit : orgunits) {
            eduetlJdbcTemplate.query("select stg_str from dim_studiengang where fb=?", new Object[]{orgunit}, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    allowedSubjectsOfStudy.add(rs.getString(1).trim());
                }
            });
        }
        logger.info((Object)("****> get allowed subject of studies: " + Joiner.on((String)", ").join(allowedSubjectsOfStudy)));
        return allowedSubjectsOfStudy;
    }

    private Collection<String> getAllowedCourseOfStudies(Collection<String> orgunits) {
        final HashSet<String> courseOfStudyText = new HashSet<String>();
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        for (String orgunit : orgunits) {
            eduetlJdbcTemplate.query("select text from dim_studiengang where fb =?", new Object[]{orgunit}, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    if (rs.getObject(1) != null) {
                        courseOfStudyText.add(rs.getString(1).trim());
                    }
                }
            });
        }
        eduetlJdbcTemplate.query("select text from dim_studiengang where fb is null", new Object[0], new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                if (rs.getObject(1) != null) {
                    courseOfStudyText.add(rs.getString(1).trim());
                }
            }
        });
        logger.info((Object)("****> get allowed course of studies: " + Joiner.on((String)", ").join(courseOfStudyText)));
        return courseOfStudyText;
    }

    private void applySuperxSecurityOn(ISaikuConnection con) {
        OlapConnection c = (OlapConnection)con.getConnection();
        RolapConnection mondrianConnection = SaikuMondrianHelper.getMondrianConnection((OlapConnection)c);
        Cube[] cubes = mondrianConnection.getSchema().getCubes();
        Map session = this.sessionService.getAllSessionObjects();
        String mandantid = "default";
        if (!con.getName().equals("BI")) {
            mandantid = con.getName();
        }
        DriverManagerDataSource ds = new DriverManagerDataSource("jdbc:apache:commons:dbcp:" + mandantid);
        this.dataSource = ds;
        String userName = (String)session.get("username");
        Collection<String> facttables = this.getAllowedFacttables(userName);
        Map<String, String> orgunits = this.getAllowedOrgUnits(userName);
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        boolean dim_studiengang_exists = eduetlJdbcTemplate.queryForInt("select count(*) from sx_tables where name='dim_studiengang'") > 0;
        ArrayList<String> courseOfStudy = new ArrayList();
        if (dim_studiengang_exists) {
            courseOfStudy = this.getAllowedCourseOfStudies(orgunits.keySet());
        } else {
            logger.warn((Object)"Table dim_studiengang doesn't exist - cannot find allowed course of studys! Is sos installed?");
        }
        SchemaReader reader = mondrianConnection.getSchemaReader().withLocus();
        RoleImpl role = ((RoleImpl)reader.getRole()).makeMutableClone();
        if (facttables != null && !facttables.isEmpty()) {
            for (Cube cube : cubes) {
                if (facttables.contains(cube.getName())) {
                    role.grant(cube, Access.ALL);
                    Hierarchy hierFb = cube.lookupHierarchy(new Id.NameSegment(OlapDimension.fachbereich.nameSegment), true);
                    Hierarchy hierFach = cube.lookupHierarchy(new Id.NameSegment("[bluep_stg.Studienfach]"), true);
                    Hierarchy hierStg = cube.lookupHierarchy(new Id.NameSegment(OlapDimension.studiengang.nameSegment), true);
                    Hierarchy hierLehr = cube.lookupHierarchy(new Id.NameSegment(OlapDimension.lehreinheit.nameSegment), true);
                    Hierarchy hierInstitution = cube.lookupHierarchy(new Id.NameSegment(OlapDimension.institut.nameSegment), true);
                    Hierarchy hierKostenstelle = cube.lookupHierarchy(new Id.NameSegment(OlapDimension.kostenstelle.nameSegment), true);
                    if (hierFb != null) {
                        this.grant(role, hierFb, OlapDimension.fachbereich.levelName, orgunits.keySet(), reader);
                    }
                    if (hierLehr != null) {
                        this.grant(role, hierLehr, OlapDimension.lehreinheit.levelName, orgunits.values(), reader);
                    }
                    if (hierStg != null) {
                        this.grant(role, hierStg, OlapDimension.studiengang.levelName, courseOfStudy, reader);
                    }
                    if (hierInstitution != null) {
                        this.grant(role, hierInstitution, OlapDimension.institut.levelName, orgunits.keySet(), reader);
                    }
                    if (hierKostenstelle != null) {
                        this.grant(role, hierKostenstelle, OlapDimension.kostenstelle.levelName, orgunits.values(), reader);
                    }
                } else {
                    role.grant(cube, Access.NONE);
                }
                logger.info((Object)("** Cube " + cube.getName() + " Access -> " + role.getAccess(cube)));
            }
        }
        logger.info((Object)"Set superx role");
        role.makeImmutable();
        mondrianConnection.setRole((Role)role);
    }

    private void grant(RoleImpl role, Hierarchy hierarchy, String levelName, Collection<String> allowedMemberIds, SchemaReader reader) {
        if (hierarchy != null) {
            List levels = reader.getHierarchyLevels(hierarchy);
            List<Member> allowedMembers = new ArrayList<Member>();
            ArrayList<Member> refusedMembers = new ArrayList<Member>();
            logger.info((Object)("*** Level " + levelName + " Acess: " + Joiner.on((char)',').join(allowedMemberIds)));
            logger.info((Object)("** Found hierarchy: " + hierarchy));
            logger.info((Object)("** Grant: " + role.getAccess(hierarchy)));
            int totalMembers = 0;
            for (Level level : levels) {
                if (!level.getName().equals(levelName)) continue;
                logger.info((Object)("***> Level " + level));
                List members = reader.getLevelMembers(level, false);
                for (Member member : members) {
                    if (member.isAll()) continue;
                    ++totalMembers;
                    String name = member.getName();
                    boolean isAllowedMember = false;
                    if (name.toLowerCase().contains("nicht zugeordnet") || name.toLowerCase().contains("leer") || name.toLowerCase().contains("unbekannt")) {
                        isAllowedMember = true;
                    } else if (levelName.equals(OlapDimension.fachbereich.levelName) || levelName.equals(OlapDimension.institut.levelName)) {
                        Integer id = (Integer)((RolapMember)member).getKey();
                        String uniqueName = this.getUniqueNameFor(OlapDimension.getBluepForLevelName(levelName), id);
                        isAllowedMember = allowedMemberIds.contains(uniqueName) || uniqueName == null;
                    } else {
                        isAllowedMember = allowedMemberIds.contains(name);
                    }
                    logger.info((Object)("*****> Member: " + member));
                    if (isAllowedMember) {
                        allowedMembers.add(member);
                        logger.info((Object)"******> Grant Acess.ALL");
                        continue;
                    }
                    refusedMembers.add(member);
                }
            }
            if (totalMembers > allowedMembers.size()) {
                allowedMembers = this.removeUnknownMembers(allowedMembers);
                SuperxSaikuConnectionManager.grantMembers(role, hierarchy, levels, allowedMembers);
            }
        }
    }

    private static void grantMembers(RoleImpl role, Hierarchy hierarchy, List<Level> levels, List<Member> allowedMembers) {
        int countAllowed = allowedMembers.size();
        Level topLevel = levels.get(0);
        Level bottomLevel = levels.get(levels.size() - 1);
        if (countAllowed == 0) {
            role.grant(hierarchy, Access.CUSTOM, topLevel, topLevel, Role.RollupPolicy.PARTIAL);
        } else {
            role.grant(hierarchy, Access.CUSTOM, topLevel, bottomLevel, Role.RollupPolicy.PARTIAL);
            for (Member member : allowedMembers) {
                role.grant(member, Access.ALL);
            }
        }
    }

    private String getUniqueNameFor(String bluep, Integer id) {
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        return (String)eduetlJdbcTemplate.queryForObject("select trim(uniquename) from dim_bp_apnr where dimension_bp_id=(select tid from dimension_bp where apnr=?) and apnr=?", new Object[]{bluep, id}, String.class);
    }

    private List<Member> removeUnknownMembers(Collection<Member> members) {
        ArrayList<Member> result = new ArrayList<Member>();
        for (Member member : members) {
            String name = member.getName().toLowerCase();
            if (name.equals("unbekannt")) continue;
            result.add(member);
        }
        return result;
    }

    public static enum OlapDimension {
        fachbereich("[bluep_fb.Fachbereich]", "Fachbereich", "bluep_fb"),
        studiengang("[bluep_studiengang.Studiengang]", "Studiengang", "bluep_studiengang"),
        lehreinheit("[bluep_lehr.Lehreinheit (intern)]", "Lehreinheit (intern)", "bluep_lehr"),
        institut("[bluep_ch110_institut.Institution]", "Institution", "bluep_ch110_institut"),
        kostenstelle("[bluep_kostenstelle.Kostenstelle]", "Kostenstelle", "bluep_kostenstelle");

        public String nameSegment;
        public String levelName;
        public String bluep;

        private OlapDimension(String nameSegment, String levelName, String bluep) {
            this.nameSegment = nameSegment;
            this.levelName = levelName;
            this.bluep = bluep;
        }

        public static String getBluepForLevelName(String levelName) {
            String bluep = null;
            for (OlapDimension olapDimension : OlapDimension.values()) {
                if (!olapDimension.levelName.equals(levelName)) continue;
                bluep = olapDimension.bluep;
                break;
            }
            return bluep;
        }
    }
}

