/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import de.memtext.baseobjects.User;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.CryptUtils;
import de.memtext.util.DateUtils;
import de.superx.common.DBServletException;
import de.superx.common.DatenblattFields;
import de.superx.common.DatenblattTables;
import de.superx.common.IsUserInAtLeastOneGroup;
import de.superx.common.IsUserInGroup;
import de.superx.common.IsUserInGroupWithName;
import de.superx.common.SelectionBuffer;
import de.superx.common.Sichten;
import de.superx.common.SxFinRechte;
import de.superx.common.SxKontierungsrechte;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.TableFieldExists;
import de.superx.common.ThemenbaumI;
import de.superx.common.UserHasMaskRight;
import de.superx.common.UserHasSachgebRight;
import freemarker.template.TemplateBooleanModel;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.GrantedAuthoritiesContainer;
import org.springframework.security.core.userdetails.UserDetails;

public class SxUser
extends User
implements Serializable,
UserDetails,
GrantedAuthoritiesContainer {
    private ThemenbaumI themenbaum;
    private static final Class[] NOCLASS = new Class[0];
    private static final Object[] NOOBJECTS = new Object[0];
    private Sichten sichten = new Sichten();
    private Collection erlaubteMaskenTids = new TreeSet();
    private Collection groups = new LinkedList();
    private Collection groupnames = new LinkedList();
    private Collection sachgebiete = new LinkedList();
    private String mandantenID = "default";
    private String[] oldShas = new String[7];
    private String currentSha;
    private SxFinRechte finRechte = new SxFinRechte();
    private Object fieldElementCache;
    private HashMap basicMap = new HashMap();
    private SelectionBuffer sb = new SelectionBuffer();
    private Collection hiddenFields = new LinkedList();
    private Map<String, Map<String, String>> rightsMap = new HashMap<String, Map<String, String>>();
    private String role;
    private SxKontierungsrechte sxKontontierungsrechte = new SxKontierungsrechte();
    private static final long serialVersionUID = 7L;

    public void init() {
        this.sichten.setUser(this);
        this.basicMap.put("SxFinRechte", this.finRechte);
        this.basicMap.put("SxKontierungsrechte", this.sxKontontierungsrechte);
        this.basicMap.put("Username", this.getName());
        this.basicMap.put("today", DateUtils.getTodayString());
        this.basicMap.put("yeartoday", DateUtils.getYear(new Date(new java.util.Date().getTime())));
        this.basicMap.put("databaseMajorVersion", new Integer(0));
        this.basicMap.put("databaseMinorVersion", new Integer(0));
        this.basicMap.put("DatenblattTables", new DatenblattTables(this.getMandantenID()));
        this.basicMap.put("DatenblattFields", new DatenblattFields());
        this.basicMap.put("TableFieldExists", new TableFieldExists(this.getMandantenID()));
    }

    public SxUser(String mandantenID) {
        this.setMandantenID(mandantenID);
        this.init();
    }

    public SxUser(String mandantenID, String username, String passwd) {
        super(username, passwd);
        this.setMandantenID(mandantenID);
        this.init();
    }

    public SxUser(String mandantenID, String username, Integer userid) throws SQLException, DBServletException, TransformerException {
        super(username, userid);
        this.setMandantenID(mandantenID);
        this.init();
    }

    public SelectionBuffer getSelectionBuffer() {
        return this.sb;
    }

    @Override
    public void setAdmin(boolean isAdmin) {
        super.setAdmin(isAdmin);
        this.basicMap.put("UserIsAdmin", this.isAdmin() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE);
        this.finRechte.setHasAllRights(isAdmin);
        this.sxKontontierungsrechte.setHasAllRights(true);
    }

    public void initThemenbaum(Class themenbaumClass) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, TransformerConfigurationException, KeyParentEqualException, SQLException, DBServletException, NichtAngemeldetException {
        this.themenbaum = (ThemenbaumI)themenbaumClass.getConstructor(NOCLASS).newInstance(NOOBJECTS);
        this.themenbaum.init((Integer)this.getId(), this.getName(), this.isAdmin(), this.getMandantenID());
    }

    public HashMap getBasicMap() {
        return this.basicMap;
    }

    public ThemenbaumI getThemenbaum() {
        return this.themenbaum;
    }

    public Sichten getSichten() {
        return this.sichten;
    }

    public void setUserid(Integer id) {
        super.setId(id);
    }

    public void clearCache() {
        this.sichten.clear();
    }

    public void initErlaubteMasken(SxResultSet rs) {
        for (SxResultRow row : rs) {
            this.erlaubteMaskenTids.add(row.get(0));
        }
        this.basicMap.put("UserMaskRights", this.getMaskRights());
        this.basicMap.put("UserHasMaskRight", new UserHasMaskRight(this));
    }

    public String getMaskRights() {
        StringBuffer result = new StringBuffer(",");
        Iterator it = this.erlaubteMaskenTids.iterator();
        while (it.hasNext()) {
            result.append(it.next() + ",");
        }
        return result.toString();
    }

    public void checkAuthentificationForMask(String tidStr) {
        if (tidStr == null) {
            throw new IllegalStateException("Kann Maske nicht \u00f6ffnen DETAILS:tid parameter war null");
        }
        if (!this.isMaskAllowed(tidStr)) {
            throw new IllegalArgumentException("Sie haben keine Berechtigung f\u00fcr Maske mit ID-Nummer " + tidStr);
        }
    }

    boolean isMaskAllowed(String tidStr) {
        boolean result = false;
        if (this.isAdmin()) {
            result = true;
        } else {
            try {
                result = this.erlaubteMaskenTids.contains(new Integer(tidStr));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isPWUsedBefore(String check) {
        boolean result = false;
        String sha1 = CryptUtils.encodeSHA(check);
        String sha2 = CryptUtils.encodeSHA(check + CryptUtils.geheimnis1);
        String sha512 = CryptUtils.encodeSHA512(check);
        for (int i = 0; i < 7; ++i) {
            if (this.oldShas[i] == null || !sha1.equals(this.oldShas[i]) && !sha2.equals(this.oldShas[i]) && !sha512.equals(this.oldShas[i])) continue;
            result = true;
        }
        return result;
    }

    public boolean isPWSHAUsedBefore(String sha) {
        boolean result = false;
        for (int i = 0; i < 7; ++i) {
            if (this.oldShas[i] == null || !sha.equals(this.oldShas[i])) continue;
            result = true;
        }
        return result;
    }

    public void setOldSha(int pos, String oldsha) {
        this.oldShas[pos] = oldsha;
    }

    public String getMandantenID() {
        return this.mandantenID;
    }

    private void setMandantenID(String mandantenID) {
        this.mandantenID = mandantenID;
    }

    public void rememberOldSHA(String oldsha) {
        for (int i = 6; i > 0; --i) {
            this.oldShas[i] = this.oldShas[i - 1];
        }
        this.oldShas[0] = oldsha;
    }

    public String getUser_PW_Command(int gueltigkeit) {
        String gueltig = "'1.1.3000'";
        if (gueltigkeit > 0) {
            gueltig = "'" + DateUtils.formatGerman(DateUtils.makeFutureDate(new Date(new java.util.Date().getTime()), gueltigkeit)) + "'";
        }
        String result = "delete from user_pw where userinfo_id='" + this.getId() + "'; insert into user_pw (userinfo_id,pw_gueltig_bis,old_sha1,old_sha2,old_sha3,old_sha4,old_sha5,old_sha6,old_sha7) values ('" + this.getId() + "',date_val(" + gueltig + ")";
        for (int i = 0; i < 7; ++i) {
            result = this.oldShas[i] == null ? result + ",null" : result + ",'" + this.oldShas[i] + "'";
        }
        result = result + ")";
        return result;
    }

    public String getCurrentSha() {
        return this.currentSha;
    }

    public void setCurrentSha(String sha) {
        this.currentSha = sha;
    }

    public void initFinRechte(SxResultSet rs, int finRightVariant, SxResultSet rsProjToInst, boolean is0FINJoker, HashMap repository) {
        this.finRechte.setVariant(finRightVariant);
        this.finRechte.setRepository(repository);
        this.finRechte.set0FINJoker(is0FINJoker);
        if (this.isAdmin()) {
            this.finRechte.setHasAllRights(true);
        }
        for (SxResultRow row : rs) {
            this.finRechte.createAndAddEntry(row);
        }
        for (SxResultRow row : rsProjToInst) {
            this.finRechte.addProj((String)row.get(0));
        }
    }

    public Object getFieldElementCache() {
        return this.fieldElementCache;
    }

    public void setFieldElementCache(Object fieldElementCache) {
        this.fieldElementCache = fieldElementCache;
    }

    public void setGroups(SxResultSet rs) {
        for (SxResultRow row : rs) {
            this.groups.add(row.get(0).toString());
            this.groupnames.add(row.get(1));
        }
        this.basicMap.put("UserGroups", this.getGroups());
        this.basicMap.put("UserSachgebiete", this.getSachgebiete());
        this.basicMap.put("UserGroupnames", this.getGroupnames());
        this.basicMap.put("IsUserInGroup", new IsUserInGroup(this));
        this.basicMap.put("IsUserInGroupWithName", new IsUserInGroupWithName(this));
        this.basicMap.put("IsUserInAtLeastOneGroup", new IsUserInAtLeastOneGroup(this));
    }

    public String getSachgebiete() {
        StringBuffer result = new StringBuffer(",");
        Iterator it = this.sachgebiete.iterator();
        while (it.hasNext()) {
            result.append(it.next() + ",");
        }
        return result.toString();
    }

    public String getGroups() {
        StringBuffer result = new StringBuffer(",");
        Iterator it = this.groups.iterator();
        while (it.hasNext()) {
            result.append(it.next() + ",");
        }
        return result.toString();
    }

    public String getGroupnames() {
        StringBuffer result = new StringBuffer(",");
        Iterator it = this.groupnames.iterator();
        while (it.hasNext()) {
            result.append(it.next() + ",");
        }
        return result.toString();
    }

    public boolean isInGroup(String group) {
        return this.groups.contains(group);
    }

    public boolean isInGroupWithName(String group) {
        return this.groupnames.contains(group);
    }

    public void setDBVersion(int databaseMajorVersion, int databaseMinorVersion) {
        this.basicMap.put("databaseMajorVersion", new Integer(databaseMajorVersion));
        this.basicMap.put("databaseMinorVersion", new Integer(databaseMinorVersion));
    }

    public void setHiddenFields(SxResultSet rs) {
        for (SxResultRow row : rs) {
            this.hiddenFields.add(row.get(0));
        }
    }

    public boolean isFieldHidingWanted(Object id) {
        return this.hiddenFields.contains(id);
    }

    public void setSachgebiete(SxResultSet rs) {
        for (SxResultRow row : rs) {
            this.sachgebiete.add(row.get(0).toString());
            this.basicMap.put("UserHasSachgebRight", new UserHasSachgebRight(this.sachgebiete));
        }
    }

    public Map<String, Map<String, String>> getRightsMap() {
        return this.rightsMap;
    }

    public void setRights(Map<String, Map<String, String>> rightsMap, String role) {
        if (role != null) {
            this.role = role;
        }
        if (rightsMap != null) {
            this.rightsMap = rightsMap;
        }
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.getGrantedAuthorities();
    }

    public String getPassword() {
        return "not_important";
    }

    public String getUsername() {
        return this.getName();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public Set<String> getHis1Rights() {
        Set<String> all = this.rightsMap.keySet();
        return Sets.filter(all, (Predicate)new Predicate<String>(){

            public boolean apply(String arg0) {
                return arg0.startsWith("RIGHT_");
            }
        });
    }

    public List<GrantedAuthority> getGrantedAuthorities() {
        List authorities = AuthorityUtils.createAuthorityList((String[])this.getRoles().toArray(new String[0]));
        authorities.add(new GrantedAuthority(){

            public String getAuthority() {
                return SxUser.this.role;
            }
        });
        return authorities;
    }

    private Set<String> getRoles() {
        Set<String> all = this.rightsMap.keySet();
        return Sets.filter(all, (Predicate)new Predicate<String>(){

            public boolean apply(String arg0) {
                return arg0.startsWith("ROLE_");
            }
        });
    }

    public void initKontierungsrechte(SxResultSet rs) {
        if (this.isAdmin()) {
            this.sxKontontierungsrechte.setHasAllRights(true);
        } else {
            this.sxKontontierungsrechte.clearAll();
            for (SxResultRow row : rs) {
                this.sxKontontierungsrechte.createAndAddEntry(row);
            }
        }
    }
}

