/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.NamedIdObject;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.CryptUtils;
import de.memtext.util.DateUtils;
import de.memtext.util.NumberUtils;
import de.memtext.util.StringUtils;
import de.superx.common.AbstractSicht;
import de.superx.common.DBServletException;
import de.superx.common.FieldContainer;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.SelectableItemTree;
import de.superx.common.SichtException;
import de.superx.common.Sichtgruppe;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import de.superx.common.UngueltigeEingabeException;
import de.superx.sec.CheckExecution;
import de.superx.servlet.ExternalPool;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class Field
extends NamedIdObject
implements TemplateHashModel,
TemplateMethodModel {
    private boolean isMacroMaskenSichtSet = false;
    String mandantenID = "default";
    private int nummer;
    private int x;
    private int y;
    private int buttonbreite;
    private int feldbreite;
    private int zeilenanzahl;
    private int laenge;
    private int obligatorisch;
    private int art;
    private Integer maskennummer;
    private String typ;
    private String relation;
    private String attribut;
    private String defaultwertString;
    private String selectedKey;
    private Locale locale;
    private String captionShort;
    private String captionLong;
    private SxResultSet captionSet;
    private Sichtgruppe sichtgruppe;
    private FieldContainer fieldContainer;
    private SelectableItemTree selectableItemsTree = new SelectableItemTree();
    private SelectableItem defaultValue;
    private boolean isSpecialSelectionApplied = false;
    private static final long serialVersionUID = 1L;
    private boolean isDynamic;
    private boolean isInited;
    public static boolean isTest = false;

    public boolean isMacroMaskenSichtSet() {
        return this.isMacroMaskenSichtSet;
    }

    public void setMacroMaskenSichtSet(boolean isMacroMaskenSichtSet) {
        this.isMacroMaskenSichtSet = isMacroMaskenSichtSet;
    }

    private Field(NamedIdObject namedIdObject, Integer maskennummer, SxResultSet captionSet) {
        this.setId(namedIdObject.getId());
        this.setName(namedIdObject.getName());
        this.captionSet = captionSet;
        this.maskennummer = maskennummer;
        if (this.getId() == null) {
            throw new IllegalArgumentException("Kann kein Feld mit tid=null aufbauen " + namedIdObject);
        }
    }

    public Field(String mandantenID, SxUser user, Integer maskennummer, SxResultRow feldRow, Locale locale, Hashtable formular, HashMap map, FieldContainer individualFields, SxResultSet captionSet) throws TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, SQLException, DBServletException, NoMainEntryException {
        this.mandantenID = mandantenID;
        this.maskennummer = maskennummer;
        this.captionSet = captionSet;
        this.setFieldContainer(individualFields);
        this.setId(feldRow.get(0));
        if (this.getId() == null) {
            throw new IllegalArgumentException("Kann kein Feld mit tid=null aufbauen " + feldRow);
        }
        Object o = feldRow.get(1);
        if (o == null) {
            throw new IllegalStateException("Feld ohne Name in felderinfo: " + this.getId());
        }
        if (o.toString().startsWith("@@@")) {
            o = o.toString().substring(3);
        }
        this.setName(o.toString());
        o = feldRow.get(2);
        if (o == null) {
            throw new IllegalStateException("Feld ohne Nummer in felderinfo: " + this.getId());
        }
        this.setNummer(Integer.parseInt(o.toString()));
        o = feldRow.get(3);
        if (o == null) {
            throw new IllegalStateException("Feld ohne x in felderinfo: " + this.getId());
        }
        this.setX(Integer.parseInt(o.toString()));
        o = feldRow.get(4);
        if (o == null) {
            throw new IllegalStateException("Feld ohne y in felderinfo: " + this.getId());
        }
        this.setY(Integer.parseInt(o.toString()));
        o = feldRow.get(5);
        if (o != null) {
            this.setButtonbreite(Integer.parseInt(o.toString()));
        }
        if ((o = feldRow.get(6)) != null) {
            this.setFeldbreite(Integer.parseInt(o.toString()));
        }
        if ((o = feldRow.get(7)) != null) {
            this.setZeilenanzahl(Integer.parseInt(o.toString()));
        }
        if ((o = feldRow.get(8)) == null) {
            throw new IllegalStateException("Feld ohne typ in felderinfo: " + this.getId());
        }
        this.setTyp(o.toString());
        o = feldRow.get(9);
        if (o == null) {
            throw new IllegalStateException("Feld ohne laenge in felderinfo: " + this.getId());
        }
        this.setLaenge(Integer.parseInt(o.toString()));
        o = feldRow.get(10);
        if (o == null) {
            throw new IllegalStateException("Feld ohne obligatorisch in felderinfo: " + this.getId());
        }
        this.setObligatorisch(Integer.parseInt(o.toString()));
        o = feldRow.get(11);
        if (o == null) {
            throw new IllegalStateException("Feld ohne art in felderinfo: " + this.getId());
        }
        this.setArt(Integer.parseInt(o.toString()));
        o = feldRow.get(12);
        if (o != null) {
            this.setRelation(o.toString());
        }
        if ((o = feldRow.get(13)) != null) {
            this.setAttribut(o.toString());
        }
        if (user.isFieldHidingWanted(this.getId())) {
            this.setAttribut("hidden");
        }
        int startpos = 0;
        if (this.getRelation() != null && this.getRelation().startsWith("<<SQL>>")) {
            startpos = 7;
        }
        if (this.isOldOrganigrammArt() || this.isSicht() || this.getRelation() != null && this.getRelation().indexOf(">>", startpos) > -1) {
            this.isDynamic = true;
        }
        if (!this.isDynamic && this.getArt() != 0 && this.getArt() != 19) {
            this.initSelectableItemsTree(formular, map, individualFields, user);
        }
        if ((o = feldRow.get(14)) != null) {
            this.setDefaultwertString(o.toString());
        }
        this.setLocale(locale);
    }

    public void setFieldContainer(FieldContainer fc) {
        this.fieldContainer = fc;
    }

    private void initSichtengruppe(Hashtable formular, HashMap map, FieldContainer individualFields, SxUser user) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, NoMainEntryException {
        LinkedList<Integer> sichtentids = new LinkedList<Integer>();
        if (this.getArt() == 12 && this.relation != null && this.relation.startsWith("<<SQL>>")) {
            String stmt = this.relation.substring(7);
            stmt = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), formular, stmt);
            SuperX_el el = ServletUtils.executeALL_el(null, null, "Sichten f\u00fcr Feld " + this.getName() + "(" + this.getId() + ") lesen", stmt, this.mandantenID, true);
            StringBuffer msg = new StringBuffer(" Gefundene Sichtentids f\u00fcr Feld " + this.getFeldInfo() + " ");
            for (SxResultRow aRow : el.getResultSet()) {
                Integer eineSichtTid = (Integer)aRow.get(0);
                sichtentids.add(eineSichtTid);
                msg.append(eineSichtTid + " ");
            }
            Logger.getLogger("superx_" + this.mandantenID).log(Level.FINE, msg.toString());
        }
        try {
            String neuerStand = DateUtils.getTodayString();
            if (!this.isHidden() && user.getSelectionBuffer().hasFieldStand(this.getName())) {
                neuerStand = user.getSelectionBuffer().getFieldStand(this.getName());
            }
            this.sichtgruppe = user.getSichten().getGruppe(formular, map, individualFields, this.getFeldInfo(), this.art, sichtentids, this.relation, this.getZeilenanzahl(), neuerStand, this.mandantenID);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SichtException("Initalisieren von Sichten f\u00fcr " + this.getFeldInfo() + " fehlgeschlagen. DETAILS:" + e.getMessage());
        }
    }

    protected void setDefaultSicht(Hashtable formular, HashMap map, FieldContainer individualFields, SxUser user) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        if (!this.isSicht() || !this.hasDynamicDefaultSicht()) {
            throw new IllegalArgumentException("Kann keine Defaultsicht f\u00fcr Feld " + this.getName() + "(" + this.getId() + ") setzen");
        }
        String stmt = this.getAttribut().replace("hidden", "");
        stmt = stmt.replace("<<Sicht>>", "");
        stmt = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), formular, stmt);
        SuperX_el el = ServletUtils.executeALL_el(null, null, "Defaultsicht f\u00fcr Feld " + this.getName() + "(" + this.getId() + ") lesen", stmt, this.mandantenID, true);
        Integer sichtTid = null;
        for (SxResultRow aRow : el.getResultSet()) {
            sichtTid = (Integer)aRow.get(0);
        }
        if (sichtTid == null) {
            throw new IllegalArgumentException("Keine Defaultsicht f\u00fcr Feld " + this.getName() + "(" + this.getId() + ") gefunden DETAILS: per sql:" + stmt + "  - Attributspalte: " + this.getAttribut() + " pr\u00fcfen");
        }
        this.setSicht(formular, map, individualFields, sichtTid, user);
    }

    protected boolean hasDynamicDefaultSicht() {
        return this.getAttribut() != null && this.getAttribut().indexOf("<<Sicht>>") > -1;
    }

    private String getFeldInfo() {
        return "Feld " + this.getName() + " (" + this.getId() + ")";
    }

    private void initCaptions() throws SQLException, DBServletException {
        String capShort = "";
        String capLong = "";
        boolean capIsSet = false;
        for (SxResultRow row : this.captionSet) {
            if (row.get(0) == null || !row.get(0).equals(this.getName()) || capIsSet) continue;
            String availableLocale = (String)row.get(1);
            if (availableLocale == null || availableLocale.equals("") || availableLocale.equals(this.locale.getLanguage().toString())) {
                capShort = row.get(2) != null ? row.get(2).toString() : "";
                capLong = row.get(3) != null ? row.get(3).toString() : "";
                capIsSet = true;
            }
            if (capIsSet) continue;
            if (availableLocale != null && availableLocale.equals("de")) {
                capShort = row.get(2) != null ? row.get(2).toString() : "";
            }
            capLong = row.get(3) != null ? row.get(3).toString() : "";
            capIsSet = true;
        }
        if (capShort != null && !capShort.equals("")) {
            this.setCaptionShort(capShort);
        }
        if (capLong != null && !capLong.equals("")) {
            this.setCaptionLong(capLong);
        }
    }

    private SxResultRow readCaptionsFromDb(String select_string) throws SQLException, DBServletException {
        SxResultRow ret = new SxResultRow(0, 1);
        SuperX_el field_el = ServletUtils.executeALL_el(null, null, "Caption SQL durchf\u00fchren", select_string, this.mandantenID, true);
        String errorstring = field_el.getError_String();
        if (errorstring != null && !errorstring.equals("")) {
            ret.add(0, "SQL-Fehler:" + errorstring + "<br />sql: " + field_el);
            ret.add(1, "");
            return ret;
        }
        SxResultSet rs = field_el.getResultSet();
        if (!rs.isEmpty() && (ret = (SxResultRow)rs.first()).size() == 1) {
            ret.add(1, "");
        }
        return ret;
    }

    public int getArt() {
        return this.art;
    }

    public void setArt(int art) {
        this.art = art;
    }

    public SelectableItemTree getSelectableItemsTree() {
        return this.selectableItemsTree;
    }

    public String getAttribut() {
        return this.attribut;
    }

    public void setAttribut(String attribut) {
        this.attribut = attribut;
    }

    public boolean isHidden() {
        return this.attribut != null && this.attribut.equals("hidden") || this.getArt() == 13 || this.getName().equals("User-tid") || this.getName().equals("Gruppen-tid") || this.getName().equals("Benutzerkennung");
    }

    public int getButtonbreite() {
        return this.buttonbreite;
    }

    public void setButtonbreite(int buttonbreite) {
        this.buttonbreite = buttonbreite;
    }

    public String getDefaultwertString() {
        return this.defaultwertString;
    }

    private void setDefaultwertString(String df) throws SQLException {
        this.defaultwertString = SxPools.get(this.mandantenID).checkImports(df, this.maskennummer.toString());
    }

    private String paramAdaptCommaWildcard(String param) {
        if (this.getZeilenanzahl() < 2 || this.getTyp().equals("sql") || this.getArt() == 0 || this.getArt() == 19 || this.getArt() == 13) {
            return param;
        }
        String result = "";
        if (param != null) {
            if ((param = param.replace('|', ',')).indexOf(",") > -1) {
                boolean isFirst = true;
                StringTokenizer st = new StringTokenizer(param, ",");
                while (st.hasMoreElements()) {
                    String aparam = st.nextToken();
                    if (aparam.indexOf("*") > -1) {
                        aparam = this.paramAdaptCommaWildcard(aparam);
                    }
                    if (!isFirst) {
                        result = result + "|";
                    } else {
                        isFirst = false;
                    }
                    result = result + aparam;
                }
            } else {
                result = param;
            }
            if (result.indexOf("*") > -1) {
                if (this.isOldOrganigrammArt() || this.isSicht()) {
                    this.getSichtgruppe().getSelectedSicht().setSubelementsinForEach(false);
                }
                result = this.selectableItemsTree.getSuitingKeyString(result);
            }
        }
        return result;
    }

    public boolean hasKeys(boolean isMehrfachAuswahl, String key) {
        boolean result = true;
        if (!isMehrfachAuswahl) {
            result = this.selectableItemsTree.getById(key) != null;
        } else {
            boolean pipe;
            String token = ",";
            boolean bl = pipe = key.indexOf(124) > -1;
            if (pipe) {
                token = "|";
            }
            StringTokenizer st = new StringTokenizer(key, token);
            if (this.getArt() != 0) {
                while (st.hasMoreElements()) {
                    if (this.selectableItemsTree.getById(st.nextToken()) != null) continue;
                    result = false;
                }
            }
        }
        if (this.getArt() == 0) {
            result = true;
        }
        if (this.getArt() == 19) {
            result = false;
        }
        return result;
    }

    public void updateDefaultValue(Hashtable formular, HashMap map, FieldContainer individualFields, String param, boolean isTableServletAndEmptyStringParam, SxUser user) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
        CheckExecution check;
        this.defaultValue = null;
        boolean resetWanted = false;
        if (param != null && param.equals("--leer--")) {
            resetWanted = true;
            param = "";
            this.selectableItemsTree.clearSelection();
        }
        if (this.getTyp().equals("date") && (param = this.xDateParamOhneApostrophes(param)) != null && param.indexOf("-") > -1) {
            param = SqlStringUtils.formatDateUStoDE(param);
        }
        if (param != null && !param.equals("")) {
            this.checkDataType(param);
        }
        if (param != null && !param.equals("") && this.art == 0 && !(check = new CheckExecution(this)).run(param)) {
            System.err.println("Ung\u00fcltige Eingabe Feld " + this.getFeldInfo());
            throw new UngueltigeEingabeException("Ung\u00fcltige Eingabe");
        }
        if (this.getArt() != 0 && this.getArt() != 19 && !this.isInited()) {
            this.initSelectableItemsTree(formular, map, individualFields, user);
        }
        if (this.isOldOrganigrammArt() || this.isSicht()) {
            this.getSichtgruppe().getSelectedSicht().setSubelementsinForEach(true);
        }
        if (this.getZeilenanzahl() > 1 && !this.getTyp().equals("sql")) {
            param = this.paramAdaptCommaWildcard(param);
        }
        this.check(param);
        String stmt = SqlStringUtils.adaptSql(SxPools.get(this.mandantenID).getSqlDialect(), this.defaultwertString, null);
        if (stmt != null && !stmt.equals("")) {
            stmt = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), formular, stmt);
            stmt = stmt.replace("@@TID@@", "" + this.getId());
            this.defaultValue = this.readDefaultwertFromDb(user, stmt, formular);
        } else if (this.art == 0 || this.art == 13 || this.art == 19) {
            this.defaultValue = new SelectableItem(this.defaultwertString, this.defaultwertString);
        } else if ((param == null || param.equals("")) && this.defaultwertString != null) {
            param = new String(this.defaultwertString);
        }
        if (param != null && !param.equals("")) {
            if (this.art == 1 && this.typ.equals("date")) {
                if (!param.startsWith("'")) {
                    param = "'" + param;
                }
                if (!param.endsWith("'")) {
                    param = param + "'";
                }
            }
            if (this.art == 0 || this.art == 10 || this.art == 11 || this.art == 13 || this.art == 19 || this.art == 18) {
                if (this.art == 10 && param.isEmpty()) {
                    param = "false";
                }
                this.defaultValue = new SelectableItem(param, param);
            } else {
                try {
                    if (param.indexOf("|") > -1) {
                        this.defaultValue = new SelectableItem(param, this.getMultiNames(param));
                        this.defaultValue.setTemporary(true);
                        this.selectableItemsTree.setSelectedKeys(param);
                    } else {
                        SelectableItemNode node = this.selectableItemsTree.getById(param);
                        if (node == null) {
                            throw new UngueltigeEingabeException(this.getName() + " ung\u00fcltige Eingabe");
                        }
                        this.defaultValue = (SelectableItem)node.getUserObject();
                        this.selectableItemsTree.setSelectedKey(param);
                    }
                }
                catch (IllegalArgumentException e) {
                    System.out.println(this.getFeldInfo() + " ung\u00fcltiger Defaultwert:" + param + " ausw\u00e4hlbar gewesen w\u00e4re:");
                    StringBuffer buf = new StringBuffer();
                    Enumeration<TreeNode> en = ((DefaultMutableTreeNode)this.selectableItemsTree.getModel().getRoot()).breadthFirstEnumeration();
                    while (en.hasMoreElements()) {
                        SelectableItemNode n = (SelectableItemNode)en.nextElement();
                        if (n.isRoot()) continue;
                        buf.append(n + "\n");
                    }
                    System.out.println(buf);
                    throw new UngueltigeEingabeException(this.getName() + " ung\u00fcltige Eingabe");
                }
            }
        }
        if (isTableServletAndEmptyStringParam) {
            this.defaultValue = null;
        }
        if (this.defaultValue == null || resetWanted) {
            this.defaultValue = new SelectableItem("", "");
        }
    }

    public String getDefaultValueKey() {
        String result = "";
        if (this.defaultValue != null) {
            result = this.defaultValue.getId().toString();
        }
        return result;
    }

    private SelectableItem readDefaultwertFromDb(SxUser user, String stmt, Hashtable formular) throws DBServletException, SQLException, TemplateException, IOException {
        String name;
        Object key;
        stmt = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), formular, stmt);
        HashMap map = new HashMap();
        if (user != null) {
            map.putAll(user.getBasicMap());
        }
        stmt = SxPools.get(this.mandantenID).getTemplateProcessor().process(map, this.maskennummer, "Felddefault " + this.getId(), stmt, this.fieldContainer, SxPools.get(this.mandantenID).getRepository(), SxPools.get(this.mandantenID).getSqlDialect());
        ExternalPool ep = ServletUtils.getExternalPoolIfSpecified(this.mandantenID, this.maskennummer, this.defaultwertString);
        SuperX_el el = ServletUtils.executeALL_el(ep, null, "Defaultwert f\u00fcr Feld " + this.getName() + " (" + this.getId() + ") ermitteln", stmt, this.mandantenID, true);
        SxResultSet result = el.getResultSet();
        if (result.size() == 0) {
            return new SelectableItem("", "");
        }
        SxResultRow defaultrow = (SxResultRow)result.first();
        if (result.size() > 1) {
            System.out.println(this.getFeldInfo() + " default-sql " + stmt + " lieferte mehrere Werte, Mehrfachauswahl wird aber nicht unterst\u00fctzt, nur 1. Wert wird genommen");
        }
        if ((key = defaultrow.get(0)) == null) {
            return new SelectableItem("", "");
        }
        if (defaultrow.size() > 1) {
            name = this.formatName(defaultrow.get(1));
        } else {
            SelectableItemNode node = null;
            if (this.selectableItemsTree != null) {
                node = this.selectableItemsTree.getById(key.toString());
            }
            name = node != null ? node.getName() : this.formatName(key);
        }
        return new SelectableItem(key, name);
    }

    public int getFeldbreite() {
        return this.feldbreite;
    }

    public void setFeldbreite(int feldbreite) {
        this.feldbreite = feldbreite;
    }

    public int getLaenge() {
        return this.laenge;
    }

    public void setLaenge(int laenge) {
        this.laenge = laenge;
    }

    public int getNummer() {
        return this.nummer;
    }

    public void setNummer(int nummer) {
        this.nummer = nummer;
    }

    public int getObligatorisch() {
        return this.obligatorisch;
    }

    public void setObligatorisch(int obligatorisch) {
        this.obligatorisch = obligatorisch;
    }

    public boolean isObligatorisch() {
        return this.obligatorisch == 1;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String relation) throws SQLException {
        if (relation != null && relation.trim().equals("")) {
            relation = null;
        }
        this.relation = SxPools.get(this.mandantenID).checkImports(relation, this.maskennummer.toString());
    }

    public String getTyp() {
        return this.typ;
    }

    public void setTyp(String typ) {
        this.typ = typ.toLowerCase().trim();
        if (!(this.typ.equals("integer") || this.typ.equals("decimal") || this.typ.equals("date") || this.typ.equals("time") || this.typ.equals("timestamp") || this.typ.equals("char") || this.typ.equals("sql"))) {
            throw new IllegalArgumentException("Ung\u00fcltiger Typ: " + typ + " f\u00fcr Feld " + this.getId());
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZeilenanzahl() {
        return this.zeilenanzahl;
    }

    public void setZeilenanzahl(int zeilenanzahl) {
        this.zeilenanzahl = zeilenanzahl;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale newlocale) throws SQLException, DBServletException {
        if (this.locale == null || !this.locale.equals(newlocale)) {
            this.locale = newlocale;
            this.initCaptions();
        }
    }

    public String getCaptionShort() {
        return this.captionShort;
    }

    public void setCaptionShort(String cap) {
        this.captionShort = cap;
    }

    public String getCaptionLong() {
        return this.captionLong;
    }

    public void setCaptionLong(String cap) {
        this.captionLong = cap;
    }

    private void initSelectableItemsTree(Hashtable formular, HashMap map, FieldContainer individualFields, SxUser user) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        ((DefaultMutableTreeNode)this.selectableItemsTree.getModel().getRoot()).removeAllChildren();
        this.isInited = true;
        String stmt = SqlStringUtils.createRelationString(SxPools.get(this.mandantenID).getSqlDialect(), "" + this.getArt(), this.getRelation(), this.getAttribut());
        if (stmt.equals("")) {
            return;
        }
        if (this.isOldOrganigrammArt() || this.isSicht()) {
            if (user == null) {
                throw new IllegalStateException("Da der Parameter user an Field.initSelectableItemTree null war, kann kein Organigramm bzw Sicht eingelesen werden");
            }
            if (this.sichtgruppe == null) {
                this.initSichtengruppe(formular, map, individualFields, user);
            }
            if (!this.isHidden() && user.getSelectionBuffer().hasFieldSicht(this.getName()) && this.sichtgruppe.containsItemWithId(new Integer(user.getSelectionBuffer().getFieldSicht(this.getName())))) {
                this.sichtgruppe.setSelectedSicht(new Integer(user.getSelectionBuffer().getFieldSicht(this.getName())));
                if (!this.isHidden() && user.getSelectionBuffer().hasFieldStand(this.getName())) {
                    this.sichtgruppe.setStand(formular, map, individualFields, user.getSelectionBuffer().getFieldStand(this.getName()));
                }
            }
            this.selectableItemsTree = this.sichtgruppe.getSelectedSicht();
            this.updateSichtenInFormular(formular);
        } else {
            SxResultSet rohform;
            if (formular != null) {
                stmt = SqlStringUtils.generateSQL(SxPools.get(this.mandantenID).getDatabaseAbbr(), formular, stmt);
            }
            stmt = SxPools.get(this.mandantenID).getTemplateProcessor().process(map, this.maskennummer, "Feld " + this.getId(), stmt, this.fieldContainer, SxPools.get(this.mandantenID).getRepository(), SxPools.get(this.mandantenID).getSqlDialect());
            String msg = "Ausf\u00fchren des relations-Sqls f\u00fcr Feld " + this.getName() + " (" + this.getId() + ")";
            int startSuchPos = 0;
            if (this.relation.startsWith("<<SQL>>")) {
                startSuchPos = 7;
            }
            if (this.relation.indexOf("<<", startSuchPos) > -1) {
                msg = msg + " Es sind Tags wie << Semester >> enthalten, alle ben\u00f6tigten Felder m\u00fcssen eine kleinere Felderinfo-tid haben\nund einen Defaultwert ausgew\u00e4hlt haben ";
            }
            if (SxPools.get(this.mandantenID).getFieldElementCache().containsEntry(stmt)) {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.FINER, " hole aus Cache: SQL f\u00fcr Feld " + this.getName() + " (" + this.getId() + "): " + stmt);
                rohform = SxPools.get(this.mandantenID).getFieldElementCache().get(stmt);
            } else {
                Logger.getLogger("superx_" + this.mandantenID).log(Level.FINER, "SQL f\u00fcr Feld " + this.getName() + " (" + this.getId() + "): " + stmt);
                ExternalPool ep = ServletUtils.getExternalPoolIfSpecified(this.mandantenID, this.maskennummer, this.getRelation());
                rohform = ServletUtils.executeALL_el(ep, null, msg, stmt, this.mandantenID, true).getResultSet();
            }
            int idPos = 0;
            int namePos = 1;
            if (this.isOldOrganigrammArt() || this.isTreeView()) {
                idPos = 1;
                namePos = 0;
            }
            this.selectableItemsTree.add(new SelectableItemNode(new SelectableItem("", "")));
            for (SxResultRow element : rohform) {
                Object id = element.get(idPos);
                String name = element.size() > 1 ? this.formatName(element.get(namePos)) : id.toString();
                if (this.getArt() != 1 || this.getTyp().equalsIgnoreCase("date")) {
                    // empty if block
                }
                SelectableItem item = new SelectableItem(id, name);
                if (element.size() > 2 && rohform.getColumnName(2).equals("nodeattrib")) {
                    item.setNodeAttrib(element.get(2));
                }
                if (this.isOldOrganigrammArt()) {
                    item.setOrganigrammItem(true);
                    item.setParentKey(element.get(2));
                    item.setAllowed(element.get(3) != null && element.get(3).toString().equals("1"));
                }
                if (this.isTreeView()) {
                    item.setTreeView(true);
                    item.setParentKey(element.get(2));
                }
                SelectableItemNode newnode = new SelectableItemNode(item);
                newnode.setAllowed(true);
                this.selectableItemsTree.add(newnode);
            }
        }
        if (!this.isDynamic() && this.getArt() != 0 && this.getArt() != 19 && this.isObligatorisch() && !this.hasEntries()) {
            throw new IllegalStateException("Das Feld " + this.getName() + " ist obligatorisch, enth\u00e4lt aber keine Werte zur Auswahl - wahrscheinlich keine Daten vorhanden");
        }
    }

    public boolean hasEntries() {
        boolean result = false;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.selectableItemsTree.getModel().getRoot();
        Enumeration<TreeNode> en = root.children();
        while (en.hasMoreElements()) {
            SelectableItemNode child = (SelectableItemNode)en.nextElement();
            if (child.getName().equals("")) continue;
            result = true;
        }
        return result;
    }

    private void updateSichtenInFormular(Hashtable formular) {
        formular.put(this.sichtgruppe.getArt(), this.sichtgruppe.getSelectedSicht().getId().toString());
        formular.put(this.getName() + "-Sicht", this.sichtgruppe.getSelectedSicht().getId().toString());
        formular.put(this.sichtgruppe.getArt() + "-Stand", " date_val('" + this.sichtgruppe.getStand() + "')");
        if (this.sichtgruppe.getArt().endsWith("-Sicht")) {
            formular.put(StringUtils.removeFromEnd(this.sichtgruppe.getArt(), "Sicht", true) + "Stand", " date_val('" + this.sichtgruppe.getStand() + "')");
        }
        formular.put(this.getName() + "-Stand", " date_val('" + this.sichtgruppe.getStand() + "')");
    }

    private String formatName(Object o) {
        String result = "";
        if (o != null) {
            result = o.toString();
            if (o instanceof java.util.Date) {
                result = DateUtils.format((Date)o);
            }
        }
        return result;
    }

    public boolean isOldOrganigrammArt() {
        boolean result = false;
        if (this.getArt() == 4 || this.getArt() == 6 || this.getArt() == 7) {
            result = true;
        }
        return result;
    }

    public boolean isTreeView() {
        return this.getArt() == 9;
    }

    public boolean isSicht() {
        return this.getArt() == 12;
    }

    public boolean isOrganigrammSichtArt() {
        boolean result = false;
        if (this.isSicht() && this.sichtgruppe.getArt().startsWith("Organigramm")) {
            result = true;
        }
        return result;
    }

    public String getSelectedKeyEscaped() {
        String escaped = "";
        if (this.selectedKey == null) {
            escaped = this.getEscaped(this.selectedKey);
        } else if (this.selectedKey.indexOf("|") == -1) {
            escaped = this.getEscaped(this.selectedKey);
        } else {
            StringTokenizer st = new StringTokenizer(this.selectedKey, "|");
            while (st.hasMoreTokens()) {
                escaped = escaped + this.getEscaped(st.nextToken()) + ",";
            }
            if (escaped.endsWith(",")) {
                escaped = StringUtils.deleteLastChar(escaped);
            }
        }
        return escaped;
    }

    private String getEscaped(String key) {
        int feldart = this.getArt();
        String escapedKey = "";
        if (key != null) {
            escapedKey = new String(key);
        }
        if (this.getTyp().equals("date") && !escapedKey.equals("") && !escapedKey.startsWith("'")) {
            escapedKey = "'" + escapedKey + "'";
        }
        if (feldart == 11) {
            escapedKey = CryptUtils.encodeSHA(escapedKey + CryptUtils.geheimnis1);
        }
        if (this.getTyp().equals("char") || this.getTyp().equals("time")) {
            String charcode1 = "'";
            String charcode2 = "'";
            if ((escapedKey = SqlStringUtils.escapeString(escapedKey)).length() > 0) {
                escapedKey = SqlStringUtils.unescapeString(escapedKey).equals("--leer--") ? charcode1 + charcode2 : charcode1 + escapedKey + charcode2;
            }
        }
        if ((this.isOldOrganigrammArt() || this.isOrganigrammSichtArt()) && escapedKey.equals("")) {
            escapedKey = "'null'";
        }
        if (this.getTyp().equals("sql")) {
            escapedKey = escapedKey.replace(';', '^');
        }
        return escapedKey;
    }

    public void initIfNeeded(Hashtable formular, HashMap map, FieldContainer individualFields, SxUser user) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        if (this.getArt() != 0 && this.getArt() != 19 && !this.isInited) {
            this.initSelectableItemsTree(formular, map, individualFields, user);
        }
    }

    public String getSelectedKeyXml(Hashtable formular, HashMap map, FieldContainer individualFields, SxUser user) throws ParseException, InvalidKeyException, SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        StringBuffer result = null;
        this.initIfNeeded(formular, map, individualFields, user);
        if (this.isSelectedKeyEmpty() && !this.isSicht()) {
            result = new StringBuffer("");
        } else {
            result = new StringBuffer("<feld varname=\"" + this.getName() + "\" art=\"" + this.getArt() + "\" typ=\"" + this.getTyp() + "\" tid=\"" + this.getId().toString() + "\"");
            if (this.isOldOrganigrammArt() || this.isSicht() && this.sichtgruppe.getSelectedSicht().isStandbuttonWanted()) {
                result.append(" stand=\"" + this.sichtgruppe.getSelectedSicht().getStand() + "\"");
                result.append(" isstandtoday=\"" + (DateUtils.isToday(this.sichtgruppe.getSelectedSicht().getStand()) ? "true" : "false") + "\"");
            }
            if (this.isSicht()) {
                result.append(" sichtenzahl=\"" + this.sichtgruppe.size() + "\" ");
            }
            result.append("><caption_short><![CDATA[" + this.getCaptionShort() + "]]></caption_short><caption_long><![CDATA[" + this.getCaptionLong() + "]]></caption_long>" + this.getValueXml());
            if (this.isSicht()) {
                result.append("<sicht name_intern=\"" + this.sichtgruppe.getSelectedSicht().getName_intern() + "\" tid=\"" + this.sichtgruppe.getSelectedSicht().getId() + "\" isFirstInGroup=\"" + (this.sichtgruppe.getSelectedSicht().isFirstInGroup() ? "true" : "false") + "\"");
                result.append("><![CDATA[" + this.sichtgruppe.getSelectedSicht().getName() + "]]></sicht>");
            }
            result.append("</feld>\n");
        }
        return result.toString();
    }

    public String getValueXml() throws ParseException {
        String valueCaption = this.getSelectedKeyValueCaption();
        if (this.isSicht() && this.isSelectedKeyEmpty()) {
            valueCaption = "keine Einschr\u00e4nkung";
        }
        return "<value><![CDATA[" + this.getKeyEscaped(this.selectedKey) + "]]></value><value_caption><![CDATA[" + SqlStringUtils.unescapeString(valueCaption) + "]]></value_caption>";
    }

    public String getSelectedKeyValueCaption() throws ParseException {
        String valueCaption = "";
        if (!this.isSelectedKeyEmpty()) {
            this.getKeyEscaped(this.selectedKey);
            if (this.getArt() == 0 || this.getArt() == 19 || this.getArt() == 10) {
                valueCaption = "";
                if (this.selectedKey != null) {
                    valueCaption = this.selectedKey.toString();
                }
            }
            if (!this.isSelectedKeyEmpty() && this.selectableItemsTree.getRoot().getChildCount() > 0) {
                if (this.selectedKey.indexOf("|") > -1) {
                    valueCaption = this.getMultiNames(this.selectedKey);
                } else {
                    SelectableItemNode item = this.selectableItemsTree.getById(this.selectedKey);
                    valueCaption = item.getName();
                }
            }
        }
        return valueCaption;
    }

    boolean isSelectedKeyEmpty() {
        return this.selectedKey == null || this.selectedKey.equals("null") || this.selectedKey.equals("");
    }

    private void throwInvalidKey() throws InvalidKeyException {
        AbstractSicht sicht;
        StringBuffer msg = new StringBuffer("Ung\u00fcltiger Schl\u00fcssel:\"" + this.selectedKey + "\" f\u00fcr das Feld " + this.getName() + " DETAILS: (tid " + this.getId() + ").\nDer Wert kommt nicht in den ausw\u00e4hlbaren Werten des Felds vor.\n");
        if (this.isSicht()) {
            msg.append(" Die m\u00f6glichen Auswahlwerte werden durch die Sicht (vergl. Spalte relation in Felderinfo) definiert.\n");
            sicht = this.sichtgruppe.getSelectedSicht();
            if (sicht == null) {
                msg.append(" Es war keine Sicht ausgew\u00e4hlt.\n");
            } else {
                msg.append("Ausgew\u00e4hlt war Sicht " + sicht.getName() + "(" + sicht.getId() + ") Stand:" + sicht.getStand() + "\n");
            }
        } else if (this.isOldOrganigrammArt()) {
            msg.append(" Die m\u00f6glichen Auswahlwerte werden durch das Organigramm, Feldart " + this.getArt() + " definiert.\n");
            sicht = this.sichtgruppe.getSelectedSicht();
            if (sicht == null) {
                msg.append(" Es war intern keine Sicht f\u00fcr diese Feldart ausgew\u00e4hlt.\n");
            } else {
                msg.append("Gew\u00e4hlter Stand:" + sicht.getStand() + "\n");
            }
        } else if (this.getRelation() != null && this.getRelation().startsWith("<<SQL>>")) {
            msg.append("  Die m\u00f6glichen Auswahlwerte werden durch das in der Spalte relation hinterlegte SQL-Statement definiert:\n " + this.getRelation());
        } else {
            msg.append(" Die m\u00f6glichen Auswahlwerte werden durch die Spalte relation (und ggfs.attribut) definiert.\n");
        }
        msg.append("\n");
        if (this.getArt() != 0 && this.getArt() != 19 && this.selectableItemsTree != null && this.selectableItemsTree.getRoot() != null) {
            msg.append("Ausw\u00e4hlbar w\u00e4ren die folgenden Schl\u00fcssel gewesen:\n");
            SelectableItemNode sin = null;
            Enumeration<TreeNode> en = this.selectableItemsTree.getRoot().preorderEnumeration();
            while (en.hasMoreElements()) {
                sin = (SelectableItemNode)en.nextElement();
                msg.append(sin.getKey() + " : Bezeichnung: " + sin.getName() + "\n");
            }
        }
        throw new InvalidKeyException(msg.toString());
    }

    public Sichtgruppe getSichtgruppe() {
        return this.sichtgruppe;
    }

    public void setSelectedKey(String selectedKey) throws InvalidKeyException, InvalidDataTypeException {
        if (selectedKey != null && selectedKey.equals("--leer--")) {
            selectedKey = "";
        }
        if (this.getZeilenanzahl() > 1) {
            if (this.isOldOrganigrammArt() || this.isSicht()) {
                this.getSichtgruppe().getSelectedSicht().setSubelementsinForEach(true);
            }
            selectedKey = this.paramAdaptCommaWildcard(selectedKey);
        }
        this.check(selectedKey);
        this.selectedKey = selectedKey;
        if (this.selectedKey != null && !this.selectedKey.equals("") & this.getTyp().equals("date")) {
            this.xSelectedKeyDatePr\u00fcfen();
        }
        if (!(this.selectedKey == null || this.selectedKey.equals("") || this.getArt() == 1 && this.selectedKey.indexOf("|") > -1)) {
            this.checkDataType(this.selectedKey);
        }
        this.xDirekteingabeSQLoderCharL\u00e4ngePr\u00fcfen();
        if (this.isOldOrganigrammArt() || this.isSicht() || this.selectableItemsTree.getRoot().getChildCount() > 0) {
            if (this.isSelectedKeyEmpty()) {
                this.selectableItemsTree.clearSelection();
                this.defaultValue = new SelectableItem("", "");
            } else {
                try {
                    if (this.selectedKey.indexOf("|") == -1 || this.getTyp().equals("sql")) {
                        this.selectableItemsTree.setSelectedKey(this.selectedKey);
                    } else {
                        this.selectableItemsTree.setSelectedKeys(this.selectedKey);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.throwInvalidKey();
                }
            }
        }
    }

    private void xDirekteingabeSQLoderCharL\u00e4ngePr\u00fcfen() {
        if (this.selectedKey != null && (this.getArt() == 0 || this.getArt() == 13 || this.getArt() == 19) && (this.getTyp().equals("sql") || this.getTyp().equals("char"))) {
            if (this.laenge == 0) {
                throw new IllegalStateException("In felderinfo ist 0 f\u00fcr laenge hinterlegt " + this.getFeldInfo());
            }
            if (this.selectedKey.trim().length() > this.laenge) {
                throw new IllegalArgumentException("Eingabe war l\u00e4nger als die vorgesehene maximale Zahl von " + this.laenge + " Zeichen - " + this.getFeldInfo());
            }
        }
    }

    private void xSelectedKeyDatePr\u00fcfen() throws InvalidKeyException {
        Date d;
        this.selectedKey = this.xDateParamOhneApostrophes(this.selectedKey);
        if (this.selectedKey != null && this.selectedKey.indexOf("-") > -1) {
            this.selectedKey = SqlStringUtils.formatDateUStoDE(this.selectedKey);
        }
        try {
            d = DateUtils.parse(this.selectedKey);
        }
        catch (ParseException e) {
            throw new InvalidKeyException("Ung\u00fcltige Eingabe f\u00fcr Feld " + this.getName());
        }
        this.selectedKey = DateUtils.formatGerman(d);
        if (!this.selectedKey.startsWith("'")) {
            this.selectedKey = "'" + this.selectedKey;
        }
        if (!this.selectedKey.endsWith("'")) {
            this.selectedKey = this.selectedKey + "'";
        }
    }

    private void check(String key) {
        if (this.getZeilenanzahl() > 1 && this.getArt() != 0 && this.getArt() != 13 && this.getArt() != 19 && key != null && (key.indexOf("|") > -1 || key.indexOf(",") > -1)) {
            if (this.getArt() != 1 && this.getArt() != 12) {
                throw new IllegalArgumentException("Trennzeichen | oder , f\u00fcr Mehrfachauswahl gefunden - diese wird aber nur von Feldart 1 und 12 unterst\u00fctzt");
            }
            if (!this.getTyp().equals("sql") && this.getZeilenanzahl() < 2) {
                System.out.println(this.getFeldInfo() + " falsches Trennzeichen:" + key);
                throw new IllegalArgumentException("Trennzeichen | oder , f\u00fcr Mehrfachauswahl gefunden - wird von " + this.getFeldInfo() + " nicht unterst\u00fctzt");
            }
        }
    }

    public static void main(String[] args) {
    }

    private String xDateParamOhneApostrophes(String key) {
        String result = key;
        if (this.getTyp().equals("date") && key != null) {
            if (key.startsWith("'")) {
                result = result.substring(1);
            }
            if (key.endsWith("'")) {
                result = result.substring(0, key.length() - 2);
            }
        }
        return result;
    }

    private void checkDataType(String key) throws InvalidDataTypeException {
        if (!(this.getTyp().equals("sql") || this.getArt() == 0 || this.getArt() == 13 || this.getArt() == 19 || key.indexOf("|") <= -1 && key.indexOf(",") <= -1)) {
            String tmpkey = key.replace(',', '|');
            StringTokenizer st = new StringTokenizer(tmpkey, "|");
            while (st.hasMoreElements()) {
                String akey = st.nextToken();
                this.checkDataType(akey);
            }
        } else {
            String test;
            if (this.getTyp().equals("integer")) {
                try {
                    Integer.parseInt(key);
                }
                catch (NumberFormatException e) {
                    throw new InvalidDataTypeException("Ung\u00fcltige Eingabe f\u00fcr Feld " + this.getName() + "<br> (erwarteter Datentyp ist " + this.getTyp() + ")");
                }
            }
            if (this.getTyp().equals("decimal")) {
                try {
                    NumberUtils.parse(key);
                }
                catch (ParseException e) {
                    throw new InvalidDataTypeException("Ung\u00fcltige Eingabe f\u00fcr Feld " + this.getName() + "<br> (erwarteter Datentyp ist " + this.getTyp() + ")");
                }
            }
            if (this.getTyp().equals("date") && key != null && !key.equals("") && !DateUtils.isValidDate(test = StringUtils.replace(key, "'", ""))) {
                throw new InvalidDataTypeException("Ung\u00fcltige Eingabe f\u00fcr Feld " + this.getName() + "<br> (erwarteter Datentyp ist " + this.getTyp() + ")");
            }
            if ((this.getTyp().equals("decimal") || this.getTyp().equals("time") || this.getTyp().equals("timestamp")) && (key.indexOf("'") > -1 || key.indexOf(59) > -1 || key.indexOf("\"") > -1 || key.indexOf("--") > -1)) {
                throw new InvalidDataTypeException("Ung\u00fcltige Eingabe f\u00fcr Feld " + this.getName() + "<br> (erwarteter Datentyp ist " + this.getTyp() + ")");
            }
        }
    }

    private void addTempMultiSelectionElement(String selectedKeys) {
        StringTokenizer st = new StringTokenizer(selectedKeys, "|");
        String tmpname = "";
        while (st.hasMoreTokens()) {
            String akey = st.nextToken();
            SelectableItemNode node = this.selectableItemsTree.getById(akey);
            if (node == null) {
                System.out.println("Feld " + this.getName() + " (" + this.getId() + ") ung\u00fcltiges Element in Mehrfachauswahl: " + akey);
                throw new IllegalArgumentException("Feld " + this.getName() + " (" + this.getId() + ") ung\u00fcltiges Element in Mehrfachauswahl (s.catalina.out)");
            }
            tmpname = tmpname + node.getName() + ",";
        }
        tmpname = StringUtils.deleteLastChar(tmpname);
        SelectableItem item = new SelectableItem(selectedKeys, tmpname);
        item.setTemporary(true);
        this.addTempSelectionElement(item);
    }

    private String getMultiNames(String keys) {
        StringTokenizer st = new StringTokenizer(keys, "|");
        String tmpname = "";
        while (st.hasMoreTokens()) {
            String akey = st.nextToken();
            SelectableItemNode node = this.selectableItemsTree.getById(akey);
            if (node == null) {
                System.out.println("Feld " + this.getName() + " (" + this.getId() + ") ung\u00fcltiges Element in Mehrfachauswahl: " + akey);
                throw new IllegalArgumentException(this.getFeldInfo() + ") ung\u00fcltiges Element in Mehrfachauswahl (s.catalina.out)");
            }
            tmpname = tmpname + node.getName() + ", ";
        }
        tmpname = StringUtils.deleteLastChar(tmpname);
        tmpname = StringUtils.deleteLastChar(tmpname);
        return tmpname;
    }

    public String getSelectedKeyUnescaped() throws ParseException {
        return SqlStringUtils.unescapeString(this.getKeyEscaped(this.selectedKey));
    }

    private String getKeyEscaped(Object key) throws ParseException {
        String feldart;
        String result = "";
        if (key != null) {
            result = new String(key.toString());
        }
        if ((feldart = this.getArt() + "").equals("11")) {
            result = CryptUtils.encodeSHA(result + CryptUtils.geheimnis1);
        }
        if (this.getTyp().equals("char")) {
            result = ServletUtils.escapeCharFeld(result);
        }
        if (this.getTyp().equals("date") && result.length() > 0) {
            result = ServletUtils.escapeDateFeld(result);
        }
        if (this.getTyp().equals("timestamp") && result.length() > 0) {
            result = ServletUtils.escapeTimestampFeld(result);
        }
        if (this.getTyp().equals("time") && result.length() > 0) {
            result = ServletUtils.escapeTimeFeld(result);
        }
        if ((this.isOldOrganigrammArt() || this.isOrganigrammSichtArt()) && result.equals("")) {
            result = "null";
        }
        if (key != null && this.getTyp().equals("sql")) {
            result = key.toString().replace(';', '^');
        }
        if (result == null) {
            throw new IllegalStateException("null nicht erlaubt");
        }
        return result;
    }

    public void createTmpInformixTable() throws DBServletException, SQLException, ParseException {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Field cl = new Field((NamedIdObject)super.clone(), this.maskennummer, this.captionSet);
        cl.setNummer(this.getNummer());
        cl.setX(this.x);
        cl.setY(this.y);
        cl.mandantenID = this.mandantenID;
        cl.setButtonbreite(this.buttonbreite);
        cl.setFeldbreite(this.feldbreite);
        cl.setZeilenanzahl(this.zeilenanzahl);
        cl.setLaenge(this.laenge);
        cl.setObligatorisch(this.obligatorisch);
        cl.setArt(this.art);
        cl.setTyp(this.typ);
        try {
            cl.setRelation(this.relation);
            cl.setDefaultwertString(this.defaultwertString);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            throw new IllegalStateException("Problem cloning");
        }
        cl.setAttribut(this.attribut);
        try {
            cl.setSelectedKey(this.selectedKey);
            cl.setLocale(this.locale);
        }
        catch (Exception e) {
            throw new CloneNotSupportedException("Cloning of field " + this.getName() + " (" + this.getNummer() + ") failed: " + e);
        }
        cl.selectableItemsTree = (SelectableItemTree)this.selectableItemsTree.clone();
        cl.setCaptionShort(this.captionShort);
        cl.setCaptionLong(this.captionLong);
        cl.defaultValue = this.defaultValue;
        cl.isDynamic = this.isDynamic;
        cl.isInited = this.isInited;
        return cl;
    }

    public boolean isInited() {
        return this.isInited;
    }

    public void setInited(boolean isInited) {
        this.isInited = isInited;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean isUserSpecific) {
        this.isDynamic = isUserSpecific;
    }

    SelectableItem getDefaultValue() {
        return this.defaultValue;
    }

    String getParamAdaptedEscaped(String param) throws ParseException {
        String result = "";
        if ((param = this.paramAdaptCommaWildcard(param)).indexOf("|") > -1) {
            boolean isFirst = true;
            StringTokenizer st = new StringTokenizer(param, "|");
            while (st.hasMoreElements()) {
                String akey = st.nextToken();
                if (!isFirst) {
                    result = result + ",";
                } else {
                    isFirst = false;
                }
                result = result + this.getEscaped(akey);
            }
        }
        return result;
    }

    String getDefaultValueEscaped() throws ParseException {
        String result = "";
        if (this.defaultValue != null) {
            if (this.defaultValue.isTemporary() && this.defaultValue.getId().toString().indexOf("|") > -1) {
                boolean isFirst = true;
                StringTokenizer st = new StringTokenizer(this.defaultValue.getId().toString(), "|");
                while (st.hasMoreElements()) {
                    String akey = st.nextToken();
                    if (!isFirst) {
                        result = result + ",";
                    } else {
                        isFirst = false;
                    }
                    result = result + this.getEscaped(akey);
                }
            } else {
                result = this.getEscaped(this.defaultValue.getId().toString());
            }
        }
        return result;
    }

    void addTempSelectionElement(SelectableItem item) {
        item.setTemporary(true);
        this.selectableItemsTree.add(new SelectableItemNode(item));
    }

    public void addSelectionElement(SelectableItem item) {
        this.selectableItemsTree.add(new SelectableItemNode(item));
    }

    void removeTempSelectionElements() {
        this.selectableItemsTree.removeTempElements();
    }

    public String getSelectedKey() {
        return this.selectedKey;
    }

    public void setStand(Hashtable formular, HashMap map, FieldContainer individualFields, String neuerStand, SxUser user) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        if (neuerStand == null) {
            throw new IllegalArgumentException("Der Stand kann nicht auf null gesetzt werden - Feld " + this.getName() + " (" + this.getId() + ")");
        }
        neuerStand = neuerStand.replaceAll("'", "");
        neuerStand = neuerStand.replaceAll("\\(", "");
        neuerStand = neuerStand.replaceAll("\\)", "");
        neuerStand = neuerStand.replaceAll("date_val", "");
        neuerStand = neuerStand.replaceAll("date", "");
        if ((neuerStand = neuerStand.trim()).trim().equalsIgnoreCase("today") || neuerStand.trim().equalsIgnoreCase("<<today>>")) {
            neuerStand = DateUtils.getTodayString();
        }
        if (!DateUtils.isValidDate(neuerStand)) {
            throw new IllegalArgumentException("Konnte neuen Stand f\u00fcr Feld " + this.getName() + " (" + this.getId() + ") nicht setzen. '() date wurden entfernt, aber " + neuerStand + " ist kein g\u00fcltiges dd.mm.yyyy-Datum");
        }
        if (!this.isOldOrganigrammArt() && !this.isSicht()) {
            throw new IllegalStateException("Nur Felder mit Sichtenfunktionalit\u00e4t (Art 4,6,7,12) k\u00f6nnen den Stand \u00e4ndern");
        }
        this.initIfNeeded(formular, map, individualFields, user);
        this.sichtgruppe.setStand(formular, map, individualFields, neuerStand);
        this.selectableItemsTree = this.sichtgruppe.getSelectedSicht();
        this.updateSichtenInFormular(formular);
        if (!this.isHidden()) {
            user.getSelectionBuffer().setFieldStand(this.getName(), neuerStand);
        }
    }

    public void setSicht(Hashtable formular, HashMap map, FieldContainer individualFields, Integer sichttid, SxUser user) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, NoMainEntryException {
        if (!this.isSicht()) {
            throw new IllegalStateException("Nur Felder mit Sichtenfunktionalit\u00e4t (art=12) k\u00f6nnen die Sicht \u00e4ndern");
        }
        this.initIfNeeded(formular, map, individualFields, user);
        this.sichtgruppe.setSelectedSicht(sichttid);
        this.sichtgruppe.makeSureSelectedSichtIsOK(formular, map, individualFields);
        this.selectableItemsTree = this.sichtgruppe.getSelectedSicht();
        this.updateSichtenInFormular(formular);
        if (!this.isHidden()) {
            user.getSelectionBuffer().setFieldSicht(this.getName(), sichttid.toString());
        }
    }

    public String getSchleifenXml() throws InvalidKeyException, ParseException {
        String caption = this.getKeyEscaped(this.selectedKey);
        if (!caption.equals("") && this.selectableItemsTree.getRoot().getChildCount() > 0) {
            if (this.getArt() == 0 || this.getArt() == 19) {
                caption = "";
                if (this.selectedKey != null) {
                    caption = this.selectedKey.toString();
                }
            } else {
                if (!this.selectableItemsTree.containsItemWithId(this.selectedKey)) {
                    this.throwInvalidKey();
                }
                SelectableItemNode item = this.selectableItemsTree.getById(this.selectedKey);
                caption = item.getName();
            }
        }
        return "<schleifenelement><value><![CDATA[" + this.getSelectedKeyEscaped() + "]]></value><value_caption><![CDATA[" + SqlStringUtils.unescapeString(caption) + "]]></value_caption></schleifenelement>\n";
    }

    boolean isSpecialSelectionApplied() {
        return this.isSpecialSelectionApplied;
    }

    void setSpecialSelectionApplied(boolean isSpecialSelectionApplied) {
        this.isSpecialSelectionApplied = isSpecialSelectionApplied;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (key == null) {
            return null;
        }
        if (this.isSicht() || this.isOldOrganigrammArt()) {
            this.sichtgruppe.getSelectedSicht().updateLevelFromSelection();
        }
        SimpleScalar result = null;
        if (key.equalsIgnoreCase("sichtart")) {
            result = new SimpleScalar(this.sichtgruppe.getSelectedSicht().getArt());
        }
        if (key.equalsIgnoreCase("sichtname_intern")) {
            result = new SimpleScalar(this.sichtgruppe.getSelectedSicht().getName_intern());
        }
        if (key.equalsIgnoreCase("sichtname")) {
            result = new SimpleScalar(this.sichtgruppe.getSelectedSicht().getName());
        }
        if (key.equalsIgnoreCase("id") || key.equalsIgnoreCase("key")) {
            result = this.getId() == null ? new SimpleScalar(null) : new SimpleScalar(this.getId().toString());
        }
        if (key.equalsIgnoreCase("allNeededKeys") || key.equalsIgnoreCase("allNeededKeysList")) {
            if (this.isSicht() || this.isOldOrganigrammArt()) {
                result = new SimpleScalar(this.sichtgruppe.getSelectedSicht().getAllNeededKeysList());
            } else if (this.getArt() == 1) {
                result = new SimpleScalar(this.selectableItemsTree.getAllNeededKeysList());
            } else {
                throw new UnsupportedOperationException("wird nur von Feldart 1 und Sicht-Feldern unterst\u00fctzt");
            }
        }
        if (key.equalsIgnoreCase("allKeys")) {
            if (this.getArt() != 1) {
                throw new UnsupportedOperationException("wird nur von Art1-Feldern unterst\u00fctzt");
            }
            result = new SimpleScalar(this.selectableItemsTree.getAllKeys());
        }
        if (key.equalsIgnoreCase("keysToRoot")) {
            result = new SimpleScalar(this.sichtgruppe.getSelectedSicht().getOwnAndParentsKeyList());
        }
        if (key.equalsIgnoreCase("elementsMinEbene")) {
            result = new SimpleNumber(this.sichtgruppe.getSelectedSicht().getElementsMinEbene(1));
        }
        if (key.equalsIgnoreCase("elementsMaxEbene")) {
            result = new SimpleNumber(this.sichtgruppe.getSelectedSicht().getElementsMaxEbene(1));
        }
        if (key.equalsIgnoreCase("allElements")) {
            result = new SimpleSequence(this.selectableItemsTree.getAllElements());
        }
        if (key.equalsIgnoreCase("elements")) {
            result = new SimpleSequence(this.selectableItemsTree.getElements(1, false));
        }
        if (key.equalsIgnoreCase("breadthFirstElements")) {
            result = new SimpleSequence(this.selectableItemsTree.getElements(2, false));
        }
        if (key.equalsIgnoreCase("depthFirstElements")) {
            result = new SimpleSequence(this.selectableItemsTree.getElements(3, false));
        }
        if (key.equalsIgnoreCase("elements_incl_hidden")) {
            result = new SimpleSequence(this.selectableItemsTree.getElements(1, true));
        }
        if (key.equalsIgnoreCase("breadthFirstElements_incl_hidden")) {
            result = new SimpleSequence(this.selectableItemsTree.getElements(2, true));
        }
        if (key.equalsIgnoreCase("depthFirstElements_incl_hidden")) {
            result = new SimpleSequence(this.selectableItemsTree.getElements(3, true));
        }
        if (key.equalsIgnoreCase("selectedElementsOnly")) {
            LinkedList<Object> list = new LinkedList<Object>();
            for (int i = 0; i < this.selectableItemsTree.getSelectionCount(); ++i) {
                list.add(this.selectableItemsTree.getSelectionPaths()[i].getLastPathComponent());
            }
            result = new SimpleSequence(list);
        }
        if (key.equalsIgnoreCase("hasValue") || key.equalsIgnoreCase("hasSelection")) {
            result = this.selectableItemsTree.getSelectionCount() == 0 ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
        }
        if (key.equals("containsElements")) {
            result = this.selectableItemsTree.containsElements() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
        if (key.equalsIgnoreCase("selectionCount")) {
            result = new SimpleNumber((Number)new Integer(this.sichtgruppe.getSelectedSicht().getSelectionCount()));
        }
        if (key.equalsIgnoreCase("selectedKeyEscaped")) {
            result = new SimpleScalar(this.getSelectedKeyEscaped());
        }
        if (key.equalsIgnoreCase("selectedKey")) {
            String selkey = this.getSelectedKeyEscaped();
            if (selkey != null && selkey.startsWith("'")) {
                selkey = selkey.substring(1);
            }
            if (selkey != null && selkey.endsWith("'")) {
                selkey = selkey.substring(0, selkey.length() - 1);
            }
            result = new SimpleScalar(selkey);
        }
        if (key.equalsIgnoreCase("selectedItems")) {
            result = new SimpleSequence(this.selectableItemsTree.getSelectedItems());
        }
        if (key.equalsIgnoreCase("selectedItemsSortByKey")) {
            result = new SimpleSequence(this.selectableItemsTree.getSelectedItemsSortByKey());
        }
        if (key.equalsIgnoreCase("selectedItemsSortByName")) {
            result = new SimpleSequence(this.selectableItemsTree.getSelectedItemsSortByName());
        }
        if (key.equalsIgnoreCase("selectedItemsSortByStrukturInt")) {
            result = new SimpleSequence(this.selectableItemsTree.getSelectedItemsSortByStrukturInt());
        }
        if (key.equalsIgnoreCase("selectedItemsSortByStrukturStr")) {
            result = new SimpleSequence(this.selectableItemsTree.getSelectedItemsSortByStrukturStr());
        }
        return result;
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }

    public StringBuffer getJSON(String param) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException {
        if (!this.isInited()) {
            throw new IllegalStateException("JSON holen aber nicht initialisiert");
        }
        StringBuffer result = new StringBuffer();
        if (this.art == 0) {
            throw new IllegalArgumentException("F\u00fcr Feldart 0 kann kein JSON angefordert werden");
        }
        if (param == null) {
            throw new IllegalArgumentException("param darf nicht null sein");
        }
        result.append("(");
        if (param.startsWith("search:")) {
            this.addSearchJSON(param, result);
        } else {
            this.addRegularJSON(param, result);
        }
        result.append(")");
        return result;
    }

    private void addSearchJSON(String param, StringBuffer result) {
        boolean isFirstItem = true;
        String search = param.substring(7).toLowerCase();
        result.append("[");
        boolean dummy = true;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.selectableItemsTree.getModel().getRoot();
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.isHidden() || node.getName() == null || node.getName().toLowerCase().indexOf(search) <= -1) continue;
            if (!isFirstItem) {
                result.append(",");
            } else {
                isFirstItem = false;
            }
            result.append(node.toJSON(this.getDefaultValue().getId(), false));
        }
        result.append("]");
    }

    private void addRegularJSON(String param, StringBuffer result) {
        boolean isSingleRoot;
        if (!this.getSelectableItemsTree().containsItemWithId(param)) {
            throw new IllegalArgumentException("Im Feld " + this.getName() + " (" + this.getId() + ") gibt es kein Element " + param);
        }
        SelectableItemNode startnode = this.getSelectableItemsTree().getById(param);
        boolean bl = isSingleRoot = startnode.getChildCount() < 2;
        if (param.equals("xxxxxx-xxxxxx@")) {
            result.append("{");
            if (this.isOldOrganigrammArt() || this.isSicht()) {
                result.append(this.getSichtgruppe().getJSONInfo());
            } else {
                result.append("sichten:{count:0},zeilenanzahl:" + this.getZeilenanzahl());
            }
            result.append(",nodes:");
        }
        result.append("[");
        boolean isFirstItem = true;
        Enumeration<TreeNode> en = startnode.children();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.isHidden()) continue;
            if (!isFirstItem) {
                result.append(",");
            } else {
                isFirstItem = false;
            }
            result.append(node.toJSON(this.getDefaultValue().getId(), isSingleRoot));
        }
        result.append("]");
        if (param.equals("xxxxxx-xxxxxx@")) {
            result.append("}");
        }
    }

    public Object exec(List l) throws TemplateModelException {
        String function = l.get(0).toString();
        Object result = null;
        if (function.equalsIgnoreCase("getSubkeys")) {
            if (!this.isSicht() && this.getArt() != 1) {
                throw new IllegalArgumentException("getSubkeys,Schl\u00fcssel nur f\u00fcr Sichten und Feldart 1 implementiert");
            }
            if (this.isSicht()) {
                result = this.getSichtgruppe().getSelectedSicht().exec(l);
            } else {
                String surround = "";
                if (this.getTyp().equals("char")) {
                    surround = "'";
                }
                result = "(" + surround + l.get(1).toString() + surround + ")";
            }
        }
        if (function.equalsIgnoreCase("containselementwithid")) {
            String id = l.get(1).toString();
            result = this.selectableItemsTree.containsItemWithId(id) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
        return result;
    }

    public boolean isMehrfachAuswahl(String keystring) {
        boolean result = false;
        if (this.getZeilenanzahl() > 1 && keystring != null) {
            StringTokenizer st;
            if (keystring.indexOf(44) > -1) {
                result = true;
                st = new StringTokenizer(keystring, ",");
                while (st.hasMoreTokens()) {
                    if (this.selectableItemsTree.getById(st.nextToken()) != null) continue;
                    result = false;
                }
            }
            if (keystring.indexOf(124) > -1) {
                result = true;
                st = new StringTokenizer(keystring, "|");
                while (st.hasMoreTokens()) {
                    if (this.selectableItemsTree.getById(st.nextToken()) != null) continue;
                    result = false;
                }
            }
        }
        return result;
    }
}

