/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.GetOpts;
import de.memtext.util.StringUtils;
import de.superx.bin.fm.EtlStarter;
import de.superx.common.DBServletException;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.pentaho.di.core.KettleEnvironment;

public class KettleExecutor {
    private String mandantenID;
    private SxJob sxJob;
    private boolean isPostgres = true;
    private StringBuffer resultMessages = new StringBuffer("");
    private Map<String, String> jobParams = new HashMap<String, String>();

    public KettleExecutor(String mandantenID) {
        this.mandantenID = mandantenID;
        this.isPostgres = SxPools.get(mandantenID).getDatabaseAbbr().equals("PG");
    }

    public void setParams(Map<String, String> jobParams) {
        this.jobParams = jobParams;
    }

    public StringBuffer perform() throws IOException, SQLException, DBServletException {
        try {
            this.initSxJob();
            EtlStarter es = new EtlStarter(this.mandantenID);
            if (!this.isModusVorschau()) {
                this.check_sql("vor");
            }
            this.resultMessages.append(es.kettleCallEmbedded(this.mandantenID, this.sxJob.getFilepath(), this.jobParams, this.isPostgres));
            if (this.isModusVorschau()) {
                this.resultMessages.insert(0, this.getPreviewInfo());
            } else {
                this.check_sql("nach");
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this.resultMessages;
    }

    private boolean isModusVorschau() {
        return this.jobParams.containsKey("Modus") && this.jobParams.get("Modus") != null && this.jobParams.get("Modus").equals("3");
    }

    private StringBuilder getPreviewInfo() throws IOException {
        StringBuilder result = new StringBuilder();
        File loadjoblog = new File(new File(this.sxJob.getFilepath().replaceAll("file:", "")).getParentFile().getPath() + File.separator + "ladejob.log");
        if (loadjoblog.exists()) {
            String rawpreview = StringUtils.readFile(loadjoblog);
            StringTokenizer st = new StringTokenizer(rawpreview, "\n");
            result.append("Vorschau\n");
            String currentHeader = "";
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (line.indexOf("|") <= -1) continue;
                String firstpart = line.substring(0, line.indexOf("|"));
                if (!firstpart.equals(currentHeader)) {
                    result.append(firstpart + "\n");
                    currentHeader = firstpart;
                    result.append("-->" + line.substring(line.indexOf("|") + 1) + "\n");
                    continue;
                }
                result.append("-->" + StringUtils.replace(line, firstpart + "|", "") + "\n");
            }
        }
        return result;
    }

    private void check_sql(String pos) throws SQLException, DBServletException {
        if (this.sxJob.check_sql != null) {
            SuperX_el el = ServletUtils.execute_el("check_sql " + pos + " Durchf\u00fchrung von Ladejob " + this.sxJob.getCaption(), this.sxJob.check_sql, false, this.mandantenID);
            SxResultSet rs = el.getResultSet();
            for (SxResultRow row : rs) {
                Object erg = row.get(0);
                if (erg == null) continue;
                this.resultMessages.append("Pr\u00fcfselektion " + pos + " Durchf\u00fchrung von Ladejob " + this.sxJob.getCaption());
                this.resultMessages.append("\n" + erg.toString() + "\n");
            }
        }
    }

    private void initSxJob() throws SQLException, DBServletException {
        SxResultSet rs = ServletUtils.execute("Einlesen von SxJob)", "select caption,filepath,params,check_sql from sx_jobs where tid=" + this.jobParams.get("Job"), this.mandantenID);
        this.sxJob = new SxJob();
        for (SxResultRow row : rs) {
            this.sxJob.setCaption(row.get(0).toString());
            this.sxJob.setFilepath("file://" + SuperXManager.getModuleDir() + File.separator + row.get(1).toString());
            this.sxJob.setParams((String)row.get(2));
            this.sxJob.setCheck_sql((String)row.get(3));
        }
    }

    public static void main(String[] args) {
        String usage = "usage: -mandantenID:default -MODULE_PFAD:/home/superx/db/module -WEB_INF_PFAD:/home/superx/webserver/tomcat/webapps/superx/WEB-INF -job_uniquename:abc -path_to_uploadfile:/home/superx (optional)";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent("-mandantenID,-WEB_INF_PFAD,-MODULE_PFAD,-job_uniquename");
        if (isdrin != null) {
            System.err.println(usage);
            System.exit(1);
        }
        String mandantenID = GetOpts.getValue("-mandantenID");
        String job_uniquename = GetOpts.getValue("-job_uniquename");
        String webinfpfad = GetOpts.getValue("-WEB_INF_PFAD");
        if (webinfpfad != null && !webinfpfad.equals("")) {
            SuperXManager.setWEB_INFPfad(GetOpts.getValue("-WEB_INF_PFAD"));
        }
        SuperXManager.setModuleDir(GetOpts.getValue("-MODULE_PFAD"));
        String path_to_uploadfile = "";
        if (GetOpts.isPresent("-path_to_uploadfile") && !new File(path_to_uploadfile = GetOpts.getValue("-path_to_uploadfile")).exists()) {
            System.out.println("Fehler: Datei " + path_to_uploadfile + " nicht gefunden");
            System.exit(-1);
        }
        try {
            KettleEnvironment.init();
            SxPools.init();
            SxPools.get(mandantenID).init();
            SxPools.resetAllPools();
        }
        catch (Exception e) {
            System.out.println("Fehler beim Datenbankverbindungsaufbau " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            String jobtid = KettleExecutor.getJobTid(job_uniquename, mandantenID);
            KettleExecutor ke = new KettleExecutor(mandantenID);
            HashMap<String, String> jobParams = new HashMap<String, String>();
            jobParams.put("Job", jobtid);
            jobParams.put("PATH_TO_UPLOADFILE", path_to_uploadfile);
            ke.setParams(jobParams);
            ke.perform();
            System.out.println("Keine Fehler aufgefallen");
        }
        catch (Exception e) {
            System.out.println("Fehler bei Verarbeitung " + e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static String getJobTid(String job_uniquename, String mandantenID) throws SQLException, DBServletException {
        String tid = "";
        String sql = "select tid from sx_jobs where uniquename='" + job_uniquename + "'";
        SxResultSet rs = ServletUtils.execute("Suche tid f\u00fcr sx_job mit uniquename " + job_uniquename, sql, mandantenID);
        if (rs.size() == 0) {
            throw new RuntimeException("Kein sx_job mit uniquename " + job_uniquename + " gefunden");
        }
        if (rs.size() > 1) {
            throw new RuntimeException("Mehrere sx_jobs mit uniquename " + job_uniquename + " gefunden");
        }
        for (SxResultRow row : rs) {
            Object erg = row.get(0);
            if (erg == null) continue;
            tid = erg.toString();
        }
        return tid;
    }

    private class SxJob {
        private String filepath;
        private String params;
        private String check_sql;
        private String caption;

        private SxJob() {
        }

        public String getCaption() {
            return this.caption;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }

        public String getFilepath() {
            return this.filepath;
        }

        public void setFilepath(String filepath) {
            this.filepath = filepath;
        }

        public String getParams() {
            return this.params;
        }

        public void setParams(String params) {
            this.params = params;
        }

        public String getCheck_sql() {
            return this.check_sql;
        }

        public void setCheck_sql(String check_sql) {
            this.check_sql = check_sql;
        }
    }
}

