/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class WindowUtils {
    static Cursor waitCursor = new Cursor(3);
    static Cursor defaultCursor = new Cursor(0);

    private WindowUtils() {
    }

    public static void centerDown(Container c) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = c.getSize();
        if (windowSize.height > screenSize.height) {
            windowSize.height = screenSize.height;
        }
        if (windowSize.width > screenSize.width) {
            windowSize.width = screenSize.width;
        }
        c.setLocation((screenSize.width - windowSize.width) / 2, screenSize.height - windowSize.height);
    }

    public static void center(Container c) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = c.getSize();
        if (windowSize.height > screenSize.height) {
            windowSize.height = screenSize.height;
        }
        if (windowSize.width > screenSize.width) {
            windowSize.width = screenSize.width;
        }
        c.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
    }

    public static void setWaitCursor(JComponent comp, boolean on) {
        if (comp == null) {
            return;
        }
        Container toplevel = comp.getTopLevelAncestor();
        if (toplevel != null) {
            if (on) {
                toplevel.setCursor(waitCursor);
            } else {
                toplevel.setCursor(defaultCursor);
            }
        }
    }

    public static void setWaitCursor(Window comp, boolean isWait) {
        if (comp != null) {
            if (isWait) {
                comp.setCursor(new Cursor(3));
            } else {
                comp.setCursor(new Cursor(0));
            }
        }
    }

    public static void maxmizeWidth(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        w.setSize(new Dimension(screenSize.width, w.getHeight()));
    }

    public static void maxmizeHeight(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        w.setSize(new Dimension(w.getWidth(), screenSize.height - 50));
    }

    public static void maximize(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        w.setSize(new Dimension(screenSize.width, screenSize.height - 50));
        w.setLocation(0, 0);
    }

    public static void minimize(JFrame f) {
    }

    public static void setThreeQuarterPos(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        w.setSize(new Dimension((int)((double)screenSize.width * 0.75), (int)((double)screenSize.height * 0.75)));
        w.setLocation((int)((double)screenSize.width * 0.2), (int)((double)screenSize.height * 0.2));
    }
}

