/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.DateTimeFormatter;
import de.memtext.util.FileUtils;
import de.memtext.util.RawFormatter;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogUtils {
    private static ConsoleHandler rawConsoleHandler = new ConsoleHandler();

    private LogUtils() {
    }

    public static void initRaw(String loggername) {
        LogUtils.initRaw(Logger.getLogger(loggername));
    }

    public static void initRaw(Logger logger) {
        logger.addHandler(rawConsoleHandler);
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.WARNING);
    }

    public static void initRawFile(String loggername, String filename, int maxKB, int count, boolean append, boolean tryLckDeletion) throws SecurityException, IOException {
        if (tryLckDeletion) {
            if (count > 1) {
                throw new IllegalArgumentException("tryLckDeletion doesn't work for >1 file");
            }
            File f = new File(filename + ".lck");
            if (f.exists()) {
                f.delete();
            }
        }
        if (count > 1) {
            filename = FileUtils.addToEndOfFileName(filename, "%g");
        }
        FileHandler fh = new FileHandler(filename, maxKB * 1024, count, append);
        fh.setFormatter(new RawFormatter());
        Logger.getLogger(loggername).addHandler(fh);
        Logger.getLogger(loggername).setUseParentHandlers(false);
    }

    public static void initRawFileDateTime(String loggername, String filename, int maxKB, int count, boolean append, boolean tryLckDeletion) throws SecurityException, IOException {
        if (tryLckDeletion) {
            if (count > 1) {
                throw new IllegalArgumentException("tryLckDeletion doesn't work for >1 file");
            }
            File f = new File(filename + ".lck");
            if (f.exists()) {
                f.delete();
            }
        }
        if (count > 1) {
            filename = FileUtils.addToEndOfFileName(filename, "%g");
        }
        FileHandler fh = new FileHandler(filename, maxKB * 1024, count, append);
        fh.setFormatter(new DateTimeFormatter());
        Logger.getLogger(loggername).addHandler(fh);
        Logger.getLogger(loggername).setUseParentHandlers(false);
    }

    public static void close(String loggername) {
        Handler[] h = Logger.getLogger(loggername).getHandlers();
        for (int i = 0; i < h.length; ++i) {
            h[i].close();
        }
    }

    public static void main(String[] args) {
        try {
            LogUtils.initRawFile("superx_10000", "d:\\temp\\superx_10000.log", 2000, 1, true, true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Logger.getLogger("superx_10000").log(Level.SEVERE, "sql: \u00f6alskjf");
    }

    static {
        RawFormatter rf = new RawFormatter();
        rf.setTimeWanted(true);
        rawConsoleHandler.setFormatter(rf);
    }
}

