/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarUtils {
    private JarUtils() {
    }

    public static ZipEntry getEntry(String jarfile, String sourcefile) throws IOException {
        File jf = new File(jarfile);
        JarFile jf2 = new JarFile(jf);
        ZipEntry entry = jf2.getEntry(sourcefile);
        if (entry != null) {
            throw new IOException("Entry " + sourcefile + " not found in jar: " + jarfile);
        }
        return entry;
    }

    public static InputStream getInputStream(String url) throws IOException {
        int colonpos = url.indexOf(58);
        if (colonpos == -1) {
            throw new IllegalArgumentException("format must be xx.jar:file.zzz");
        }
        String jarfile = url.substring(0, colonpos);
        String sourcefile = url.substring(colonpos + 1);
        return JarUtils.getInputStream(jarfile, sourcefile);
    }

    public static InputStream getInputStream(String jarfile, String sourcefile) throws IOException {
        File jf = new File(jarfile);
        if (!jf.canRead()) {
            throw new IOException("Cannot read from file " + jarfile);
        }
        JarFile jf2 = new JarFile(jf);
        ZipEntry entry = jf2.getEntry(sourcefile);
        if (entry != null) {
            throw new IOException("Entry " + sourcefile + " not found in jar: " + jarfile);
        }
        return jf2.getInputStream(entry);
    }
}

