/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.baseobjects.coll;

import de.memtext.baseobjects.NamedIdObjectI;
import de.memtext.baseobjects.coll.NamedObjectCollection;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import java.io.Serializable;
import java.util.Collection;

public class NamedIdObjectCollection
extends NamedObjectCollection
implements Collection,
Serializable {
    private static final long serialVersionUID = 1L;

    public NamedIdObjectI getById(Object id) {
        NamedIdObjectI result = null;
        for (NamedIdObjectI test : this.collect) {
            if ((id != null || test.getId() != null) && (test.getId() == null || !test.getId().equals(id))) continue;
            result = test;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("No element with id " + id + " found!");
        }
        return result;
    }

    public String getIdsApostropheString() {
        StringBuffer result = new StringBuffer();
        for (NamedIdObjectI test : this.collect) {
            result.append("'" + test.getId() + "',");
        }
        StringUtils.deleteLastChar(result);
        return result.toString();
    }

    @Override
    public boolean containsItemWithName(String name) {
        boolean result = false;
        for (NamedIdObjectI test : this.collect) {
            if (!test.getName().equals(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean containsItemWithId(Object id) {
        boolean result = false;
        for (NamedIdObjectI test : this.collect) {
            if (!EqualsUtil.areEqual(test.getId(), id)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean consistsOfIds(Collection ids) {
        if (this.size() != ids.size()) {
            return false;
        }
        boolean result = true;
        for (Object id : ids) {
            try {
                NamedIdObjectI namedIdObjectI = this.getById(id);
            }
            catch (IllegalArgumentException e) {
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean add(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("can't add null value");
        }
        if (!(o instanceof NamedIdObjectI)) {
            throw new IllegalArgumentException("only named IdObjects allowed");
        }
        return this.collect.add(o);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(this.size() + " NamedIdObjects: ");
        for (NamedIdObjectI element : this) {
            result.append(element + " - ");
        }
        return result.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        NamedIdObjectCollection c = new NamedIdObjectCollection();
        c.addAll((Collection)this);
        return c;
    }
}

