/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.ContextExecutor;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapEncoder;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringSecurityLdapTemplate
extends LdapTemplate {
    private static final Log logger = LogFactory.getLog(SpringSecurityLdapTemplate.class);
    public static final String[] NO_ATTRS = new String[0];
    private SearchControls searchControls = new SearchControls();

    public SpringSecurityLdapTemplate(ContextSource contextSource) {
        Assert.notNull((Object)contextSource, (String)"ContextSource cannot be null");
        this.setContextSource(contextSource);
        this.searchControls.setSearchScope(2);
    }

    public boolean compare(final String dn, String attributeName, final Object value) {
        final String comparisonFilter = "(" + attributeName + "={0})";
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LdapCompareCallback
        implements ContextExecutor {
            LdapCompareCallback() {
            }

            public Object executeWithContext(DirContext ctx) throws NamingException {
                SearchControls ctls = new SearchControls();
                ctls.setReturningAttributes(NO_ATTRS);
                ctls.setSearchScope(0);
                NamingEnumeration<SearchResult> results = ctx.search(dn, comparisonFilter, new Object[]{value}, ctls);
                return results.hasMore();
            }
        }
        Boolean matches = (Boolean)this.executeReadOnly(new LdapCompareCallback());
        return matches;
    }

    public DirContextOperations retrieveEntry(final String dn, final String[] attributesToRetrieve) {
        return (DirContextOperations)this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                Attributes attrs = ctx.getAttributes(dn, attributesToRetrieve);
                return new DirContextAdapter(attrs, (Name)new DistinguishedName(dn), (Name)new DistinguishedName(ctx.getNameInNamespace()));
            }
        });
    }

    public Set<String> searchForSingleAttributeValues(String base, String filter, Object[] params, final String attributeName) {
        Object[] encodedParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            encodedParams[i] = LdapEncoder.filterEncode((String)params[i].toString());
        }
        String formattedFilter = MessageFormat.format(filter, encodedParams);
        logger.debug((Object)("Using filter: " + formattedFilter));
        final HashSet<String> set = new HashSet<String>();
        ContextMapper roleMapper = new ContextMapper(){

            public Object mapFromContext(Object ctx) {
                DirContextAdapter adapter = (DirContextAdapter)ctx;
                String[] values = adapter.getStringAttributes(attributeName);
                if (values == null || values.length == 0) {
                    logger.debug((Object)("No attribute value found for '" + attributeName + "'"));
                } else {
                    set.addAll(Arrays.asList(values));
                }
                return null;
            }
        };
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(this.searchControls.getSearchScope());
        ctls.setReturningAttributes(new String[]{attributeName});
        this.search(base, formattedFilter, ctls, roleMapper);
        return set;
    }

    public DirContextOperations searchForSingleEntry(final String base, final String filter, final Object[] params) {
        return (DirContextOperations)this.executeReadOnly(new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                DistinguishedName ctxBaseDn = new DistinguishedName(ctx.getNameInNamespace());
                NamingEnumeration<SearchResult> resultsEnum = ctx.search(base, filter, params, SpringSecurityLdapTemplate.this.searchControls);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Searching for entry in under DN '" + ctxBaseDn + "', base = '" + base + "', filter = '" + filter + "'"));
                }
                HashSet<DirContextAdapter> results = new HashSet<DirContextAdapter>();
                try {
                    while (resultsEnum.hasMore()) {
                        SearchResult searchResult = resultsEnum.next();
                        DistinguishedName dn = new DistinguishedName(searchResult.getName());
                        if (base.length() > 0) {
                            dn.prepend(new DistinguishedName(base));
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Found DN: " + dn));
                        }
                        results.add(new DirContextAdapter(searchResult.getAttributes(), (Name)dn, (Name)ctxBaseDn));
                    }
                }
                catch (PartialResultException e) {
                    logger.info((Object)"Ignoring PartialResultException");
                }
                if (results.size() == 0) {
                    throw new IncorrectResultSizeDataAccessException(1, 0);
                }
                if (results.size() > 1) {
                    throw new IncorrectResultSizeDataAccessException(1, results.size());
                }
                return results.toArray()[0];
            }
        });
    }

    public void setSearchControls(SearchControls searchControls) {
        this.searchControls = searchControls;
    }
}

