/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping.util;

import de.werum.sis.mapping.util.PointXY;

public class Triangle {
    public static final int ANKATHETE1 = 10;
    public static final int ANKATHETE2 = 20;
    public static final int HYPOTHENUSE = 30;
    protected PointXY pA_ = null;
    protected PointXY pB_ = null;
    protected PointXY pC_ = null;
    protected double a_ = 0.0;
    protected double b_ = 0.0;
    protected double c_ = 0.0;
    protected double A_ = 0.0;
    protected double U_ = 0.0;

    public Triangle(PointXY pA, PointXY pB, PointXY pC) {
        this.init(pA, pB, pC);
    }

    public Triangle() {
    }

    public void init(PointXY pA, PointXY pB, PointXY pC) {
        this.pA_ = pA;
        this.pB_ = pB;
        this.pC_ = pC;
        this.a_ = this.calcHypothenuse(this.pB_, this.pC_);
        this.b_ = this.calcHypothenuse(this.pC_, this.pA_);
        this.c_ = this.calcHypothenuse(this.pA_, this.pB_);
        this.U_ = this.a_ + this.b_ + this.c_;
    }

    protected double calcHypothenuse(PointXY pA, PointXY pB) {
        double kath1 = 0.0;
        double kath2 = 0.0;
        kath1 = pA.X - pB.X;
        kath2 = pA.Y - pB.Y;
        return this.getHypothenuse(kath1, kath2);
    }

    public double getA() {
        double S = this.U_ / 2.0;
        double helper = S * (S - this.a_) * (S - this.b_) * (S - this.c_);
        if (helper < 0.0) {
            return 0.0;
        }
        return Math.sqrt(helper);
    }

    public double getHypothenuse(double ankat1, double ankat2) {
        return this.calcPytagoras(30, 0.0, ankat1, ankat2);
    }

    public double ha() {
        return this.hside(this.a_);
    }

    public double hb() {
        return this.hside(this.b_);
    }

    public double hc() {
        return this.hside(this.c_);
    }

    protected double hside(double side) {
        return this.getA() * 2.0 / side;
    }

    protected double calcPytagoras(int calcwhat, double hypothenuse, double ankat1, double ankat2) {
        double k1 = -1.0;
        double k2 = -1.0;
        double h = -1.0;
        switch (calcwhat) {
            case 10: {
                k1 = Math.pow(ankat1, 2.0);
                h = Math.pow(hypothenuse, 2.0);
                if (h - k2 >= 0.0) {
                    k1 = Math.sqrt(h - k2);
                }
                return k1;
            }
            case 20: {
                k1 = Math.pow(ankat1, 2.0);
                h = Math.pow(hypothenuse, 2.0);
                if (h - k1 >= 0.0) {
                    k2 = Math.sqrt(h - k1);
                }
                return k2;
            }
            case 30: {
                k1 = Math.pow(ankat1, 2.0);
                k2 = Math.pow(ankat2, 2.0);
                h = Math.sqrt(k1 + k2);
                return h;
            }
        }
        return 0.0;
    }

    public String toString() {
        return "a:" + this.a_ + " b:" + this.b_ + " c:" + this.c_ + " Pa:" + this.pA_.toString() + " Pb:" + this.pB_.toString() + " Pc:" + this.pC_.toString();
    }
}

