/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.csv.filter;

import de.werum.sis.csv.filter.FilterConstants;
import de.werum.sis.csv.filter.FilterField;
import de.werum.sis.csv.filter.FilterFieldGroup;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class FilterStructure
implements FilterConstants {
    private String name = null;
    private List<Object> fields = new LinkedList<Object>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name != null && name.length() > 0 ? name.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').replace('(', ' ').replace(')', ' ') : name;
    }

    public List<Object> getFields() {
        return this.fields;
    }

    public FilterField getField(String name) {
        FilterField result = null;
        int startOfFieldName = name.lastIndexOf(46);
        if (startOfFieldName > 0) {
            FilterFieldGroup fieldGroup = this.getFieldGroup(name.substring(0, startOfFieldName));
            result = fieldGroup.getField(name.substring(startOfFieldName + 1));
        } else {
            for (Object object : this.fields) {
                FilterField field;
                if (!(object instanceof FilterField) || !(field = (FilterField)object).getName().equals(name)) continue;
                result = field;
                break;
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Das Feld <" + name + "> existiert nicht.");
        }
        return result;
    }

    public FilterFieldGroup getFieldGroup(String name) {
        FilterFieldGroup result = null;
        int startOfFieldGroupName = name.lastIndexOf(46);
        if (startOfFieldGroupName > 0) {
            FilterFieldGroup fieldGroup = this.getFieldGroup(name.substring(0, startOfFieldGroupName));
            result = fieldGroup.getFieldGroup(name.substring(startOfFieldGroupName + 1));
        } else {
            for (Object object : this.fields) {
                FilterFieldGroup fieldGroup;
                if (!(object instanceof FilterFieldGroup) || !(fieldGroup = (FilterFieldGroup)object).getName().equals(name)) continue;
                result = fieldGroup;
                break;
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Die Feldgruppe <" + name + "> existiert nicht.");
        }
        return result;
    }

    public boolean hasFieldGroups() {
        boolean result = false;
        for (Object object : this.fields) {
            if (!(object instanceof FilterFieldGroup)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Integer getPosition() {
        Integer result = null;
        for (Object object : this.fields) {
            FilterFieldGroup fieldGroup;
            if (object instanceof FilterField) {
                FilterField field = (FilterField)object;
                if (field.getPosition() == null) continue;
                if (result == null) {
                    result = field.getPosition();
                    continue;
                }
                if (field.getPosition() >= result) continue;
                result = field.getPosition();
                continue;
            }
            if (!(object instanceof FilterFieldGroup) || (fieldGroup = (FilterFieldGroup)object).getPosition() == null) continue;
            if (result == null) {
                result = fieldGroup.getPosition();
                continue;
            }
            if (fieldGroup.getPosition() >= result) continue;
            result = fieldGroup.getPosition();
        }
        return result;
    }

    public void updateFrom(FilterStructure structure) {
        for (Object object : this.fields) {
            FilterFieldGroup anotherFieldGroup;
            if (object instanceof FilterField) {
                FilterField anotherField;
                FilterField field = (FilterField)object;
                try {
                    anotherField = structure.getField(field.getName());
                }
                catch (Exception e) {
                    anotherField = null;
                }
                if (anotherField == null) continue;
                field.setPosition(anotherField.getPosition());
                field.setLength(anotherField.getLength());
                field.setDefaultValue(anotherField.getDefaultValue());
                continue;
            }
            if (!(object instanceof FilterFieldGroup)) continue;
            FilterFieldGroup fieldGroup = (FilterFieldGroup)object;
            try {
                anotherFieldGroup = structure.getFieldGroup(fieldGroup.getName());
            }
            catch (Exception e) {
                anotherFieldGroup = null;
            }
            if (anotherFieldGroup == null) continue;
            fieldGroup.setNumber(anotherFieldGroup.getNumber());
            fieldGroup.updateFrom(anotherFieldGroup);
        }
        for (int i = 0; i < structure.getFields().size(); ++i) {
            int index;
            Object anotherObject = structure.getFields().get(i);
            Comparable<Object> object = null;
            try {
                if (anotherObject instanceof FilterField) {
                    object = this.getField(((FilterField)anotherObject).getName());
                } else if (anotherObject instanceof FilterFieldGroup) {
                    object = this.getFieldGroup(((FilterFieldGroup)anotherObject).getName());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (object == null || i == (index = this.getFields().indexOf(object)) || i >= this.getFields().size()) continue;
            this.getFields().remove(object);
            this.getFields().add(i, object);
        }
    }

    public void sortByPosition() {
        Object[] objects = this.getFields().toArray();
        Arrays.sort(objects);
        this.getFields().clear();
        for (Object object : objects) {
            this.getFields().add(object);
        }
    }

    protected void copyInto(FilterStructure copy) {
        copy.setName(this.getName());
        for (Object object : this.fields) {
            if (object instanceof FilterField) {
                copy.getFields().add(((FilterField)object).getCopy());
                continue;
            }
            if (!(object instanceof FilterFieldGroup)) continue;
            copy.getFields().add(((FilterFieldGroup)object).getCopy());
        }
    }

    protected int computePositions(int startPosition, int type, boolean modifyOnly) {
        int position = startPosition;
        for (Object object : this.fields) {
            FilterFieldGroup fieldGroup;
            if (object instanceof FilterField) {
                FilterField field = (FilterField)object;
                if (type == 2) {
                    if (field.getLength() != null && field.getLength() > 0) {
                        field.setPosition(new Integer(position));
                        position += field.getLength().intValue();
                        continue;
                    }
                    field.setPosition(null);
                    continue;
                }
                if (modifyOnly) {
                    if (field.getPosition() == null || field.getPosition() <= 0) continue;
                    field.setPosition(new Integer(position));
                    ++position;
                    continue;
                }
                field.setPosition(new Integer(position));
                ++position;
                continue;
            }
            if (!(object instanceof FilterFieldGroup) || (fieldGroup = (FilterFieldGroup)object).getNumber() <= 0) continue;
            int firstPosition = position;
            position = fieldGroup.computePositions(position, type, modifyOnly);
            position = firstPosition + (position - firstPosition) * fieldGroup.getNumber();
        }
        return position;
    }
}

