/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.CryptProperties;
import de.werum.sis.crypt.RSACipherExtractor;
import de.werum.sis.sql.SQLGate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class CryptKeyPair {
    private CryptProperties properties;
    private RSACipherExtractor cipherExtractorRSA;
    String keyRef = null;
    PrivateKey privateKey = null;
    PublicKey publicKey = null;

    protected CryptKeyPair(CryptProperties properties) {
        this.properties = properties;
        this.cipherExtractorRSA = new RSACipherExtractor(properties);
    }

    public CryptKeyPair(CryptProperties properties, String _keyRef, boolean init_public, boolean init_private) throws GeneralSecurityException, IOException {
        this.properties = properties;
        this.cipherExtractorRSA = new RSACipherExtractor(properties);
        if (properties.getKeyData() != null) {
            this.keyRef = properties.getKeyData().getKeyRef();
            this.getKeysFromProperties(init_public, init_private);
        } else {
            this.keyRef = _keyRef;
            if (this.keyRef == null && properties.getIsRandomKeyRepository().equals("true")) {
                this.getKeysFromRandomRepository(init_public, init_private);
            } else {
                if (this.keyRef == null) {
                    this.keyRef = this.getKeyRef(init_public, init_private);
                }
                if (this.keyRef == null) {
                    throw new FileNotFoundException("CryptKeyPair: Es konnten keine Schluesseldateien <" + properties.getKeyRepositoryUrl() + properties.getKeyStart() + "*(" + properties.getKeyEndPublic() + "|" + properties.getKeyEndPrivate() + ")> gefunden werden.");
                }
                if (properties.getKeyRepositoryUrl().startsWith("jdbc")) {
                    this.getKeysFromDB(init_public, init_private);
                } else {
                    this.getKeysFromFile(init_public, init_private);
                }
            }
        }
    }

    private void getKeysFromRandomRepository(boolean init_public, boolean init_private) throws GeneralSecurityException, IOException {
        InputStream fd_r;
        URLConnection conn;
        URL url;
        if (init_public) {
            String urlStringPublic = this.properties.getKeyRepositoryUrl();
            try {
                url = new URL(urlStringPublic);
                conn = null;
                if (this.properties.getIsSSLRepository().equalsIgnoreCase("true")) {
                    conn = (HttpsURLConnection)url.openConnection();
                    ((HttpsURLConnection)conn).setSSLSocketFactory(this.properties.getSslContext().getSocketFactory());
                    ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                        public boolean verify(String arg0, SSLSession arg1) {
                            return true;
                        }
                    });
                } else {
                    conn = url.openConnection();
                }
                fd_r = conn.getInputStream();
                this.keyRef = conn.getHeaderField("keyid");
                this.publicKey = (PublicKey)this.cipherExtractorRSA.extractKey(fd_r);
                fd_r.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new FileNotFoundException("CryptKeyPair: Die oeffentliche Schluesseldatei <" + urlStringPublic + "> konnte nicht geladen werden.");
            }
        }
        if (init_private) {
            String urlStringPrivate = this.properties.getKeyRepositoryUrl();
            try {
                url = new URL(urlStringPrivate);
                conn = null;
                if (this.properties.getIsSSLRepository().equalsIgnoreCase("true")) {
                    conn = (HttpsURLConnection)url.openConnection();
                    ((HttpsURLConnection)conn).setSSLSocketFactory(this.properties.getSslContext().getSocketFactory());
                    ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                        public boolean verify(String arg0, SSLSession arg1) {
                            return true;
                        }
                    });
                } else {
                    conn = url.openConnection();
                }
                fd_r = conn.getInputStream();
                this.keyRef = conn.getHeaderField("keyid");
                this.privateKey = (PrivateKey)this.cipherExtractorRSA.extractKey(fd_r);
                fd_r.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new FileNotFoundException("CryptKeyPair: Die private Schluesseldatei <" + urlStringPrivate + "> konnte nicht geladen werden.");
            }
        }
    }

    private void getKeysFromFile(boolean init_public, boolean init_private) throws GeneralSecurityException, IOException {
        InputStream fd_r;
        URLConnection conn;
        URL url;
        if (init_public) {
            String urlStringPublic = this.properties.getKeyRepositoryUrl() + this.properties.getKeyStart() + this.keyRef + this.properties.getKeyEndPublic();
            try {
                url = new URL(urlStringPublic);
                conn = null;
                if (this.properties.getIsSSLRepository().equalsIgnoreCase("true")) {
                    conn = (HttpsURLConnection)url.openConnection();
                    ((HttpsURLConnection)conn).setSSLSocketFactory(this.properties.getSslContext().getSocketFactory());
                    ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                        public boolean verify(String arg0, SSLSession arg1) {
                            return true;
                        }
                    });
                } else {
                    conn = url.openConnection();
                }
                fd_r = conn.getInputStream();
                this.publicKey = (PublicKey)this.cipherExtractorRSA.extractKey(fd_r);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new FileNotFoundException("CryptKeyPair: Die oeffentliche Schluesseldatei <" + urlStringPublic + "> konnte nicht geladen werden.");
            }
        }
        if (init_private) {
            String urlStringPrivate = this.properties.getKeyRepositoryUrl() + this.properties.getKeyStart() + this.keyRef + this.properties.getKeyEndPrivate();
            try {
                url = new URL(urlStringPrivate);
                conn = null;
                if (this.properties.getIsSSLRepository().equalsIgnoreCase("true")) {
                    conn = (HttpsURLConnection)url.openConnection();
                    ((HttpsURLConnection)conn).setSSLSocketFactory(this.properties.getSslContext().getSocketFactory());
                    ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                        public boolean verify(String arg0, SSLSession arg1) {
                            return true;
                        }
                    });
                } else {
                    conn = url.openConnection();
                }
                fd_r = conn.getInputStream();
                this.privateKey = (PrivateKey)this.cipherExtractorRSA.extractKey(fd_r);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new FileNotFoundException("CryptKeyPair: Die private Schluesseldatei <" + urlStringPrivate + "> konnte nicht geladen werden.");
            }
        }
    }

    private void getKeysFromDB(boolean init_public, boolean init_private) throws GeneralSecurityException, IOException {
        try {
            ResultSet resultSet;
            SQLGate sql = new SQLGate(this.properties.getDbDriver(), this.properties.getKeyRepositoryUrl(), this.properties.getDbUser(), this.properties.getDbPasswort());
            Connection connection = sql.getConnection();
            Statement statement = sql.createStatement(connection);
            String query = "SELECT ";
            if (init_public) {
                query = query + this.properties.getDbColumnPublic();
                if (init_private) {
                    query = query + ", ";
                }
            }
            if (init_private) {
                query = query + this.properties.getDbColumnPrivate();
            }
            if ((resultSet = statement.executeQuery(query = query + " FROM " + this.properties.getDbTableName() + " WHERE " + this.properties.getDbColumnRef() + " = '" + this.keyRef + "'")).next()) {
                if (init_public) {
                    this.publicKey = (PublicKey)this.cipherExtractorRSA.extractKey(resultSet.getBinaryStream(this.properties.getDbColumnPublic()));
                }
                if (init_private) {
                    this.privateKey = (PrivateKey)this.cipherExtractorRSA.extractKey(resultSet.getBinaryStream(this.properties.getDbColumnPrivate()));
                }
            } else {
                throw new IOException("Der Eintrag mit Schl\u00fcsselreferenz + \"" + this.keyRef + "\" konnte nicht gefunden werden!");
            }
            statement.close();
            sql.closeConnection();
        }
        catch (SQLException e) {
            throw new IOException("Fehler beim Lesen des Schl\u00fcssels aus der Datenbank: " + e.getMessage());
        }
    }

    private void getKeysFromProperties(boolean init_public, boolean init_private) throws GeneralSecurityException, IOException {
        if (init_public) {
            this.publicKey = (PublicKey)this.cipherExtractorRSA.extractKey(new ByteArrayInputStream(this.properties.getKeyData().getPubKey()));
        }
        if (init_private) {
            this.privateKey = (PrivateKey)this.cipherExtractorRSA.extractKey(new ByteArrayInputStream(this.properties.getKeyData().getPrvKey()));
        }
    }

    public Cipher publicCipher(boolean encrypt) throws GeneralSecurityException, IOException {
        Cipher rsa = null;
        if (this.publicKey != null) {
            rsa = Cipher.getInstance(this.properties.getAsymetricAlgorithm(this.properties.getEncryptPackagingUserId()) + "/" + this.properties.getAsymetricOpMode(this.properties.getEncryptPackagingUserId()) + "/" + this.properties.getAsymetricPadding(this.properties.getEncryptPackagingUserId()), this.properties.getProviderName(this.properties.getEncryptPackagingUserId()));
            SecureRandom secRand = this.properties.getSecureRandom();
            if (secRand != null) {
                rsa.init(encrypt ? 1 : 2, (Key)this.publicKey, secRand);
            } else {
                rsa.init(encrypt ? 1 : 2, this.publicKey);
            }
        } else {
            throw new GeneralSecurityException("CryptKeyPair: oeffentlicher Schluessel <" + this.keyRef + "> nicht initialisiert");
        }
        rsa.init(encrypt ? 1 : 2, this.publicKey);
        return rsa;
    }

    public Cipher privateCipher(boolean encrypt) throws GeneralSecurityException, IOException {
        Cipher rsa = null;
        if (this.privateKey != null) {
            rsa = Cipher.getInstance(this.properties.getAsymetricAlgorithm(this.properties.getEncryptPackagingUserId()) + "/" + this.properties.getAsymetricOpMode(this.properties.getEncryptPackagingUserId()) + "/" + this.properties.getAsymetricPadding(this.properties.getEncryptPackagingUserId()), this.properties.getProviderName(this.properties.getEncryptPackagingUserId()));
            SecureRandom secRand = this.properties.getSecureRandom();
            if (secRand != null) {
                rsa.init(encrypt ? 1 : 2, (Key)this.privateKey, secRand);
            } else {
                rsa.init(encrypt ? 1 : 2, this.privateKey);
            }
        } else {
            throw new GeneralSecurityException("CryptKeyPair: privater Schluessel <" + this.keyRef + "> nicht initialisiert");
        }
        return rsa;
    }

    private String getKeyRef(boolean load_public, boolean load_private) throws IOException {
        String ergKeyRef = null;
        try {
            URL url = new URL(this.properties.getKeyRepositoryUrl());
            url.openConnection();
            File archiv_dir = new File(url.getFile());
            if (archiv_dir.isDirectory()) {
                Object[] listing = null;
                if (load_public && load_private) {
                    listing = archiv_dir.list(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            try {
                                URL url = new URL(CryptKeyPair.this.properties.getKeyRepositoryUrl() + CryptKeyPair.this.properties.getKeyStart() + name.substring(1, 8) + CryptKeyPair.this.properties.getKeyEndPrivate());
                                url.openConnection();
                                return name != null && name.startsWith(CryptKeyPair.this.properties.getKeyStart()) && name.endsWith(CryptKeyPair.this.properties.getKeyEndPublic()) && name.length() == 12 && new File(url.getFile()).isFile();
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                    });
                } else if (load_public) {
                    listing = archiv_dir.list(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name != null && name.startsWith(CryptKeyPair.this.properties.getKeyStart()) && name.endsWith(CryptKeyPair.this.properties.getKeyEndPublic()) && name.length() == 12;
                        }
                    });
                } else if (load_private) {
                    listing = archiv_dir.list(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name != null && name.startsWith(CryptKeyPair.this.properties.getKeyStart()) && name.endsWith(CryptKeyPair.this.properties.getKeyEndPrivate()) && name.length() == 12;
                        }
                    });
                }
                if (listing.length > 0) {
                    Arrays.sort(listing);
                    ergKeyRef = ((String)listing[0]).substring(1, 8);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return ergKeyRef;
    }

    public String getKeyRef() {
        return this.keyRef;
    }
}

