/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.parser.AuspraegungsgruppeParser;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.statspez.sdf.generator.parser.TypesParser;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.Reference;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import java.text.NumberFormat;
import java.util.Locale;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ValueSpaceParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private AuspraegungsgruppeParser auspraegungsgruppeParser;
    private MetaSDFMerkmal merkmal;
    private StringBuffer rangeSeries;
    private String classificationReference;
    private boolean externalClassificationReference;
    private String pattern;
    private String value;
    private String minInclusiv;
    private String minExclusiv;
    private String maxInclusiv;
    private String maxExclusiv;
    private String step;

    public ValueSpaceParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.auspraegungsgruppeParser = new AuspraegungsgruppeParser(this, resolver);
        this.parserChain.addParser((SubParser)this.auspraegungsgruppeParser);
        this.merkmal = null;
        this.rangeSeries = null;
        this.classificationReference = null;
        this.externalClassificationReference = false;
        this.pattern = null;
        this.value = null;
        this.minInclusiv = null;
        this.minExclusiv = null;
        this.maxInclusiv = null;
        this.maxExclusiv = null;
        this.step = null;
    }

    public void setMerkmal(MetaSDFMerkmal merkmal) {
        this.merkmal = merkmal;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("classificationReference".equalsIgnoreCase(localName)) {
            String internal = atts.getValue("internal");
            if (internal == null) {
                throw new MetaParseException("Fuer die Referenz der Auspraegungsgruppe ist das Attribut internal nicht definiert!");
            }
            if (TypesParser.parseInternal(internal)) {
                String name = atts.getValue("classification-name");
                String id = atts.getValue("classification-id");
                if (id == null) {
                    throw new MetaParseException("Fuer die Referenz der Auspraegungsgruppe ist keine ID definiert!");
                }
                if ((id = SDFTags.dekodiereXMLName(id)).indexOf("____") > 0) {
                    name = id;
                }
                if (name == null) {
                    throw new MetaParseException("Fuer die Referenz der Auspraegungsgruppe ist kein Name definiert!");
                }
                name = SDFTags.dekodiereXMLName(name);
                this.merkmal.setWertTyp((short)4);
                this.classificationReference = name;
                this.resolver().registerForResolve(new Reference((MetaElementInterface)this.merkmal, "CLASSIFICATION", name));
            } else {
                this.externalClassificationReference = true;
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if (!"enumeration".equalsIgnoreCase(localName)) {
            if ("enumElement".equalsIgnoreCase(localName)) {
                this.addRangeIfExists();
            } else if ("value".equalsIgnoreCase(localName)) {
                this.value = this.replaceDecimalCommaIfNessesary(chars);
            } else if ("minInclusive".equalsIgnoreCase(localName)) {
                this.minInclusiv = this.replaceDecimalCommaIfNessesary(chars);
            } else if ("minExclusive".equalsIgnoreCase(localName)) {
                this.minExclusiv = this.replaceDecimalCommaIfNessesary(chars);
            } else if ("maxInclusive".equalsIgnoreCase(localName)) {
                this.maxInclusiv = this.replaceDecimalCommaIfNessesary(chars);
            } else if ("maxExclusive".equalsIgnoreCase(localName)) {
                this.maxExclusiv = this.replaceDecimalCommaIfNessesary(chars);
            } else if ("increment".equalsIgnoreCase(localName)) {
                this.step = this.replaceDecimalCommaIfNessesary(chars);
            } else if ("classificationReference".equalsIgnoreCase(localName)) {
                if (this.externalClassificationReference) {
                    if (chars == null || chars.length() == 0) {
                        throw new MetaParseException("Fuer die Referenz der Auspraegungsgruppe ist keine ID definiert!");
                    }
                    this.classificationReference = chars;
                }
            } else if ("pattern".equalsIgnoreCase(localName)) {
                this.pattern = chars;
            } else {
                handled = false;
            }
        }
        return handled;
    }

    private String replaceDecimalCommaIfNessesary(String chars) {
        String charsReplaced = this.merkmal.getTyp() == 4 || this.merkmal.getTyp() == 5 || this.merkmal.getTyp() == 6 || this.merkmal.getTyp() == 7 ? chars.replaceAll(",", ".") : chars;
        return charsReplaced;
    }

    private void addRangeIfExists() throws SAXException {
        if (this.value != null) {
            if (this.value.length() > 0) {
                if (this.merkmal.getTyp() == 1) {
                    this.rangeSeries.append("'");
                }
                this.rangeSeries.append(this.value);
                if (this.merkmal.getTyp() == 1) {
                    this.rangeSeries.append("'");
                }
            } else {
                this.rangeSeries.append("LEER");
            }
        } else if (this.minInclusiv != null && this.minInclusiv.length() > 0 || this.minExclusiv != null && this.minExclusiv.length() > 0 || this.maxInclusiv != null && this.maxInclusiv.length() > 0 || this.maxExclusiv != null && this.maxExclusiv.length() > 0) {
            if (this.step != null && this.step.length() > 0) {
                try {
                    double a;
                    NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
                    double s = Double.parseDouble(this.step);
                    if (this.minInclusiv != null && this.minInclusiv.length() > 0) {
                        this.rangeSeries.append(this.minInclusiv);
                        this.rangeSeries.append(", ");
                        a = Double.parseDouble(this.minInclusiv);
                        if (this.merkmal.getTyp() == 5) {
                            this.rangeSeries.append((int)(a + s));
                        } else {
                            this.rangeSeries.append(numberFormat.format(a + s));
                        }
                    } else {
                        a = Double.parseDouble(this.minExclusiv);
                        if (this.merkmal.getTyp() == 5) {
                            this.rangeSeries.append((int)(a + s));
                            this.rangeSeries.append(", ");
                            this.rangeSeries.append((int)(a + s + s));
                        } else {
                            this.rangeSeries.append(numberFormat.format(a + s));
                            this.rangeSeries.append(", ");
                            this.rangeSeries.append(numberFormat.format(a + s + s));
                        }
                    }
                    this.rangeSeries.append("..");
                    if (this.maxInclusiv != null && this.maxInclusiv.length() > 0) {
                        this.rangeSeries.append(this.maxInclusiv);
                    }
                    double b = Double.parseDouble(this.maxExclusiv);
                    if (this.merkmal.getTyp() == 5) {
                        this.rangeSeries.append((int)(b - s));
                    }
                    this.rangeSeries.append(numberFormat.format(b - s));
                }
                catch (Exception e) {
                    throw new MetaParseException("Fehler bei der Interpretation der Schrittweite.", e);
                }
            } else {
                if (this.minInclusiv != null && this.minInclusiv.length() > 0) {
                    this.rangeSeries.append(this.minInclusiv);
                    this.rangeSeries.append("+");
                } else {
                    this.rangeSeries.append(this.minExclusiv);
                    this.rangeSeries.append("-");
                }
                if (this.maxInclusiv != null && this.maxInclusiv.length() > 0) {
                    this.rangeSeries.append("+");
                    this.rangeSeries.append(this.maxInclusiv);
                } else {
                    this.rangeSeries.append("-");
                    this.rangeSeries.append(this.maxExclusiv);
                }
            }
        }
        this.value = null;
        this.minInclusiv = null;
        this.minExclusiv = null;
        this.maxInclusiv = null;
        this.maxExclusiv = null;
        this.step = null;
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("valueSpace".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("valueSpace".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.rangeSeries = new StringBuffer();
            this.classificationReference = null;
            this.externalClassificationReference = false;
            this.pattern = null;
            this.enable();
        } else if ("enumeration".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("enumElement".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            if (this.rangeSeries.length() > 0) {
                this.rangeSeries.append(", ");
            }
        } else if ("value".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("minInclusive".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("minExclusive".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("maxInclusive".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("maxExclusive".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("increment".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("classificationReference".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("pattern".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw MetaParseException.unknownTagException((String)localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("valueSpace".equalsIgnoreCase(localName)) {
            this.addRangeIfExists();
            if (this.rangeSeries.length() > 0) {
                this.merkmal.setWertebereich(this.rangeSeries.toString());
                this.merkmal.setWertTyp((short)1);
            } else if (this.externalClassificationReference) {
                this.merkmal.setWertebereich(this.classificationReference);
                this.merkmal.setWertTyp((short)3);
            } else if (this.pattern != null && this.pattern.length() > 0) {
                this.merkmal.setWertebereich(this.pattern);
                this.merkmal.setWertTyp((short)2);
            }
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName) && !this.parserChain.endElement(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return this.merkmal;
    }

    public String getClassificationReferece() {
        return this.classificationReference;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectAvailable(SubParser aParser) {
        MetaAuspraegungsgruppe classification = (MetaAuspraegungsgruppe)aParser.object();
        this.classificationReference = classification.getName();
        this.merkmal.setKlasseWertebereich(classification);
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

