/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.parser.ContextParser;
import de.statspez.sdf.generator.parser.LegalBasisParser;
import de.statspez.sdf.generator.parser.ObservationUnitParser;
import de.statspez.sdf.generator.parser.ParserUtil;
import de.statspez.sdf.generator.parser.PeriodicityParser;
import de.statspez.sdf.generator.parser.ReferenceAreaParser;
import de.statspez.sdf.generator.parser.ReferencePeriodParser;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SurveyParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private ReferencePeriodParser referencePeriodParser;
    private ReferenceAreaParser referenceAreaParser;
    private ObservationUnitParser observationUnitParser;
    private PeriodicityParser periodicityParser;
    private LegalBasisParser legalBasisParser;
    private ContextParser.ContextDataReceiver contextDataReceiver;

    public SurveyParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.referencePeriodParser = new ReferencePeriodParser(this, resolver);
        this.parserChain.addParser((SubParser)this.referencePeriodParser);
        this.referenceAreaParser = new ReferenceAreaParser(this, resolver);
        this.parserChain.addParser((SubParser)this.referenceAreaParser);
        this.observationUnitParser = new ObservationUnitParser(this, resolver);
        this.parserChain.addParser((SubParser)this.observationUnitParser);
        this.periodicityParser = new PeriodicityParser(this, resolver);
        this.parserChain.addParser((SubParser)this.periodicityParser);
        this.legalBasisParser = new LegalBasisParser(this, resolver);
        this.parserChain.addParser((SubParser)this.legalBasisParser);
        this.contextDataReceiver = null;
    }

    public void setContextDataReceiver(ContextParser.ContextDataReceiver contextDataReceiver) {
        this.contextDataReceiver = contextDataReceiver;
        this.referencePeriodParser.setContextDataReceiver(contextDataReceiver);
        this.referenceAreaParser.setContextDataReceiver(contextDataReceiver);
        this.observationUnitParser.setContextDataReceiver(contextDataReceiver);
        this.periodicityParser.setContextDataReceiver(contextDataReceiver);
        this.legalBasisParser.setContextDataReceiver(contextDataReceiver);
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("surveyID".equalsIgnoreCase(localName)) {
            this.contextDataReceiver.setErhebungsID(chars);
        } else if ("foreignSurveyID".equalsIgnoreCase(localName)) {
            this.contextDataReceiver.setEvasNummer(chars);
        } else if ("surveyName".equalsIgnoreCase(localName)) {
            this.contextDataReceiver.setName(ParserUtil.removeWhitespaces(chars));
        } else if ("surveyLabel".equalsIgnoreCase(localName)) {
            this.contextDataReceiver.setAnzeigeName(ParserUtil.removeWhitespaces(chars));
        } else if ("surveyVersion".equalsIgnoreCase(localName)) {
            this.contextDataReceiver.setVersion(chars);
        } else if ("surveyDescription".equalsIgnoreCase(localName)) {
            this.contextDataReceiver.setBeschreibung(ParserUtil.removeWhitespaces(chars));
        } else if ("surveyProcedureCode".equalsIgnoreCase(localName)) {
            this.contextDataReceiver.setProzedurCode(chars);
        } else {
            handled = false;
        }
        return handled;
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("survey".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("survey".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.enable();
        } else if ("surveyID".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("foreignSurveyID".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("surveyName".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("surveyLabel".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("surveyVersion".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("surveyDescription".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("surveyProcedureCode".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw MetaParseException.unknownTagException((String)localName);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("survey".equalsIgnoreCase(localName)) {
            this.disable();
        } else if (!this.handleTag(namespaceURI, localName, qName) && !this.parserChain.endElement(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return null;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectAvailable(SubParser aParser) {
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

