/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.MetaCustomSDFBedingung;
import de.statspez.sdf.generator.meta.MetaCustomSDFMerkmal;
import de.statspez.sdf.generator.meta.SDFElementsTraverser;
import de.statspez.sdf.generator.meta.SDFStructureTraverser;
import de.statspez.sdf.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFBedingung;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.sdf.generator.util.SDFUtil;
import de.werum.sis.meta.ElementVisitorInterface;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.Reference;
import de.werum.sis.meta.parser.ResolveException;
import de.werum.sis.meta.parser.ResolverInterface;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class SDFResolver
extends SDFElementsTraverser
implements ResolverInterface {
    public static final String REF_TYPE_CLASSIFICATION = "CLASSIFICATION";
    public static final String REF_TYPE_FEATURE = "FEATURE";
    public static final String REF_TYPE_FEATURE_GROUP = "FEATURE_GROUP";
    public static final String REF_TYPE_REFERENCE_FIELD = "REFERENCE_FIELD";
    private Hashtable referenceTable = new Hashtable();
    private ConditionResolver conditionResolver = new ConditionResolver();
    private boolean firstRun = true;

    private void solveReference(String refType, String refName, Object refElement) {
        Hashtable names = (Hashtable)this.referenceTable.get(refType);
        if (names == null) {
            return;
        }
        Vector references = (Vector)names.get(refName);
        if (references == null) {
            return;
        }
        Iterator iter = references.iterator();
        while (iter != null && iter.hasNext()) {
            MetaSDFBedingung bedingung;
            MetaSDFFeldReferenz feldReferenz;
            Reference reference = (Reference)iter.next();
            if (REF_TYPE_CLASSIFICATION.equals(refType)) {
                if (!(reference.getReferringElement() instanceof MetaSDFMerkmal)) continue;
                MetaCustomSDFMerkmal merkmal = (MetaCustomSDFMerkmal)reference.getReferringElement();
                merkmal.setKlasseWertebereich((MetaAuspraegungsgruppe)refElement);
                reference.solved();
                continue;
            }
            if (REF_TYPE_FEATURE.equals(refType)) {
                if (!(reference.getReferringElement() instanceof MetaSDFFeldReferenz)) continue;
                feldReferenz = (MetaSDFFeldReferenz)reference.getReferringElement();
                feldReferenz.setKlasse((MetaStatspezObjekt)refElement);
                reference.solved();
                continue;
            }
            if (REF_TYPE_FEATURE_GROUP.equals(refType)) {
                if (!(reference.getReferringElement() instanceof MetaSDFFeldReferenz)) continue;
                feldReferenz = (MetaSDFFeldReferenz)reference.getReferringElement();
                feldReferenz.setKlasse((MetaStatspezObjekt)refElement);
                reference.solved();
                continue;
            }
            if (!REF_TYPE_REFERENCE_FIELD.equals(refType) || !(reference.getReferringElement() instanceof MetaSDFBedingung) || (bedingung = (MetaSDFBedingung)reference.getReferringElement()) != refElement) continue;
            Iterator refFields = this.conditionResolver.getReferenceFields();
            while (refFields != null && refFields.hasNext()) {
                bedingung.addToBezugsfeld((MetaSDFFeldReferenz)refFields.next());
            }
            reference.solved();
        }
    }

    private void checkSolved() throws ResolveException {
        StringBuffer message = new StringBuffer("");
        for (String refType : this.referenceTable.keySet()) {
            Hashtable nameTable = (Hashtable)this.referenceTable.get(refType);
            if (nameTable == null) continue;
            for (String name : nameTable.keySet()) {
                Vector referencesVector = (Vector)nameTable.get(name);
                if (referencesVector == null) continue;
                for (Reference reference : referencesVector) {
                    if (reference.isSolved()) continue;
                    if (message.length() > 0) {
                        message.append(System.getProperty("line.separator"));
                    }
                    message.append("Die Referenz auf ");
                    if (REF_TYPE_CLASSIFICATION.equals(refType)) {
                        message.append("die Auspraegungsgruppe");
                    } else if (REF_TYPE_FEATURE.equals(refType)) {
                        message.append("das Merkmal");
                    } else if (REF_TYPE_FEATURE_GROUP.equals(refType)) {
                        message.append("die Merkmalsgruppe");
                    } else if (REF_TYPE_REFERENCE_FIELD.equals(refType)) {
                        message.append("das Bezugsfeld");
                    }
                    message.append(" ");
                    message.append(name);
                    message.append(" konnte nicht aufgeloest werden.");
                }
            }
        }
        if (message.length() > 0) {
            throw new ResolveException(message.toString());
        }
    }

    @Override
    public void visitSDFMerkmalsgruppe(MetaSDFMerkmalsgruppe merkmalsgruppe) {
        if (this.firstRun) {
            this.solveReference(REF_TYPE_FEATURE_GROUP, merkmalsgruppe.getName(), merkmalsgruppe);
        } else {
            Iterator iter = merkmalsgruppe.getSDFBedingungen();
            while (iter != null && iter.hasNext()) {
                MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)iter.next();
                if (!this.conditionResolver.doResolve(condition.getReference(), merkmalsgruppe)) continue;
                this.solveReference(REF_TYPE_REFERENCE_FIELD, condition.getReference(), condition);
            }
        }
        super.visitSDFMerkmalsgruppe(merkmalsgruppe);
    }

    @Override
    public void visitSDFMerkmal(MetaSDFMerkmal merkmal) {
        if (this.firstRun) {
            this.solveReference(REF_TYPE_FEATURE, merkmal.getName(), merkmal);
        }
    }

    @Override
    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe auspraegungsgruppe) {
        if (this.firstRun) {
            this.solveReference(REF_TYPE_CLASSIFICATION, auspraegungsgruppe.getName(), auspraegungsgruppe);
        }
    }

    @Override
    public void visitSDFAusgabegruppe(MetaSDFAusgabegruppe ausgabegruppe) {
        if (!this.firstRun) {
            Iterator iter = ausgabegruppe.getSDFBedingungen();
            while (iter != null && iter.hasNext()) {
                MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)iter.next();
                if (!this.conditionResolver.doResolve(condition.getReference(), ausgabegruppe)) continue;
                this.solveReference(REF_TYPE_REFERENCE_FIELD, condition.getReference(), condition);
            }
        }
    }

    public void doResolve(MetaElementInterface rootElement) throws ResolveException {
        this.firstRun = true;
        rootElement.accept((ElementVisitorInterface)this);
        this.firstRun = false;
        rootElement.accept((ElementVisitorInterface)this);
        this.checkSolved();
    }

    public void registerForResolve(Reference reference) {
        Vector<Reference> references;
        Hashtable<String, Vector<Reference>> names = (Hashtable<String, Vector<Reference>>)this.referenceTable.get(reference.getRefType());
        if (names == null) {
            names = new Hashtable<String, Vector<Reference>>();
            this.referenceTable.put(reference.getRefType(), names);
        }
        if ((references = (Vector<Reference>)names.get(reference.getRefName())) == null) {
            references = new Vector<Reference>();
            names.put(reference.getRefName(), references);
        }
        references.add(reference);
    }

    private class ConditionResolver
    extends SDFStructureTraverser {
        private String reference = null;
        private Vector referenceFields = new Vector();

        public boolean doResolve(String aReference, MetaElementInterface element) {
            this.reference = aReference;
            this.referenceFields.clear();
            try {
                element.accept((ElementVisitorInterface)this);
            }
            catch (StopToResolveException stopToResolveException) {
                // empty catch block
            }
            return !this.referenceFields.isEmpty();
        }

        public Iterator getReferenceFields() {
            return this.referenceFields.iterator();
        }

        @Override
        public void visitSDFFeldReferenz(MetaSDFFeldReferenz feldReferenz) {
            this.referenceFields.add(feldReferenz);
            String currentReference = SDFUtil.getReferenceField(this.getReferenceFields());
            if (this.reference.equals(currentReference)) {
                throw new StopToResolveException();
            }
            if (feldReferenz.getKlasse() instanceof MetaSDFMerkmalsgruppe && this.reference.startsWith(String.valueOf(currentReference) + ".")) {
                super.visitSDFFeldReferenz(feldReferenz);
            }
            this.referenceFields.remove(feldReferenz);
        }
    }

    private class StopToResolveException
    extends RuntimeException {
        private StopToResolveException() {
        }
    }
}

