/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.parser.ContextParser;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LegalBasisParser
extends SubParser {
    private boolean isNational = false;
    private boolean isEuropean = false;
    private ContextParser.ContextDataReceiver contextDataReceiver;

    public LegalBasisParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
    }

    public void setContextDataReceiver(ContextParser.ContextDataReceiver contextDataReceiver) {
        this.contextDataReceiver = contextDataReceiver;
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("url".equalsIgnoreCase(localName)) {
            if (this.isNational) {
                this.contextDataReceiver.setUrlGesetzesGrundlage(chars);
            }
            if (this.isEuropean) {
                this.contextDataReceiver.setUrlGesetzesGrundlageEU(chars);
            }
        } else if ("text".equalsIgnoreCase(localName)) {
            if (this.isNational) {
                this.contextDataReceiver.setTextGesetzesGrundlage(chars);
            }
            if (this.isEuropean) {
                this.contextDataReceiver.setTextGesetzesGrundlageEU(chars);
            }
        } else if (!"description".equalsIgnoreCase(localName) && !"annotation".equalsIgnoreCase(localName)) {
            handled = false;
        }
        return handled;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) {
        String scope;
        if ("legalBasis".equalsIgnoreCase(localName) && (scope = atts.getValue("scope")) != null) {
            if (scope.equals("national")) {
                this.isNational = true;
            } else if (scope.equals("european")) {
                this.isEuropean = true;
            }
        }
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("legalBasis".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("legalBasis".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.isEuropean = false;
            this.isNational = false;
            this.enable();
        } else if ("url".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("text".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("description".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("annotation".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else {
            throw MetaParseException.unknownTagException((String)localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("legalBasis".equalsIgnoreCase(localName)) {
            this.disable();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return null;
    }
}

