/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.inspector;

import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.ValueConversionException;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import de.statspez.sdf.generator.inspector.Field;
import de.statspez.sdf.generator.inspector.FieldGroup;
import java.util.List;

public class PlausiDataset
implements SatzInterface {
    private final FieldGroup dataset;
    private final FieldGroup additionalFields;

    public PlausiDataset(FieldGroup dataset) {
        this(dataset, null);
    }

    public PlausiDataset(FieldGroup dataset, FieldGroup additionalFields) {
        this.dataset = dataset;
        this.additionalFields = additionalFields;
    }

    private Field getField(FeldDeskriptorInterface feldDeskriptor) {
        Field field = this.dataset.getField(feldDeskriptor.getFeldNameTB());
        if (field == null && this.additionalFields != null) {
            field = this.additionalFields.getField(feldDeskriptor.getFeldNameTB());
        }
        return field;
    }

    public int getLaenge(FeldDeskriptorInterface feldDeskriptor, int[] indizes) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        List<FieldGroup> fieldGroupList = this.dataset.getFieldGroupList(feldDeskriptor.getFeldNameTB());
        return fieldGroupList != null ? fieldGroupList.size() : 0;
    }

    public boolean hatWert(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        Field field = this.getField(feldDeskriptor);
        return field != null && field.getValue() != null;
    }

    public String getString(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        Field field = this.getField(feldDeskriptor);
        return field != null ? field.getValue() : null;
    }

    public void setString(FeldDeskriptorInterface feldDeskriptor, String neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        throw new IllegalStateException("SDF-Validierung darf keine Inhalte ver\u00e4ndern.");
    }

    public long getLong(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        long result;
        Field field = this.getField(feldDeskriptor);
        if (field != null && field.getValue() != null && field.getValue().length() > 0) {
            try {
                result = new NumberValue(field.getValue()).asLong();
            }
            catch (ValueConversionException e) {
                throw new WertNichtTypgerechtException(e.getMessage());
            }
        } else {
            result = 0L;
        }
        return result;
    }

    public void setLong(FeldDeskriptorInterface feldDeskriptor, long neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        throw new IllegalStateException("SDF-Validierung darf keine Inhalte ver\u00e4ndern.");
    }

    public double getDouble(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        double result;
        Field field = this.getField(feldDeskriptor);
        if (field != null && field.getValue() != null && field.getValue().length() > 0) {
            try {
                result = new NumberValue(field.getValue()).asDouble();
            }
            catch (ValueConversionException e) {
                throw new WertNichtTypgerechtException(e.getMessage());
            }
        } else {
            result = 0.0;
        }
        return result;
    }

    public void setDouble(FeldDeskriptorInterface feldDeskriptor, double neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        throw new IllegalStateException("SDF-Validierung darf keine Inhalte ver\u00e4ndern.");
    }

    public boolean getBool(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        Field field = this.getField(feldDeskriptor);
        return field != null && field.getValue() != null && field.getValue().equalsIgnoreCase("true");
    }

    public void setBool(FeldDeskriptorInterface feldDeskriptor, boolean neuerWert) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        throw new IllegalStateException("SDF-Validierung darf keine Inhalte ver\u00e4ndern.");
    }

    public void setLeerWert(FeldDeskriptorInterface feldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        throw new IllegalStateException("SDF-Validierung darf keine Inhalte ver\u00e4ndern.");
    }

    public SatzInterface getSubSatz(FeldDeskriptorInterface satzFeldDeskriptor) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        List<FieldGroup> fieldGroupList = this.dataset.getFieldGroupList(satzFeldDeskriptor.getFeldNameTB());
        return new PlausiDataset(fieldGroupList.get(satzFeldDeskriptor.getIndizes()[0]));
    }
}

