/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.saiku.service.ISessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Path(value="/saiku/session")
public class SessionResource {
    private static final Logger log = LoggerFactory.getLogger(SessionResource.class);
    private ISessionService sessionService;

    public void setSessionService(ISessionService ss) {
        this.sessionService = ss;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response login(@Context HttpServletRequest req, @FormParam(value="username") String username, @FormParam(value="password") String password) {
        try {
            this.sessionService.login(req, username, password);
            return Response.ok().build();
        }
        catch (Exception e) {
            log.debug("Error logging in:" + username, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Map<String, Object> getSession(@Context HttpServletRequest req) {
        Map sess = this.sessionService.getSession();
        try {
            String acceptLanguage = req.getLocale().getLanguage();
            if (StringUtils.isNotBlank((String)acceptLanguage)) {
                sess.put("language", acceptLanguage);
            }
        }
        catch (Exception e) {
            log.debug("Cannot get language!", (Throwable)e);
        }
        return sess;
    }

    @DELETE
    public Response logout(@Context HttpServletRequest req) {
        this.sessionService.logout(req);
        return Response.ok().build();
    }
}

