/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang.StringUtils;
import org.saiku.web.rest.objects.resultset.QueryResult;
import org.saiku.web.rest.resources.ISaikuRepository;
import org.saiku.web.rest.resources.QueryResource;
import org.saiku.web.svg.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Path(value="/saiku/{username}/export")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ExporterResource {
    private static final Logger log = LoggerFactory.getLogger(ExporterResource.class);
    private static final String PREFIX_PARAMETER = "param";
    private ISaikuRepository repository;
    private QueryResource queryResource;

    public void setQueryResource(QueryResource qr) {
        this.queryResource = qr;
    }

    public void setRepository(ISaikuRepository repository) {
        this.repository = repository;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/saiku/xls")
    public Response exportExcel(@QueryParam(value="file") String file, @QueryParam(value="formatter") String formatter, @Context HttpServletRequest servletRequest) {
        try {
            Response f = this.repository.getResource(file);
            String fileContent = new String((byte[])f.getEntity());
            String queryName = UUID.randomUUID().toString();
            fileContent = this.replaceParameters(fileContent, this.getParameters(servletRequest));
            this.queryResource.createQuery(null, null, null, null, fileContent, queryName);
            this.queryResource.execute(queryName, formatter, 0);
            return this.queryResource.getQueryExcelExport(queryName, formatter);
        }
        catch (Exception e) {
            log.error("Error exporting XLS for file: " + file, (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/saiku/csv")
    public Response exportCsv(@QueryParam(value="file") String file, @QueryParam(value="formatter") String formatter, @Context HttpServletRequest servletRequest) {
        try {
            Response f = this.repository.getResource(file);
            String fileContent = (String)f.getEntity();
            fileContent = this.replaceParameters(fileContent, this.getParameters(servletRequest));
            String queryName = UUID.randomUUID().toString();
            this.queryResource.createQuery(null, null, null, null, fileContent, queryName);
            this.queryResource.execute(queryName, formatter, 0);
            return this.queryResource.getQueryCsvExport(queryName);
        }
        catch (Exception e) {
            log.error("Error exporting CSV for file: " + file, (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/saiku/json")
    public Response exportJson(@QueryParam(value="file") String file, @QueryParam(value="formatter") String formatter, @Context HttpServletRequest servletRequest) {
        try {
            Response f = this.repository.getResource(file);
            String fileContent = (String)f.getEntity();
            fileContent = this.replaceParameters(fileContent, this.getParameters(servletRequest));
            String queryName = UUID.randomUUID().toString();
            this.queryResource.createQuery(null, null, null, null, fileContent, queryName);
            QueryResult qr = this.queryResource.execute(queryName, formatter, 0);
            return Response.ok().entity((Object)qr).build();
        }
        catch (Exception e) {
            log.error("Error exporting CSV for file: " + file, (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Produces(value={"image/*"})
    @Path(value="/saiku/chart")
    public Response exportChart(@FormParam(value="type") @DefaultValue(value="png") String type, @FormParam(value="svg") String svg, @FormParam(value="size") Integer size) {
        try {
            String imageType = type.toUpperCase();
            Converter converter = Converter.byType(imageType);
            if (converter == null) {
                throw new Exception("Image convert is null");
            }
            if (StringUtils.isBlank((String)svg)) {
                throw new Exception("Missing 'svg' parameter");
            }
            ByteArrayInputStream in = new ByteArrayInputStream(svg.getBytes("UTF-8"));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            converter.convert(in, out, size);
            out.flush();
            byte[] doc = out.toByteArray();
            return Response.ok((Object)doc).type(converter.getContentType()).header("content-disposition", (Object)("attachment; filename = chart." + converter.getExtension())).header("content-length", (Object)doc.length).build();
        }
        catch (Exception e) {
            log.error("Error exporting Chart to  " + type, (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Map<String, String> getParameters(HttpServletRequest req) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (req != null) {
            Enumeration enumeration = req.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String param = (String)enumeration.nextElement();
                String value = req.getParameter(param);
                if (!param.toLowerCase().startsWith(PREFIX_PARAMETER)) continue;
                param = param.substring(PREFIX_PARAMETER.length());
                queryParams.put(param, value);
            }
        }
        return queryParams;
    }

    private String replaceParameters(String query, Map<String, String> parameters) {
        for (String parameter : parameters.keySet()) {
            String value = parameters.get(parameter);
            query = query.replaceAll("\\$\\{" + parameter + "\\}", value);
        }
        return query;
    }
}

