/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel.examples;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class EventExample
implements HSSFListener {
    private SSTRecord sstrec;

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 2057: {
                BOFRecord bof = (BOFRecord)record;
                if (bof.getType() == 5) {
                    System.out.println("Encountered workbook");
                    break;
                }
                if (bof.getType() != 16) break;
                System.out.println("Encountered sheet reference");
                break;
            }
            case 133: {
                BoundSheetRecord bsr = (BoundSheetRecord)record;
                System.out.println("New sheet named: " + bsr.getSheetname());
                break;
            }
            case 520: {
                RowRecord rowrec = (RowRecord)record;
                System.out.println("Row found, first column at " + rowrec.getFirstCol() + " last column at " + rowrec.getLastCol());
                break;
            }
            case 515: {
                NumberRecord numrec = (NumberRecord)record;
                System.out.println("Cell found with value " + numrec.getValue() + " at row " + numrec.getRow() + " and column " + numrec.getColumn());
                break;
            }
            case 252: {
                this.sstrec = (SSTRecord)record;
                for (int k = 0; k < this.sstrec.getNumUniqueStrings(); ++k) {
                    System.out.println("String table value " + k + " = " + this.sstrec.getString(k));
                }
                break;
            }
            case 253: {
                LabelSSTRecord lrec = (LabelSSTRecord)record;
                System.out.println("String cell found with value " + this.sstrec.getString(lrec.getSSTIndex()));
            }
        }
    }

    public static void main(String[] args) throws IOException {
        FileInputStream fin = new FileInputStream(args[0]);
        POIFSFileSystem poifs = new POIFSFileSystem((InputStream)fin);
        DocumentInputStream din = poifs.createDocumentInputStream("Workbook");
        HSSFRequest req = new HSSFRequest();
        req.addListenerForAllRecords((HSSFListener)new EventExample());
        HSSFEventFactory factory = new HSSFEventFactory();
        factory.processEvents(req, (InputStream)din);
        fin.close();
        din.close();
        poifs.close();
        System.out.println("done.");
    }
}

