/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test;

import de.statspez.pleditor.generator.parser.speclanguage.Parser;
import de.statspez.pleditor.generator.parser.speclanguage.Scanner;
import java.io.StringReader;
import java_cup.runtime.Symbol;
import junit.framework.TestCase;

public class SpecParserTest
extends TestCase {
    Scanner scanner = null;
    Parser parser = null;

    public SpecParserTest(String arg0) {
        super(arg0);
    }

    public void test_01_basics() throws Exception {
        String code = "GIB a[10] AUS GIB a[b] AUS GIB a[b+10] AUS GIB a[2] [3] AUS GIB a [2] [3][4] AUS GIB s.element AUS GIB s.element.subelement AUS GIB s.element.subelement.subsubelement AUS GIB s[5].element.subelement[3][2].subsubelemnt AUS c := foo + bar (a) := foo (a, b) := array c := a[10][2] + b + foo.bar[2].wert.subwert[5][6] c := -a c := -a + 12 c := a + -12 c := -a + -b c := -(a * 12) * -12 bool := a ODER b bool := a UND b bool := a UND NICHT b bool := NICHT a UND b bool := (NICHT (a-10 > 5)) UND b < 9 bool := NICHT (a ODER b) UND (NICHT (b UND c) ODER d) ";
        this.scanner.yyreset(new StringReader(code));
        Symbol syntax = this.parser.parse();
    }

    public void test_02_wenndann() throws Exception {
        String code = "VAR a,b,c,d,nachricht a:=5 b:=10 c:=7*5/8.81245 d:=3.1465 nachricht:='Hallo' WENN ((a > b) UND (c < d)) ODER (d * 2 / 5 < a)    DANN  GIB nachricht, ', die Bedingung ist erfuellt.' AUS    SONST GIB nachricht, ', die Bedingung ist nicht erfuellt.' AUS ENDE \nVAR reihe  reihe:={1,3,6,9,10,15--20,25,30,35..100} VAR test   test:=5 WENN test IN reihe    DANN GIB test, ' ist nicht in ', reihe, ' enthalten' AUS ENDE";
        this.scanner.yyreset(new StringReader(code));
        this.parser.parse();
    }

    public void test_03_solange() throws Exception {
        String code = "\"Ein Kommentar, dies ist ein einfacher Kommentar \nder ueber mehrere Zeilen geht\" \nVAR a,b,abbruch,count \na:=0 b:=6 abbruch:=FALSCH count:=0\nWIEDERHOLE SOLANGE (a < b) ODER abbruch \n   a := a + 1 count := count + 1 \n   WENN count = 4 \n      DANN abbruch:=WAHR SONST abbruch:=FALSCH ENDE \nENDE \nGIB a,b,abbruch,count AUS";
        this.scanner.yyreset(new StringReader(code));
        this.parser.parse();
    }

    public void test_04_fuervonbis() throws Exception {
        String code = "VAR start,ende,maximal,i start:=5 ende:=20 maximal:=10WIEDERHOLE FUER i:=start - 2 BIS i > ende SCHRITTWEITE 1    WENN i > maximal DANN ABBRUCH ENDE ENDE GIB i,start,\"zwischen drinn mal ein kommentar\"ende,maximal AUS";
        this.scanner.yyreset(new StringReader(code));
        this.parser.parse();
    }

    public void test_05_fuerjedes() throws Exception {
        String code = "VAR einElement,a WIEDERHOLE FUER JEDES ELEMENT=einElement VON a    GIB einElement AUS ENDE";
        this.scanner.yyreset(new StringReader(code));
        this.parser.parse();
    }

    public void test_06_funktionsaufruf() throws Exception {
        String code = "VAR test,meinPI meinPI := &PI() + 5 GIB meinPI, &PI() AUS &eineFunktion() &eineFunktionMitParameter(test,meinPI,5+6) test := &MEDIAN({a,b,c,d,e,f,g}) test := &MITTEL(a,b) * 2 + (&STABW({5.5..6.1} / 7))";
        this.scanner.yyreset(new StringReader(code));
        this.parser.parse();
    }

    public void test_07_materialreferenz() throws Exception {
        String code = "VAR wert1, wert2 (wert1, wert2) := MATERIAL M1(key1:=10,key2:='test'|foo, bar) WENN NICHT (MATERIAL M2(key:=i|wert) < maximum)    DANN FEHLER ENDE";
        this.scanner.yyreset(new StringReader(code));
        this.parser.parse();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.scanner = new Scanner(new StringReader(""));
        this.parser = new Parser(this.scanner);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.scanner.yyclose();
    }
}

