/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.meta.MetaCustomPLMaterial;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ThisParser
extends SubParser {
    private MetaStatspezObjekt currentElement = null;

    public ThisParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "this".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("this".equalsIgnoreCase(localName)) {
            this.enable();
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("this".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.currentElement;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("this".equalsIgnoreCase(localName)) {
            String string = atts.getValue("version");
        } else if ("objectID".equalsIgnoreCase(localName)) {
            String string = atts.getValue("class");
        } else if ("objectName".equalsIgnoreCase(localName)) {
            String string = atts.getValue("class");
        } else if ("objectVersion".equalsIgnoreCase(localName)) {
            String string = atts.getValue("class");
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("objectID".equalsIgnoreCase(localName)) {
            this.currentElement.getMetaObjectContext().setObjectID(chars);
        } else if ("objectName".equalsIgnoreCase(localName)) {
            this.currentElement.setName(chars);
        } else if (!"objectVersion".equalsIgnoreCase(localName)) {
            if ("objectPakage".equalsIgnoreCase(localName) || "objectPackage".equalsIgnoreCase(localName)) {
                this.currentElement.getMetaObjectContext().setObjectPakage(chars);
            } else if ("objectClass".equalsIgnoreCase(localName)) {
                if (this.currentElement instanceof MetaCustomPLMaterial) {
                    int i = chars.indexOf("Erhebung");
                    ((MetaCustomPLMaterial)this.currentElement).setErhebung(i != -1);
                }
            } else {
                handled = false;
            }
        }
        return handled;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void setCurrentElement(MetaStatspezObjekt objekt) {
        this.currentElement = objekt;
    }
}

