/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaCustomRawFieldGroup;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaRawField;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.RawFieldParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RawFieldGroupParser
extends SubParser
implements SuperParser {
    private MetaCustomRawFieldGroup fieldGroup = null;
    private ParserChain parserChain = new ParserChain();
    private RawFieldParser feldParser = null;
    private RawFieldGroupParser groupParser = null;

    public RawFieldGroupParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.feldParser = new RawFieldParser(this, resolver);
        this.feldParser.disallow();
        this.parserChain.addParser(this.feldParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "rawFieldGroup".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("rawFieldGroup".equalsIgnoreCase(localName) && !this.isEnabled()) {
            this.enable();
            this.fieldGroup = new MetaCustomRawFieldGroup();
            this.handleAttributes(namespaceURI, localName, qName, atts);
            this.notifyObjectStarted();
            if (this.groupParser == null) {
                this.groupParser = new RawFieldGroupParser(this, this.resolver());
                this.groupParser.allow();
                this.parserChain.addParser(this.groupParser);
            }
            this.feldParser.allow();
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("rawFieldGroup".equalsIgnoreCase(localName) && (this.groupParser == null || !this.groupParser.isEnabled())) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    @Override
    public MetaElement object() {
        return this.fieldGroup;
    }

    @Override
    public void notifyObjectStarted(SubParser aParser) {
        if (aParser == this.feldParser) {
            this.groupParser.disallow();
        } else if (aParser == this.groupParser) {
            this.feldParser.disallow();
        }
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.feldParser) {
            this.fieldGroup.addToListOfRawField((MetaRawField)aParser.object());
            this.groupParser.allow();
        } else if (aParser == this.groupParser) {
            this.fieldGroup.addToListOfRawField((MetaRawField)aParser.object());
            this.feldParser.allow();
        }
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("rawFieldGroup".equalsIgnoreCase(localName)) {
            String source;
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer das RawField ist kein Name definiert!");
            }
            this.fieldGroup.setName(name.trim());
            String id = atts.getValue("id");
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.fieldGroup.setId(id.trim());
            } else {
                this.fieldGroup.setId(name);
            }
            String typ = atts.getValue("type");
            if (typ == null) {
                throw new ILParseException("Fuer das RawFieldGroup ist kein Typ definiert!");
            }
            this.fieldGroup.setTyp(typ.trim());
            String dimensions = atts.getValue("dimensions");
            if (dimensions != null && dimensions.length() > 0) {
                this.fieldGroup.setDimension(dimensions);
                this.fieldGroup.setDimensions(Helper.parseDimensionSpec(dimensions.trim()));
            }
            if ((source = atts.getValue("source")) != null) {
                this.fieldGroup.setDSBName(source.trim());
            }
        }
        if (this.superParser() != null && this.superParser() instanceof SubParser && ((SubParser)((Object)this.superParser())).object() != null) {
            this.fieldGroup.setRawParent(((SubParser)((Object)this.superParser())).object());
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = false;
        String chars = this.superParser().charData().toString().trim();
        return handled;
    }

    private void setDsbOfSubParsers(MetaDsbObjekt _dsb) {
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "rawFieldGroup".equalsIgnoreCase(tag);
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

