/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.masken;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.AbstractMaskenParser;
import de.statspez.pleditor.generator.masken.GanzZahlMaske;
import de.statspez.pleditor.generator.masken.MaskeException;
import de.statspez.pleditor.generator.masken.ZahlAusdruckList;
import de.statspez.pleditor.generator.masken.ZahlMaske;
import java.util.regex.Pattern;

public class GanzZahlMaskenParser
extends AbstractMaskenParser {
    protected final int V_KANN = 0;
    protected final int V_MUSS = 1;
    protected final int V_KEIN = 2;
    protected final int V_MINUS = 3;
    protected final int V_PLUS = 4;
    protected int vorzeichenTyp;

    @Override
    public AbstractMaske parse(String maske) throws MaskeException {
        GanzZahlMaske zahlMaske = this.createMaske();
        StringBuffer message = new StringBuffer();
        zahlMaske.setzeMaskeAlsString(maske);
        if (maske == null || maske.length() == 0) {
            throw new MaskeException("Die Maske muss angegeben werden!");
        }
        if (!this.isSegmentGueltig(maske, message) || !this.maskeVollstaendig(maske)) {
            throw new MaskeException("Maske ist falsch beschrieben. " + message.toString());
        }
        maske = this.parseVorzeichen(zahlMaske, maske);
        maske = this.parseAusrichtung(zahlMaske, maske);
        String str = this.erzeugePatternString(zahlMaske, maske);
        Pattern p = Pattern.compile(str);
        zahlMaske.setzePattern(p);
        return zahlMaske;
    }

    @Override
    public boolean isSegmentGueltig(String segment) {
        return this.isSegmentGueltig(segment, null);
    }

    protected boolean isSegmentGueltig(String segment, StringBuffer message) {
        boolean erg = true;
        if ((segment = this.schneideVorzeichenTeilAb(segment)).length() > 0) {
            segment = this.schneideAusrichtungTeilAb(segment);
        }
        if (segment.length() > 0) {
            erg = this.pruefeZahlDefinition(segment, message);
        }
        return erg;
    }

    protected boolean pruefeZahlDefinition(String segment, StringBuffer message) {
        boolean hatMinMaxTrennzeichen = false;
        boolean maskiert = false;
        boolean ok = true;
        int i = 0;
        while (ok && i < segment.length()) {
            char ch = segment.charAt(i);
            switch (ch) {
                case '0': {
                    if (maskiert) {
                        maskiert = false;
                        break;
                    }
                    if (hatMinMaxTrennzeichen) {
                        ok = false;
                        if (message == null) break;
                        message.append("Maskendefinition kann nur ein 0-Symbol enthalten.");
                        break;
                    }
                    hatMinMaxTrennzeichen = true;
                    break;
                }
                case '\\': {
                    if (maskiert) {
                        ok = false;
                        break;
                    }
                    maskiert = true;
                    break;
                }
                case '#': {
                    if (!maskiert) break;
                    ok = false;
                    if (message == null) break;
                    message.append("Ung\u00fcltiges Zeichen '" + ch + "'.");
                    break;
                }
                default: {
                    if (maskiert) {
                        ok = false;
                        if (message == null) break;
                        message.append("Ung\u00fcltiges Zeichen '\\" + ch + "'.");
                        break;
                    }
                    ok = Character.isDigit(ch);
                    if (ok || message == null) break;
                    message.append("Ung\u00fcltiges Zeichen '" + ch + "'.");
                }
            }
            ++i;
        }
        return ok;
    }

    protected String schneideAusrichtungTeilAb(String segment) {
        if (segment.charAt(0) == 'L' || segment.charAt(0) == 'R' || segment.charAt(0) == 'M') {
            segment = segment.substring(1);
        }
        return segment;
    }

    protected String schneideVorzeichenTeilAb(String segment) {
        if (segment.startsWith("\\+") || segment.startsWith("\\-")) {
            segment = segment.substring(2);
        } else if (segment.startsWith("+") || segment.startsWith("-")) {
            segment = segment.substring(1);
        }
        return segment;
    }

    @Override
    protected void initSymbole() {
        this.symbole = new char[]{'L', 'M', 'R', '-', '+', '0', '\\', '#'};
    }

    protected String parseVorzeichen(ZahlMaske zahlMaske, String maske) throws MaskeException {
        this.vorzeichenTyp = 2;
        if (maske != null && maske.length() > 0) {
            char ch = maske.charAt(0);
            switch (ch) {
                case '\\': {
                    if (maske.length() > 1) {
                        if (maske.charAt(1) == '+') {
                            this.vorzeichenTyp = 4;
                            zahlMaske.setVorzeichen(true);
                            zahlMaske.setMussVorzeichen(true);
                            maske = maske.substring(2);
                            break;
                        }
                        if (maske.charAt(1) == '-') {
                            this.vorzeichenTyp = 3;
                            zahlMaske.setVorzeichen(true);
                            zahlMaske.setMussVorzeichen(true);
                            maske = maske.substring(2);
                            break;
                        }
                        if (maske.charAt(1) == '0') {
                            this.vorzeichenTyp = 2;
                            zahlMaske.setVorzeichen(false);
                            break;
                        }
                        throw new MaskeException("Ung\u00fcltiges Zeichen '" + ch + "'.");
                    }
                    throw new MaskeException("Ung\u00fcltiges Zeichen '" + ch + "'.");
                }
                case '-': {
                    this.vorzeichenTyp = 0;
                    maske = maske.substring(1);
                    zahlMaske.setVorzeichen(true);
                    break;
                }
                case '+': {
                    this.vorzeichenTyp = 1;
                    maske = maske.substring(1);
                    zahlMaske.setVorzeichen(true);
                    zahlMaske.setMussVorzeichen(true);
                }
            }
        }
        return maske;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String erzeugePatternString(GanzZahlMaske zahlMaske, String maske) throws MaskeException {
        ZahlAusdruckList list = new ZahlAusdruckList(this.erzeugeVorzeichenRegularExpression());
        StringBuffer buf = new StringBuffer();
        boolean negation = false;
        boolean minimumAn = false;
        int min = 0;
        int max = 0;
        int i = 0;
        while (i < maske.length()) {
            char ch = maske.charAt(i);
            if (negation) {
                if (ch != '0') throw new MaskeException("Ung\u00fcltiges Zeichen \\" + ch);
                list.fuegeAusdruckHinzu(new String(new char[]{ch}));
                ++max;
                if (minimumAn) {
                    ++min;
                }
                negation = false;
            } else if ('0' == ch) {
                minimumAn = true;
                zahlMaske.setzeFuellzeichen('0');
            } else if ('\\' == ch) {
                if (negation) {
                    throw new MaskeException("Ung\u00fcltiges Zeichen \\" + ch);
                }
                negation = true;
            } else {
                if ('#' != ch && !Character.isDigit(ch)) throw new MaskeException("Ung\u00fcltiges Zeichen " + ch);
                String regularExpression = '#' == ch ? this.gibAusdruckFuerSymbol(ch) : new String(new char[]{ch});
                list.fuegeAusdruckHinzu(regularExpression);
                ++max;
                if (minimumAn) {
                    ++min;
                }
            }
            ++i;
        }
        zahlMaske.setzeMaxLaenge(zahlMaske.hatVorzeichen() ? max + 1 : max);
        int minLaenge = min == 0 ? 1 : min;
        if (this.vorzeichenTyp == 1 || this.vorzeichenTyp == 3 || this.vorzeichenTyp == 4) {
            ++minLaenge;
        }
        zahlMaske.setzeMinLaenge(minLaenge);
        buf.append(list.gibPattern(min, max));
        return buf.toString();
    }

    protected String erzeugeVorzeichenRegularExpression() {
        String vorzRegularExpression = null;
        switch (this.vorzeichenTyp) {
            case 4: {
                vorzRegularExpression = this.maskierePatternSymbol('+');
                break;
            }
            case 3: {
                vorzRegularExpression = this.maskierePatternSymbol('-');
                break;
            }
            case 0: {
                vorzRegularExpression = "[" + this.maskierePatternSymbol('+') + this.maskierePatternSymbol('-') + "]?";
                break;
            }
            case 1: {
                vorzRegularExpression = "[" + this.maskierePatternSymbol('+') + this.maskierePatternSymbol('-') + "]";
            }
        }
        return vorzRegularExpression;
    }

    protected boolean maskeVollstaendig(String maske) {
        boolean erg = false;
        if (maske != null && maske.length() > 0) {
            char lastChar = maske.charAt(maske.length() - 1);
            erg = lastChar == '#' || maske.endsWith(new String(new char[]{'\\', '0'})) || Character.isDigit(lastChar) && lastChar != '0';
        }
        return erg;
    }

    protected GanzZahlMaske createMaske() {
        return new GanzZahlMaske();
    }
}

