/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare2.ui;

import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PLPlainDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    private Long maxLength = null;
    private boolean modifyInput = true;
    private boolean showThousandSeparator = false;
    private boolean isNumber = false;
    private int caretPosition = -1;
    private boolean isActionReplace = false;

    public PLPlainDocument(MetaTBFeld feld) {
        MetaMerkmal mm;
        if (feld != null && feld.getKlasse() instanceof MetaMerkmal && (mm = (MetaMerkmal)feld.getKlasse()).getLaenge() > 0L) {
            this.maxLength = new Long(mm.getLaenge());
        }
        if (feld != null && feld.getKlasse() instanceof MetaMerkmal) {
            mm = (MetaMerkmal)feld.getKlasse();
            this.isNumber = mm.getTyp() == 1 || mm.getTyp() == 5;
        }
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.showThousandSeparator && this.isNumber) {
            this.insertStringWithThousandSeparator(offs, str, a);
        } else if (this.modifyInput) {
            this.insertStringOld(offs, str, a);
        } else {
            super.insertString(offs, str, a);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        if (this.showThousandSeparator && this.isNumber && this.getLength() > 0 && !this.isActionReplace) {
            String textneu = this.updateStringWithThousandSeparator(this.getText(0, this.getLength()), offs);
            this.replaceText(textneu, this.getAttributeContext().getEmptySet());
        }
    }

    public void setModifyInput(boolean modifyInput) {
        this.modifyInput = modifyInput;
    }

    public boolean isModifyInput() {
        return this.modifyInput;
    }

    public void setShowThousandSeparator(boolean showThousandSeparator) {
        this.showThousandSeparator = showThousandSeparator;
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        this.isActionReplace = true;
        super.replace(offset, length, text, attrs);
        this.isActionReplace = false;
    }

    private void insertStringOld(int offs, String str, AttributeSet a) throws BadLocationException {
        boolean ok = true;
        StringBuffer tmp = new StringBuffer(this.getText(0, offs));
        tmp.append(str);
        if (this.getLength() - offs >= 0) {
            tmp.append(this.getText(offs, this.getLength() - offs));
        }
        if (this.maxLength != null) {
            boolean bl = ok = (long)tmp.length() <= this.maxLength;
        }
        if (ok) {
            super.insertString(offs, str, a);
        }
    }

    private void insertStringWithThousandSeparator(int offs, String str, AttributeSet a) throws BadLocationException {
        boolean ok = true;
        StringBuffer tmp = new StringBuffer(this.getText(0, offs));
        tmp.append(str);
        if (this.getLength() - offs >= 0) {
            tmp.append(this.getText(offs, this.getLength() - offs));
        }
        String textKorrigiert = this.updateStringWithThousandSeparator(tmp.toString(), offs + str.length());
        if (this.maxLength != null) {
            boolean bl = ok = (long)textKorrigiert.length() <= this.maxLength;
        }
        if (ok) {
            this.replaceText(textKorrigiert, a);
        }
    }

    private String updateStringWithThousandSeparator(String tmp, int cursorPosition) {
        int dezimalzeichenposition = tmp.indexOf(",");
        StringBuffer textKorrigiert = new StringBuffer();
        int zaehler = 0;
        int i = tmp.length() - 1;
        while (i >= 0) {
            char ch = tmp.charAt(i);
            if (dezimalzeichenposition != -1 && i >= dezimalzeichenposition) {
                textKorrigiert.insert(0, ch);
            } else if (ch != '.') {
                if (zaehler == 3) {
                    if (Character.isDigit(ch)) {
                        textKorrigiert.insert(0, '.');
                    }
                    zaehler = 0;
                }
                textKorrigiert.insert(0, ch);
                ++zaehler;
            }
            --i;
        }
        int tmpCursorPosition = 0;
        int i2 = 0;
        while (i2 < tmp.length() && i2 < cursorPosition) {
            if (tmp.charAt(i2) != '.') {
                ++tmpCursorPosition;
            }
            ++i2;
        }
        this.caretPosition = 0;
        i2 = 0;
        while (tmpCursorPosition > 0 && i2 < textKorrigiert.length()) {
            if (textKorrigiert.charAt(i2) != '.') {
                --tmpCursorPosition;
            }
            ++this.caretPosition;
            if (tmpCursorPosition == 0) break;
            ++i2;
        }
        return textKorrigiert.toString();
    }

    private void replaceText(String textNew, AttributeSet a) throws BadLocationException {
        int laenge = this.getLength();
        if (laenge > 0) {
            super.remove(0, laenge);
        }
        super.insertString(0, textNew, a);
    }
}

