/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare;

import de.statspez.pleditor.generator.compare.ComparedNode;
import de.statspez.pleditor.generator.interpreter.TBFieldDescriptorFactory;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import java.util.ArrayList;
import java.util.List;

public class Comparator
extends AbstractElementVisitor {
    public static final int WITH_DIFFERENCE_ONLY = 1;
    public static final int WITH_VALUE_ONLY = 2;
    public static final int ALL_FIELDS = 0;
    private int displayOption;
    private ComparedNode comparedNode;
    private ComparedNode currentNode;
    private SatzInterface satz1;
    private SatzInterface satz2;
    private TBFieldDescriptorFactory fieldDescriptorFactory;
    private List ignoredFields = new ArrayList();

    public List getIgnoredFields() {
        return this.ignoredFields;
    }

    public void setIgnoredFields(List ignoredFields) {
        this.ignoredFields = ignoredFields;
    }

    public synchronized ComparedNode build(MetaCustomPlausibilisierung plausi, SatzInterface satz1, SatzInterface satz2, int displayOption) {
        this.displayOption = displayOption;
        this.fieldDescriptorFactory = new TBFieldDescriptorFactory(plausi);
        this.currentNode = this.comparedNode = new ComparedNode(null, plausi.rootThemenbereich(), null, false, this.satz1, this.satz2, this);
        this.satz1 = satz1;
        this.satz2 = satz2;
        this.visitElements(plausi.rootThemenbereich().getFelder());
        return this.comparedNode;
    }

    public FeldDeskriptorImpl createFeldDeskriptor(String name, int[] indices, FeldDeskriptorImpl parent) throws NoSuchFieldException {
        return this.fieldDescriptorFactory.getFieldDecriptor(name, indices, parent);
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        if (this.displayOption != 0 && !this.currentNode.hasSatz1() && !this.currentNode.hasSatz2()) {
            this.currentNode.removeFromParent();
        }
        this.visitElements(tb.getFelder());
    }

    @Override
    public void visitTBFeld(MetaTBFeld feld) {
        ComparedNode previousNode = this.currentNode;
        int[] dimensions = ((MetaCustomTBFeld)feld).dimensions();
        try {
            this.currentNode = new ComparedNode(this.currentNode, feld, this.fieldDescriptorFactory.getFieldDecriptor(feld.getName(), null, this.currentNode.getFeldDeskriptor()), dimensions != null && dimensions.length > 0, this.satz1, this.satz2, this);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (!this.ignoreCurrentField()) {
            if (dimensions != null && dimensions.length > 0) {
                this.handleDimension(previousNode.getFeldDeskriptor(), feld, dimensions, null);
                if (this.displayOption != 0 && this.currentNode.getChildCount() == 0) {
                    this.currentNode.removeFromParent();
                }
            } else {
                feld.getKlasse().accept(this);
            }
        } else {
            this.currentNode.removeFromParent();
        }
        this.currentNode = previousNode;
    }

    @Override
    public void visitMerkmal(MetaMerkmal merkmal) {
        this.currentNode.readValues();
        if (this.displayOption == 2) {
            if (!this.currentNode.hasValue1() && !this.currentNode.hasValue2()) {
                this.currentNode.removeFromParent();
            }
        } else if (this.displayOption == 1 && !this.currentNode.hasDifferentValues()) {
            this.currentNode.removeFromParent();
        }
    }

    private void handleDimension(FeldDeskriptorImpl parentFeldDeskriptor, MetaTBFeld feld, int[] dimensions, int[] indices) {
        try {
            int size;
            FeldDeskriptorImpl feldDeskriptor = this.fieldDescriptorFactory.getFieldDecriptor(feld.getName(), null, parentFeldDeskriptor);
            int numOfDimension = 0;
            if (indices != null) {
                numOfDimension = indices.length;
            }
            int sizeSatz1 = size = dimensions[numOfDimension];
            int sizeSatz2 = size;
            if (size < 0) {
                if (this.currentNode.hasSatz1()) {
                    sizeSatz1 = feldDeskriptor.getLaenge(this.satz1, indices);
                }
                if (this.currentNode.hasSatz2()) {
                    sizeSatz2 = feldDeskriptor.getLaenge(this.satz2, indices);
                }
                if (sizeSatz1 >= sizeSatz2) {
                    size = sizeSatz1;
                } else if (sizeSatz1 < sizeSatz2) {
                    size = sizeSatz2;
                }
            }
            ComparedNode previousNode = this.currentNode;
            int i = 0;
            while (i < size) {
                int[] currentIndices = new int[numOfDimension + 1];
                if (numOfDimension > 0) {
                    int j = 0;
                    while (j < indices.length) {
                        currentIndices[j] = indices[j];
                        ++j;
                    }
                }
                currentIndices[currentIndices.length - 1] = i;
                FeldDeskriptorImpl currentFeldDeskriptor = this.fieldDescriptorFactory.getFieldDecriptor(feld.getName(), currentIndices, parentFeldDeskriptor);
                this.currentNode = new ComparedNode(previousNode, feld, currentFeldDeskriptor, currentIndices.length < dimensions.length, this.satz1, this.satz2, this);
                if (currentIndices.length == dimensions.length) {
                    feld.getKlasse().accept(this);
                } else {
                    this.handleDimension(parentFeldDeskriptor, feld, dimensions, currentIndices);
                }
                ++i;
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean ignoreCurrentField() {
        boolean ignore;
        if (this.ignoredFields != null && !this.ignoredFields.isEmpty()) {
            String descriptorAsString = this.currentNode.getFeldDeskriptor().hierarchyAsString();
            descriptorAsString = descriptorAsString.replaceAll("\\[[0-9]*\\]", "");
            ignore = this.ignoredFields.contains(descriptorAsString);
        } else {
            ignore = false;
        }
        return ignore;
    }
}

