/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Iterator;

public class PruefungIterator
extends AbstractElementVisitor {
    private MetaElement metaElement;
    private CodeBlock myCode;
    private MetaCustomThemenbereich currentTb;

    public PruefungIterator(MetaElement metaElement) {
        this.metaElement = metaElement;
        this.myCode = null;
        this.currentTb = null;
    }

    public void eachPruefung(CodeBlock code) {
        assert (this.metaElement != null);
        assert (code != null);
        this.myCode = code;
        this.metaElement.accept(this);
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        assert (plausi instanceof MetaCustomPlausibilisierung);
        assert (((MetaCustomPlausibilisierung)plausi).rootThemenbereich() != null);
        MetaCustomPlausibilisierung customPlausi = (MetaCustomPlausibilisierung)plausi;
        Iterator it = customPlausi.getThemenbereiche();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        assert (tb != null);
        assert (tb instanceof MetaCustomThemenbereich);
        this.currentTb = (MetaCustomThemenbereich)tb;
        Iterator it = tb.getPruefungen();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    @Override
    public void visitPLPruefung(MetaPLPruefung pruefung) {
        assert (pruefung != null);
        assert (pruefung instanceof MetaCustomPruefung);
        assert (this.myCode != null);
        this.myCode.doForPruefung((MetaCustomPruefung)pruefung, this.currentTb);
    }

    public static interface CodeBlock {
        public void doForPruefung(MetaCustomPruefung var1, MetaCustomThemenbereich var2);
    }
}

