/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaString;
import java.util.Iterator;

public class ClassificationRegKeyBuilder
extends AbstractElementVisitor {
    private StringBuffer regKey = new StringBuffer();

    public String regKey() {
        return this.regKey.toString();
    }

    @Override
    public void visitClassificationReference(MetaClassificationReference aReference) {
        this.regKey.append("#");
        Iterator it = aReference.levels();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.regKey.append(".");
        }
    }

    @Override
    public void visitNumber(MetaNumber aNumber) {
        this.regKey.append(Integer.toString(aNumber.value().intValue()));
    }

    @Override
    public void visitIdentifier(MetaIdentifier anId) {
        this.regKey.append(anId.value());
    }

    @Override
    public void visitString(MetaString aString) {
        this.regKey.append("'");
        this.regKey.append(aString.value());
        this.regKey.append("'");
    }
}

