/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.mapping.structure;

import de.statspez.pleditor.generator.codegen.mapping.structure.MetaFieldHierarchy;
import de.statspez.pleditor.generator.meta.generated.MetaDsbComps;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import java.util.HashMap;
import java.util.Stack;

public class DsbFieldHierarchy
extends MetaFieldHierarchy {
    public void init(MetaDsbObjekt dsb) {
        this.hierarchieFelder = new HashMap();
        this.aktuelleFeldhierarchie = new Stack();
        this.aktuelleHierarchiestufe = 1;
        if (dsb != null) {
            dsb.accept(this);
        }
    }

    @Override
    public void visitDsbObjekt(MetaDsbObjekt aDsb) {
        if (aDsb.getComps() != null) {
            aDsb.getComps().accept(this);
        }
    }

    @Override
    public void visitDsbComps(MetaDsbComps anObject) {
        this.visitElements(anObject.getCompList());
        this.visitElements(anObject.getSatzList());
    }

    @Override
    public void visitEinzelfeld(MetaEinzelfeld anObject) {
        while (this.aktuelleHierarchiestufe > anObject.getStufenNr()) {
            this.aktuelleFeldhierarchie.pop();
            this.aktuelleHierarchiestufe = (short)(this.aktuelleHierarchiestufe - 1);
        }
        this.hierarchieFelder.put(anObject, this.getFeldHierarchie(anObject.getName()));
        if (this.istStructurTyp(anObject.getTyp())) {
            this.aktuelleFeldhierarchie.push(anObject.getName());
            this.aktuelleHierarchiestufe = (short)(anObject.getStufenNr() + 1);
            if (this.istArrayTyp(anObject.getTyp())) {
                String path = this.getHierarchieFor(anObject);
                this.structureFieldNames.add(path);
            }
        }
    }

    @Override
    public void visitSatzart(MetaSatzart anObject) {
        while (!this.aktuelleFeldhierarchie.isEmpty()) {
            this.aktuelleFeldhierarchie.pop();
        }
        this.hierarchieFelder.put(anObject, this.getFeldHierarchie(anObject.getName()));
        this.aktuelleFeldhierarchie.push(anObject.getName());
        this.aktuelleHierarchiestufe = 1;
        String path = this.getHierarchieFor(anObject);
        this.structureFieldNames.add(path);
        this.visitElements(anObject.getFelder());
        this.aktuelleFeldhierarchie.pop();
        this.aktuelleHierarchiestufe = 1;
    }

    private boolean istArrayTyp(String typ) {
        boolean erg = false;
        if ("Wfgr".equals(typ) || "VKWG".equals(typ)) {
            erg = true;
        }
        return erg;
    }

    private boolean istStructurTyp(String typ) {
        boolean erg = false;
        if ("Str".equals(typ) || "Wfgr".equals(typ) || "VKWG".equals(typ)) {
            erg = true;
        }
        return erg;
    }
}

