/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.PlausiElementCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.java.ThemenbereichConstructorGenerator;
import de.statspez.pleditor.generator.codegen.support.LiteralManager;
import de.statspez.pleditor.generator.codegen.support.NamespaceHelper;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class ThemenbereichCodeGenerator
extends PlausiElementCodeGenerator {
    private CodegenContext context = null;
    private LiteralManager literalManager = null;
    private Scope scope = null;
    private int numOfFields;
    private Stack segments;
    private Vector fields;

    public synchronized void generate(CodegenContext aContext, MetaThemenbereich aTb, Scope tbScope) {
        this.context = aContext;
        this.scope = tbScope;
        this.numOfFields = 0;
        this.segments = new Stack();
        this.fields = new Vector();
        this.context.putContextInfo("TOPIC_CLASS_NAME_KEY", this.getTbClass(aTb));
        aTb.accept(this);
        this.checkForErrors();
        this.out.flush();
        this.context.putContextInfo("TOPIC_CLASS_NAME_KEY", null);
    }

    public void setLiteralManager(LiteralManager aManager) {
        this.literalManager = aManager;
    }

    private void createTbConstructor(MetaThemenbereich tb, String className, boolean superIsNotBaseClass, Vector fieldsToInit) {
        ThemenbereichConstructorGenerator codeGen = new ThemenbereichConstructorGenerator();
        codeGen.setOutput(this.out);
        codeGen.setIndentLevel(this.indentLevel());
        codeGen.setErrorContext(this.context.getMessageContext());
        codeGen.generate(this.context, tb, className, superIsNotBaseClass, this.withinSegment(), fieldsToInit.iterator());
    }

    private void createSetInitValuesMethod(MetaThemenbereich aTb) {
        if (aTb.sizeOfInitialisierungswerte() > 0) {
            MetaCustomInitwert anInitwert;
            this.indentNewLine();
            this.indentNewLine();
            this.out.print("public void ");
            this.out.print("setInitValues");
            this.out.print("(");
            this.out.print("PlausiRuntimeContext");
            this.out.print(" context");
            Iterator it = aTb.getInitialisierungswerte();
            while (it.hasNext()) {
                anInitwert = (MetaCustomInitwert)it.next();
                this.out.print(", ");
                if (anInitwert.getListe()) {
                    this.out.print("Array ");
                } else {
                    this.out.print("Value ");
                }
                this.out.print(StringHelper.getEscapedName(anInitwert.getName()));
            }
            this.out.print(")");
            this.openBlock();
            it = aTb.getInitialisierungswerte();
            while (it.hasNext()) {
                anInitwert = (MetaCustomInitwert)it.next();
                String varname = StringHelper.getEscapedName(anInitwert.getName());
                if (anInitwert.getListe()) {
                    this.indentNewLine();
                    this.out.print("SupportLib.copyArray(");
                    this.out.print(varname);
                    this.out.print(", this.");
                    this.out.print(varname);
                    this.out.print(", context);");
                    continue;
                }
                this.indentNewLine();
                this.out.print("this.");
                this.out.print(varname);
                this.out.print(".set(context, ");
                this.out.print(varname);
                this.out.print(");");
            }
            this.endMethodDefinition();
        }
    }

    private void createGetInstanceMethod(MetaThemenbereich aTb) {
        this.indentNewLine();
        this.defineMethod("public", "TopicField", "getInstance", "int[] indizes");
        this.indentNewLine();
        this.out.print("return new ");
        this.out.print(this.getTbClass(aTb));
        this.out.print("(");
        this.out.print("getVorgaenger");
        this.out.print("(), ");
        this.out.print("getFeldDeskriptor");
        this.out.print("(), indizes);");
        this.endMethodDefinition();
    }

    private void startNewSegment() {
        String baseClassName = "TopicField";
        if (this.withinSegment()) {
            baseClassName = ((SegmentInfo)this.segments.peek()).className;
        }
        String className = this.context.getNextPlausiSegmentClassName();
        String filename = String.valueOf(className) + ".java";
        Writer writer = this.context.createWriter(filename);
        this.segments.push(new SegmentInfo(className, filename, writer, this.out, this.indentLevel()));
        this.setOutput(writer);
        this.setIndentLevel(0);
        this.out.print("package ");
        this.out.print(this.context.getPlausiPackage());
        this.out.print(";");
        this.indentNewLine();
        this.indentNewLine();
        this.out.print("import ");
        this.out.print("de.statspez.pleditor.generator.runtime.");
        this.out.print("*;");
        this.indentNewLine();
        this.out.print("import ");
        this.out.print("de.statspez.pleditor.generator.runtime.plausi.");
        this.out.print("*;");
        this.indentNewLine();
        this.defineClass(className, "public abstract", baseClassName);
    }

    private void startNewSegmentIfNecessary(MetaElement element) {
        if (this.numOfFields >= this.context.getMaxElementsInSegment(5)) {
            this.numOfFields = 1;
            this.startNewSegment();
        } else {
            ++this.numOfFields;
        }
        if (this.withinSegment() && !(element instanceof MetaTBMaterialReferenz)) {
            ((SegmentInfo)this.segments.peek()).fields.add(element);
        } else {
            this.fields.add(element);
        }
    }

    private void closeCurrentSegment(MetaThemenbereich tb) {
        if (this.withinSegment()) {
            SegmentInfo segment = (SegmentInfo)this.segments.peek();
            this.indentNewLine();
            this.createTbConstructor(tb, segment.className, this.segments.size() > 1, segment.fields);
            this.endClassDefinition();
            this.out.flush();
            this.segments.pop();
            this.context.destroyWriter(segment.filename, segment.writer);
            this.out = segment.previousOut;
            this.setIndentLevel(segment.previousIndentLevel);
        }
    }

    private boolean withinSegment() {
        return !this.segments.isEmpty();
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        boolean extend;
        if (tb.sizeOfFelder() + tb.sizeOfVariablen() + tb.sizeOfMaterialreferenzen() + tb.sizeOfInitialisierungswerte() > this.context.getMaxElementsInSegment(5)) {
            extend = true;
            this.startNewSegment();
        } else {
            extend = false;
            this.defineClass(this.getTbClass(tb), "public", "TopicField");
        }
        this.visitElements(tb.getFelder());
        this.visitElements(tb.getVariablen());
        this.visitElements(tb.getMaterialreferenzen());
        this.visitElements(tb.getInitialisierungswerte());
        if (extend) {
            String className = ((SegmentInfo)this.segments.peek()).className;
            while (this.withinSegment()) {
                this.closeCurrentSegment(tb);
            }
            this.defineClass(this.getTbClass(tb), "public", className);
        }
        this.createTbConstructor(tb, this.getTbClass(tb), extend, this.fields);
        this.createGetInstanceMethod(tb);
        this.createSetInitValuesMethod(tb);
        if (((MetaCustomThemenbereich)tb).referencedByErhebung()) {
            this.visitElements(tb.getPruefungen());
            this.visitElements(tb.getAblaeufe());
            this.visitElements(tb.getFunktionen());
        }
        this.endClassDefinition();
    }

    @Override
    public void visitTBFeld(MetaTBFeld aFeld) {
        this.startNewSegmentIfNecessary(aFeld);
        MetaCustomTBFeld feld = (MetaCustomTBFeld)aFeld;
        String type = null;
        if (feld.getKlasse() instanceof MetaMerkmal) {
            type = aFeld.getListe() ? "FeatureArray" : "FeatureVariable";
        } else if (feld.getKlasse() instanceof MetaThemenbereich) {
            if (aFeld.getListe()) {
                type = "TopicArray";
            } else {
                type = this.getTbClass((MetaThemenbereich)feld.getKlasse());
                if (this.withinSegment()) {
                    type = String.valueOf(this.context.getPlausiClassName()) + "." + type;
                }
            }
        } else {
            this.error(aFeld, "Das Feld " + feld.getName() + " hat eine ungueltige Feld-Klasse (" + aFeld.getKlasse() + ")");
        }
        this.indentNewLine();
        this.out.print("public transient ");
        this.out.print(type);
        this.out.print(" ");
        this.out.print(StringHelper.getEscapedName(aFeld.getName()));
        this.out.print(";");
    }

    @Override
    public void visitTBMaterialReferenz(MetaTBMaterialReferenz materialReferenz) {
        this.startNewSegmentIfNecessary(materialReferenz);
        MetaPLMaterial material = materialReferenz.getMaterialbeschreibung();
        MetaCustomThemenbereich materialTb = (MetaCustomThemenbereich)material.getThemenbereich();
        this.indentNewLine();
        this.out.print("public transient ");
        if (this.withinSegment()) {
            this.out.print(this.context.getPlausiClassName());
            this.out.print(".");
        }
        this.out.print("Material");
        this.out.print(this.getTbClass(materialTb));
        this.out.print(" ");
        this.out.print("__material_ref_");
        this.out.print(StringHelper.getEscapedName(materialReferenz.getName()));
        this.out.print(";");
    }

    @Override
    public void visitPLPruefung(MetaPLPruefung aPruefung) {
        MetaCustomPruefung pruefung = (MetaCustomPruefung)aPruefung;
        this.indentNewLine();
        ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        prgGen.setLiteralManager(this.literalManager);
        prgGen.setErrorContext(new ElementMessageContext(1, pruefung.getId(), pruefung.getPruefschluessel(), 6, pruefung.getThemenbereich().getId(), pruefung.getThemenbereich().getName()));
        prgGen.generate(this.context, pruefung.getMetaSpezifikation(), this.scope, false, true, new Short(pruefung.getFehlergewicht()));
        this.indentNewLine();
        String[] referenzFeldStrings = null;
        String[] referenzFeldTypen = null;
        int[][] referenzFeldIndizes = null;
        if (pruefung.sizeOfHauptBezugsfeld() > 0) {
            MetaIdentifier referenzFeld = null;
            Iterator it = pruefung.getHauptBezugsfeld();
            int anzahlBezugsfelder = pruefung.sizeOfHauptBezugsfeld();
            referenzFeldTypen = new String[anzahlBezugsfelder];
            referenzFeldIndizes = new int[anzahlBezugsfelder][];
            boolean ok = true;
            NamespaceHelper nsHelper = new NamespaceHelper();
            int strukturTiefe = 0;
            while (ok && it.hasNext()) {
                ++strukturTiefe;
                referenzFeld = new MetaIdentifier(((MetaStatspezObjekt)it.next()).getName());
                if (!this.scope.isDefined(referenzFeld, nsHelper.namespace())) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' ist nicht definiert");
                    ok = false;
                }
                SymbolDescriptor sd = this.scope.symbolDescriptor(referenzFeld, nsHelper.namespace());
                if (ok && strukturTiefe == anzahlBezugsfelder && sd.isArray() && (pruefung.hauptbezugsfeldIndex() == null || pruefung.hauptbezugsfeldIndex().length == 0)) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' wurde kein Index angegeben.");
                    ok = false;
                }
                if (ok && strukturTiefe == anzahlBezugsfelder && sd.isArray() && pruefung.hauptbezugsfeldIndex() != null) {
                    if (pruefung.hauptbezugsfeldIndex().length != sd.dimensions()) {
                        this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' hat nicht die richtige Dimension " + sd.dimensions() + ".");
                        ok = false;
                    } else {
                        int j = 0;
                        while (j < sd.dimensions() && ok) {
                            if (sd.dimension(j) >= 0 && sd.dimension(j) < pruefung.hauptbezugsfeldIndex()[j] || pruefung.hauptbezugsfeldIndex()[j] <= 0) {
                                String def = sd.dimension(j) >= 0 ? "" + sd.dimension(j) : "N";
                                String ind = pruefung.hauptbezugsfeldIndex()[j] >= 0 ? "" + pruefung.hauptbezugsfeldIndex()[j] : "N";
                                this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Listenfeld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' hat einen inkonsistenten Index " + ind + " au\u00dferhalb des Bereichs bis " + def + ".");
                                ok = false;
                            }
                            ++j;
                        }
                    }
                }
                if (ok && !sd.isTbField()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' ist kein Themenbereichs-Feld");
                    ok = false;
                }
                if (ok && it.hasNext() && !sd.fieldReferencesTb()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' referenziert keinen Themenbereich");
                    ok = false;
                }
                if (ok && !it.hasNext() && sd.fieldReferencesTb()) {
                    this.error(pruefung, "Pr\u00fcfung " + pruefung.getPruefschluessel() + ": das spezifizierte Referenz-Feld '" + nsHelper.prettyNamespacePlusSep() + referenzFeld.value() + "' referenziert einen Themenbereich");
                    ok = false;
                }
                if (ok && sd.isArray()) {
                    if (strukturTiefe == anzahlBezugsfelder) {
                        referenzFeldIndizes[strukturTiefe - 1] = pruefung.hauptbezugsfeldIndex();
                    } else {
                        int[] dims = new int[sd.dimensions()];
                        int i = 0;
                        while (i < dims.length) {
                            dims[i] = 1;
                            ++i;
                        }
                        referenzFeldIndizes[strukturTiefe - 1] = dims;
                    }
                    referenzFeldTypen[strukturTiefe - 1] = sd.fieldReferencesTb() ? StringHelper.getEscapedName("TB_" + sd.getMerkmal()) : "FeatureVariable";
                }
                if (!ok) continue;
                nsHelper.enterSubNamespace(referenzFeld.value());
            }
            referenzFeldStrings = ok ? nsHelper.namespaceAsArray() : null;
        }
        this.createFehlerMethod(this.context, this.scope, this.literalManager, pruefung.getMetaSpezifikation().name(), pruefung.getPruefschluessel(), this.context.getTextResource().getFehlertextKurzProgram(pruefung), this.context.getTextResource().getFehlertextLangProgram(pruefung), this.context.getTextResource().getKorrekturhinweisProgram(pruefung), pruefung.getThemenbereich().getName(), referenzFeldStrings, referenzFeldTypen, referenzFeldIndizes, pruefung.getPruefungsart());
    }

    @Override
    public void visitPLAblauf(MetaPLAblauf ablauf) {
        MetaCustomAblauf a = (MetaCustomAblauf)ablauf;
        this.indentNewLine();
        ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        prgGen.setLiteralManager(this.literalManager);
        prgGen.setErrorContext(new ElementMessageContext(2, a.getId(), a.getName(), 6, a.getThemenbereich().getId(), a.getThemenbereich().getName()));
        prgGen.generate(this.context, a.getMetaSpezifikation(), this.scope, false);
    }

    @Override
    public void visitPLFunktion(MetaPLFunktion funktion) {
        MetaCustomFunktion f = (MetaCustomFunktion)funktion;
        this.indentNewLine();
        ProgramCodeGenerator prgGen = new ProgramCodeGenerator();
        prgGen.setOutput(this.out);
        prgGen.setIndentLevel(this.indentLevel());
        prgGen.setLiteralManager(this.literalManager);
        int contextType = 4;
        if (f.getFunctionType() == 1) {
            contextType = 3;
        }
        prgGen.setErrorContext(new ElementMessageContext(contextType, f.getId(), f.getName(), 6, f.getThemenbereich().getId(), f.getThemenbereich().getName()));
        prgGen.generate(this.context, f.getMetaSpezifikation(), this.scope, true);
    }

    @Override
    public void visitPLVariable(MetaPLVariable variable) {
        this.startNewSegmentIfNecessary(variable);
        this.indentNewLine();
        this.out.print("public transient ");
        if (variable.getListe()) {
            this.out.print("GlobalArray");
        } else {
            this.out.print("GlobalVariable");
        }
        this.out.print(" ");
        this.out.print(StringHelper.getEscapedName(variable.getName()));
        this.out.print(";");
    }

    @Override
    public void visitPLInitwert(MetaPLInitwert initwert) {
        this.startNewSegmentIfNecessary(initwert);
        this.indentNewLine();
        this.out.print("protected transient ");
        if (initwert.getListe()) {
            this.out.print("GlobalArray");
        } else {
            this.out.print("GlobalVariable");
        }
        this.out.print(" ");
        this.out.print(StringHelper.getEscapedName(initwert.getName()));
        this.out.print(";");
    }

    private class SegmentInfo {
        public String className;
        public String filename;
        public Writer writer;
        public PrintWriter previousOut;
        private int previousIndentLevel;
        private Vector fields;

        public SegmentInfo(String className, String filename, Writer writer, PrintWriter previousOut, int previousIndentLevel) {
            this.className = className;
            this.filename = filename;
            this.writer = writer;
            this.previousOut = previousOut;
            this.previousIndentLevel = previousIndentLevel;
            this.fields = new Vector();
        }
    }
}

